/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sharing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.OptimisticLockException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.acquisition.DetectorSettings;
import ome.model.acquisition.Dichroic;
import ome.model.acquisition.Filter;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.Laser;
import ome.model.acquisition.LightPath;
import ome.model.acquisition.LightSettings;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.Microscope;
import ome.model.acquisition.Objective;
import ome.model.acquisition.ObjectiveSettings;
import ome.model.acquisition.TransmittanceRange;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.Pixels;
import ome.model.core.PlaneInfo;
import ome.model.display.ChannelBinding;
import ome.model.display.CodomainMapContext;
import ome.model.display.QuantumDef;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.meta.Experimenter;
import ome.model.meta.Share;
import ome.model.meta.ShareMember;
import ome.model.stats.StatsInfo;
import ome.services.sharing.ShareStore;
import ome.services.sharing.data.Obj;
import ome.services.sharing.data.ShareData;
import ome.services.sharing.data.ShareItem;
import ome.system.OmeroContext;
import ome.tools.hibernate.QueryBuilder;
import ome.tools.hibernate.SessionFactory;
import ome.util.SqlAction;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.EmptyResultDataAccessException;

public class BlobShareStore
extends ShareStore
implements ApplicationContextAware {
    protected SessionFactory __dont_use_me_factory;
    protected OmeroContext ctx;
    protected SqlAction sqlAction;
    protected Map<Long, Long> pixToImageCache = new HashMap<Long, Long>();
    protected Map<Long, List<Long>> obToImageCache = new HashMap<Long, List<Long>>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = (OmeroContext)applicationContext;
    }

    public void setSqlAction(SqlAction sqlAction) {
        this.sqlAction = sqlAction;
    }

    @Override
    public void doInit() {
    }

    @Override
    public Long totalShares() {
        return (Long)this.session().createQuery("select count(id) from Share").uniqueResult();
    }

    @Override
    public Long totalSharedItems() {
        return (Long)this.session().createQuery("select sum(itemCount) from Share").uniqueResult();
    }

    @Override
    public void doSet(Share share, ShareData data, List<ShareItem> items) {
        long oldOptLock = data.optlock;
        long newOptLock = oldOptLock + 1L;
        Session session = this.session();
        List list = session.createQuery("select s from Share s where s.id = " + data.id + " and s.version =" + data.optlock).list();
        if (list.size() == 0) {
            throw new OptimisticLockException("Share " + data.id + " has been updated by someone else.");
        }
        data.optlock = newOptLock;
        share.setData(this.parse(data));
        share.setActive(data.enabled);
        share.setItemCount(Long.valueOf(items.size()));
        share.setVersion((int)newOptLock);
        session.merge((Object)share);
        this.synchronizeMembers(session, data);
    }

    @Override
    public ShareData get(long id) {
        Session session = this.session();
        Share s = (Share)session.get(Share.class, (Serializable)Long.valueOf(id));
        if (s == null) {
            return null;
        }
        byte[] data = s.getData();
        return this.parse(id, data);
    }

    @Override
    public List<ShareData> getShares(long userId, boolean own, boolean activeOnly) {
        Query query;
        List shareIds;
        Session session = this.session();
        QueryBuilder qb = new QueryBuilder();
        qb.select("share.id");
        qb.from("ShareMember", "sm");
        qb.join("sm.parent", "share", false, false);
        qb.where();
        qb.and("sm.child.id = :userId");
        qb.param("userId", (Object)userId);
        if (own) {
            qb.and("share.owner.id = sm.child.id");
        } else {
            qb.and("share.owner.id != sm.child.id");
        }
        if (activeOnly) {
            qb.and("share.active is true");
        }
        if ((shareIds = (query = qb.query(session)).list()).size() == 0) {
            return new ArrayList<ShareData>();
        }
        ArrayList<ShareData> rv = new ArrayList<ShareData>();
        try {
            Map<Long, byte[]> data = this.data(shareIds);
            for (Long id : data.keySet()) {
                byte[] bs = data.get(id);
                ShareData d = this.parse(id, bs);
                rv.add(d);
            }
            return rv;
        }
        catch (EmptyResultDataAccessException empty) {
            return null;
        }
    }

    boolean imagesContainsPixels(Session s, List<Long> images, Pixels pix, Map<Long, Long> cache) {
        Long pixID = pix.getId();
        return this.imagesContainsPixels(s, images, pixID, cache);
    }

    boolean imagesContainsPixels(Session s, List<Long> images, long pixID, Map<Long, Long> cache) {
        Long imgID;
        if (cache.containsKey(pixID)) {
            imgID = cache.get(pixID);
        } else {
            imgID = (Long)s.createQuery("select image.id from Pixels where id = ?").setParameter(0, (Object)pixID).uniqueResult();
            cache.put(pixID, imgID);
        }
        return images.contains(imgID);
    }

    boolean imagesContainsInstrument(Session s, List<Long> images, Instrument instr, Map<Long, List<Long>> cache) {
        List imgIDs;
        if (instr == null) {
            return false;
        }
        Long instrID = instr.getId();
        if (cache.containsKey(instrID)) {
            imgIDs = cache.get(instrID);
        } else {
            imgIDs = s.createQuery("select id from Image where instrument.id = ?").setParameter(0, (Object)instrID).list();
            cache.put(instrID, imgIDs);
        }
        return CollectionUtils.containsAny(images, (Collection)imgIDs);
    }

    boolean imagesContainsObjectiveSettings(Session s, List<Long> images, ObjectiveSettings os, Map<Long, List<Long>> cache) {
        Long osID = os.getId();
        return this.imagesContainsObjectiveSettings(s, images, osID, cache);
    }

    boolean imagesContainsObjectiveSettings(Session s, List<Long> images, long osID, Map<Long, List<Long>> cache) {
        List imgIDs;
        if (cache.containsKey(osID)) {
            imgIDs = cache.get(osID);
        } else {
            imgIDs = s.createQuery("select id from Image where objectiveSettings.id = ?").setParameter(0, (Object)osID).list();
            cache.put(osID, imgIDs);
        }
        return CollectionUtils.containsAny(images, (Collection)imgIDs);
    }

    @Override
    public <T extends IObject> boolean doContains(long sessionId, Class<T> kls, long objId) {
        ShareData data = this.get(sessionId);
        if (data == null) {
            return false;
        }
        return this.doContains(data, kls, objId);
    }

    protected <T extends IObject> boolean doContains(ShareData data, Class<T> kls, long objId) {
        IMutable obj;
        List ids = (List)data.objectMap.get(kls.getName());
        if (ids != null && ids.contains(objId)) {
            return true;
        }
        List images = (List)data.objectMap.get(Image.class.getName());
        Session s = this.session();
        if (Pixels.class.isAssignableFrom(kls)) {
            return this.imagesContainsPixels(s, (List<Long>)images, objId, this.pixToImageCache);
        }
        if (RenderingDef.class.isAssignableFrom(kls)) {
            RenderingDef obj2 = (RenderingDef)s.get(RenderingDef.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsPixels(s, (List<Long>)images, obj2.getPixels(), this.pixToImageCache);
        }
        if (ChannelBinding.class.isAssignableFrom(kls)) {
            ChannelBinding obj3 = (ChannelBinding)s.get(ChannelBinding.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsPixels(s, (List<Long>)images, obj3.getRenderingDef().getPixels(), this.pixToImageCache);
        }
        if (CodomainMapContext.class.isAssignableFrom(kls)) {
            CodomainMapContext obj4 = (CodomainMapContext)s.get(CodomainMapContext.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsPixels(s, (List<Long>)images, obj4.getChannelBinding().getRenderingDef().getPixels(), this.pixToImageCache);
        }
        if (Thumbnail.class.isAssignableFrom(kls)) {
            Thumbnail obj5 = (Thumbnail)s.get(Thumbnail.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsPixels(s, (List<Long>)images, obj5.getPixels(), this.pixToImageCache);
        }
        if (Channel.class.isAssignableFrom(kls)) {
            Channel obj6 = (Channel)s.get(Channel.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsPixels(s, (List<Long>)images, obj6.getPixels(), this.pixToImageCache);
        }
        if (LogicalChannel.class.isAssignableFrom(kls)) {
            obj = (LogicalChannel)s.get(LogicalChannel.class, (Serializable)Long.valueOf(objId));
            Iterator<Channel> it = ((LogicalChannel)obj).iterateChannels();
            while (it.hasNext()) {
                Channel ch = it.next();
                if (!images.contains(ch.getPixels().getImage().getId())) continue;
                return true;
            }
        } else {
            if (PlaneInfo.class.isAssignableFrom(kls)) {
                PlaneInfo obj7 = (PlaneInfo)s.get(PlaneInfo.class, (Serializable)Long.valueOf(objId));
                return this.imagesContainsPixels(s, (List<Long>)images, obj7.getPixels(), this.pixToImageCache);
            }
            if (StatsInfo.class.isAssignableFrom(kls) || QuantumDef.class.isAssignableFrom(kls) || LightPath.class.isAssignableFrom(kls) || Microscope.class.isAssignableFrom(kls) || TransmittanceRange.class.isAssignableFrom(kls)) {
                return true;
            }
        }
        if (ObjectiveSettings.class.isAssignableFrom(kls)) {
            obj = (ObjectiveSettings)s.get(ObjectiveSettings.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsObjectiveSettings(s, (List<Long>)images, (ObjectiveSettings)obj, this.obToImageCache);
        }
        if (Objective.class.isAssignableFrom(kls)) {
            obj = (Objective)s.get(Objective.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((Objective)obj).getInstrument(), this.obToImageCache);
        }
        if (Detector.class.isAssignableFrom(kls)) {
            obj = (Detector)s.get(Detector.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((Detector)obj).getInstrument(), this.obToImageCache);
        }
        if (Dichroic.class.isAssignableFrom(kls)) {
            obj = (Dichroic)s.get(Dichroic.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((Dichroic)obj).getInstrument(), this.obToImageCache);
        }
        if (FilterSet.class.isAssignableFrom(kls)) {
            obj = (FilterSet)s.get(FilterSet.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((FilterSet)obj).getInstrument(), this.obToImageCache);
        }
        if (Filter.class.isAssignableFrom(kls)) {
            obj = (Filter)s.get(Filter.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((Filter)obj).getInstrument(), this.obToImageCache);
        }
        if (LightSource.class.isAssignableFrom(kls)) {
            obj = (LightSource)s.get(LightSource.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((LightSource)obj).getInstrument(), this.obToImageCache);
        }
        if (Laser.class.isAssignableFrom(kls)) {
            obj = (Laser)s.get(Laser.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((LightSource)obj).getInstrument(), this.obToImageCache);
        }
        if (LightSettings.class.isAssignableFrom(kls)) {
            obj = (LightSettings)s.get(LightSettings.class, (Serializable)Long.valueOf(objId));
            return this.imagesContainsInstrument(s, images, ((LightSettings)obj).getLightSource().getInstrument(), this.obToImageCache);
        }
        if (DetectorSettings.class.isAssignableFrom(kls)) {
            obj = (DetectorSettings)s.get(DetectorSettings.class, (Serializable)Long.valueOf(objId));
            if (this.imagesContainsInstrument(s, images, ((DetectorSettings)obj).getDetector().getInstrument(), this.obToImageCache)) {
                return true;
            }
            List lcs = s.createQuery("select l from LogicalChannel l where l.detectorSettings.id = " + ((DetectorSettings)obj).getId()).list();
            for (LogicalChannel lc : lcs) {
                if (!this.doContains(data, LogicalChannel.class, (long)lc.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doClose() {
    }

    @Override
    public Set<Long> keys() {
        Session session = this.session();
        List list = session.createQuery("select id from Share").list();
        return new HashSet<Long>(list);
    }

    private Map<Long, byte[]> data(List<Long> ids) {
        return this.sqlAction.getShareData(ids);
    }

    private Session session() {
        return this.initialize().getSession();
    }

    private synchronized SessionFactory initialize() {
        if (this.__dont_use_me_factory != null) {
            return this.__dont_use_me_factory;
        }
        if (this.ctx == null) {
            throw new IllegalStateException("Have no context to load factory");
        }
        this.__dont_use_me_factory = (SessionFactory)this.ctx.getBean("omeroSessionFactory");
        if (this.__dont_use_me_factory == null) {
            throw new IllegalStateException("Cannot find factory");
        }
        this.init();
        return this.__dont_use_me_factory;
    }

    private void synchronizeMembers(Session session, ShareData data) {
        Query q = session.createQuery("select sm from ShareMember sm where sm.parent = ?");
        q.setLong(0, data.id);
        List members = q.list();
        HashMap<Long, ShareMember> lookup = new HashMap<Long, ShareMember>();
        for (ShareMember sm : members) {
            lookup.put(sm.getChild().getId(), sm);
        }
        HashSet<Long> intendedUserIds = new HashSet<Long>(data.members);
        intendedUserIds.add(data.owner);
        Set currentUserIds = lookup.keySet();
        HashSet added = new HashSet(intendedUserIds);
        added.removeAll(currentUserIds);
        for (Long toAdd : added) {
            ShareMember sm = new ShareMember();
            sm.link(new Share(data.id, false), new Experimenter(toAdd, false));
            session.merge((Object)sm);
        }
        HashSet removed = new HashSet(currentUserIds);
        removed.removeAll(intendedUserIds);
        for (Long toRemove : removed) {
            session.delete(lookup.get(toRemove));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BlobShareStore store = new BlobShareStore();
        ShareData template = new ShareData();
        template.enabled = true;
        template.guests = Arrays.asList("a", "b", "c");
        template.id = 100L;
        template.members = Arrays.asList(1L, 2L, 3L);
        template.objectList = Arrays.asList(new Obj("type", 200L));
        template.objectMap = new HashMap();
        template.objectMap.put("type", Arrays.asList(100L));
        template.optlock = 12345L;
        template.owner = 67890L;
        File file2 = new File(args[0]);
        if (file2.exists()) {
            int size = (int)file2.length();
            byte[] buf = new byte[size];
            FileInputStream fis = new FileInputStream(file2);
            fis.read(buf);
            ShareData data = store.parse(1L, buf);
            if (data == null) {
                System.out.println("No share found");
                System.exit(100);
            }
            System.out.println("enabled:" + data.enabled);
            System.out.println("guests:" + data.guests);
            System.out.println("id:" + data.id);
            System.out.println("members:" + data.members);
            System.out.println("objectList:" + data.objectList);
            System.out.println("objectMap:" + data.objectMap);
            System.out.println("optlock:" + data.optlock);
            System.out.println("owner:" + data.owner);
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file2);
                byte[] buf = store.parse(template);
                fos.write(buf);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        System.exit(0);
    }
}

