/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.AuthenticationException;
import ome.conditions.InternalException;
import ome.conditions.RemovedSessionException;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionException;
import ome.conditions.SessionTimeoutException;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.model.enums.EventType;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.parameters.Filter;
import ome.parameters.Parameters;
import ome.security.basic.PrincipalHolder;
import ome.services.messages.CreateSessionMessage;
import ome.services.messages.DestroySessionMessage;
import ome.services.sessions.InternalSessionContext;
import ome.services.sessions.SessionCallback;
import ome.services.sessions.SessionContext;
import ome.services.sessions.SessionContextImpl;
import ome.services.sessions.SessionManager;
import ome.services.sessions.events.ChangeSecurityContextEvent;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.services.sessions.state.SessionCache;
import ome.services.sessions.stats.CounterFactory;
import ome.services.sessions.stats.SessionStats;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.transaction.annotation.Transactional;

public class SessionManagerImpl
implements SessionManager,
SessionCache.StaleCacheListener,
ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    public static final String GROUP_SUDO_NS = "openmicroscopy.org/security/group-sudo";
    private static final Logger log = LoggerFactory.getLogger(SessionManagerImpl.class);
    private String internal_uuid = UUID.randomUUID().toString();
    protected OmeroContext context;
    protected Roles roles;
    protected SessionCache cache;
    protected Executor executor;
    protected long defaultTimeToIdle;
    protected long maxUserTimeToIdle;
    protected long defaultTimeToLive;
    protected long maxUserTimeToLive;
    protected PrincipalHolder principalHolder;
    protected CounterFactory factory;
    protected boolean readOnly = false;
    protected Principal asroot;
    protected SessionContext internalSession;
    private static final String findBy1 = "select s.id, s.uuid from Session s join s.owner o where s.closed is null and o.omeName = :name ";
    private static final String findByOrder = "order by s.started desc";
    static String INPUT_ENVIRONMENT = "InputEnvironment";
    static String OUTPUT_ENVIRONMENT = "OutputEnvironment";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (OmeroContext)applicationContext;
    }

    public void setUuid(String uuid) {
        this.internal_uuid = uuid;
    }

    public void setSessionCache(SessionCache sessionCache) {
        this.cache = sessionCache;
        this.cache.setStaleCacheListener(this);
    }

    public void setRoles(Roles securityRoles) {
        this.roles = securityRoles;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDefaultTimeToIdle(long defaultTimeToIdle) {
        this.defaultTimeToIdle = defaultTimeToIdle;
        this.maxUserTimeToIdle = Math.min(0xCCCCCCCCCCCCCCCL, defaultTimeToIdle);
        this.maxUserTimeToIdle *= 10L;
    }

    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
        this.maxUserTimeToLive = Math.min(0xCCCCCCCCCCCCCCCL, defaultTimeToLive);
        this.maxUserTimeToLive *= 10L;
    }

    public void setPrincipalHolder(PrincipalHolder principal) {
        this.principalHolder = principal;
    }

    public void setCounterFactory(CounterFactory factory) {
        this.factory = factory;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void init() {
        try {
            this.asroot = new Principal(this.internal_uuid, "system", "Sessions");
            Session session = this.executeInternalSession();
            this.internalSession = new InternalSessionContext(session, this.roles);
            this.cache.putSession(this.internal_uuid, this.internalSession);
        }
        catch (UncategorizedSQLException uncat) {
            log.warn("Assuming that this is read-only");
        }
        catch (DataAccessException dataAccess) {
            throw new RuntimeException("          =====================================================\nData access exception: Did you create your database? \n=====================================================\n", dataAccess);
        }
    }

    protected void define(Session s, String uuid, String message, long started, SessionManager.CreationRequest req) {
        Long idle = req.timeToIdle == null ? this.defaultTimeToIdle : req.timeToIdle;
        Long live = req.timeToLive == null ? this.defaultTimeToLive : req.timeToLive;
        if (req.groupsLed != null) {
            CommentAnnotation ca = new CommentAnnotation();
            ca.setNs(GROUP_SUDO_NS);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < req.groupsLed.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(req.groupsLed.get(i));
            }
            ca.setTextValue(sb.toString());
            s.linkAnnotation(ca);
        }
        this.define(s, uuid, message, started, idle, live, req.principal.getEventType(), req.agent, req.ip);
    }

    protected void define(Session s, String uuid, String message, long started, long idle, long live, String eventType, String agent, String ip) {
        s.getDetails().setPermissions(Permissions.PRIVATE);
        s.setUuid(uuid);
        s.setMessage(message);
        s.setStarted(new Timestamp(started));
        s.setTimeToIdle(idle);
        s.setTimeToLive(live);
        s.setDefaultEventType(eventType);
        s.setUserAgent(agent);
        s.setUserIP(ip);
    }

    @Override
    public Session createFromRequest(SessionManager.CreationRequest request) {
        if (request.credentials != null) {
            boolean ok;
            try {
                SessionContext context = this.cache.getSessionContext(request.credentials);
                if (context != null) {
                    context.count().increment();
                    return context.getSession();
                }
            }
            catch (SessionException context) {
                // empty catch block
            }
            boolean bl = ok = request.principal == null ? false : this.executeCheckPassword(request.principal, request.credentials);
            if (!ok) {
                log.warn("Failed to authenticate: " + request.principal);
                throw new AuthenticationException("Authentication exception.");
            }
        }
        Session session = new Session();
        this.define(session, UUID.randomUUID().toString(), "Initial message.", System.currentTimeMillis(), request);
        return this.createSession(request, session);
    }

    @Override
    public Session createWithAgent(Principal _principal, String credentials, String agent, String ip) {
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = _principal;
        req.credentials = credentials;
        req.agent = agent;
        req.ip = ip;
        return this.createFromRequest(req);
    }

    @Override
    public Session createWithAgent(Principal principal, String agent, String ip) {
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = principal;
        req.agent = agent;
        req.ip = ip;
        return this.createFromRequest(req);
    }

    @Override
    public Share createShare(Principal principal, boolean enabled, long timeToLive, String eventType, String description, long groupId) {
        Share share = this.newShare();
        this.define(share, UUID.randomUUID().toString(), description, System.currentTimeMillis(), this.defaultTimeToIdle, timeToLive, eventType, "Share", null);
        share.setGroup(new ExperimenterGroup(groupId, false));
        share.setActive(enabled);
        share.setData(new byte[0]);
        share.setItemCount(0L);
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = principal;
        return (Share)this.createSession(req, share);
    }

    private Session createSession(final SessionManager.CreationRequest req, final Session oldsession) {
        Principal principal = req.principal;
        try {
            SessionContext context = this.cache.getSessionContext(principal.getName());
            if (context != null) {
                context.count().increment();
                return context.getSession();
            }
        }
        catch (SessionException context) {
            // empty catch block
        }
        HashMap<String, String> sysContext = new HashMap<String, String>();
        sysContext.put("omero.group", Long.toString(this.roles.getSystemGroupId()));
        List rv = this.readOnly ? (List)this.executor.execute(sysContext, this.asroot, new Executor.SimpleWork(this, "read-only createSession", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                Principal p = SessionManagerImpl.this.validateSessionInputs(sf, req);
                SessionManagerImpl.this.executeLookupUser(sf, p);
                Session s = oldsession;
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, s);
            }
        }) : (List)this.executor.execute(sysContext, this.asroot, new Executor.SimpleWork(this, "createSession", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                Principal p = SessionManagerImpl.this.validateSessionInputs(sf, req);
                oldsession.setDefaultEventType(p.getEventType());
                long userId = SessionManagerImpl.this.executeLookupUser(sf, p);
                Session s = SessionManagerImpl.this.executeUpdate(sf, oldsession, userId);
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, s);
            }
        });
        if (rv == null) {
            throw new RemovedSessionException("No info in database for " + principal);
        }
        SessionContext newctx = this.createSessionContext(rv, null);
        String uuid = newctx.getCurrentSessionUuid();
        this.cache.putSession(uuid, newctx);
        try {
            this.context.publishEvent(new CreateSessionMessage(this, uuid));
        }
        catch (RuntimeException re) {
            log.warn("Session creation cancelled by event listener", re);
            this.cache.removeSession(uuid);
            throw re;
        }
        newctx.count().increment();
        return newctx.getSession();
    }

    @Override
    public Session update(Session session) {
        return this.update(session, false);
    }

    @Override
    public Session update(final Session session, final boolean trusted) {
        if (session == null || !session.isLoaded() || session.getUuid() == null) {
            throw new RemovedSessionException("Cannot update; No uuid.");
        }
        String uuid = session.getUuid();
        final Details details = session.getDetails();
        final SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("Can't update; No session with uuid:" + uuid);
        }
        final Session orig = ctx.getSession();
        List list = (List)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "load_for_update", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                ExperimenterGroup group;
                String defaultGroup = null;
                if (details != null && (group = details.getGroup()) != null) {
                    try {
                        Long groupId = group.getId();
                        if (groupId != null && (group = ((LocalAdmin)sf.getAdminService()).groupProxy(groupId)) != null) {
                            defaultGroup = group.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new ApiUsageException("Cannot change default group to " + group + "\n" + e.getMessage());
                    }
                }
                if (defaultGroup == null) {
                    defaultGroup = ctx.getCurrentGroupName();
                }
                Principal principal = new Principal(ctx.getCurrentUserName(), defaultGroup, ctx.getCurrentEventType());
                SessionManager.CreationRequest req = new SessionManager.CreationRequest();
                req.principal = principal;
                principal = SessionManagerImpl.this.validateSessionInputs(sf, req);
                SessionManagerImpl.this.parseAndSetDefaultType(session.getDefaultEventType(), orig);
                SessionManagerImpl.this.parseAndSetUserAgent(session.getUserAgent(), orig);
                SessionManagerImpl.this.parseAndSetTimeouts(session.getTimeToLive(), session.getTimeToIdle(), orig, trusted);
                return SessionManagerImpl.this.executeSessionContextLookup(sf, principal, orig);
            }
        });
        if (list == null) {
            log.info("removeSession on update: " + uuid);
            this.cache.removeSession(uuid);
            throw new RemovedSessionException("Database contains no info for " + uuid);
        }
        final SessionContext newctx = this.createSessionContext(list, ctx);
        final Session copy = this.copy(orig);
        this.executor.execute(this.asroot, new Executor.SimpleWork(this, "update", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                return SessionManagerImpl.this.executeUpdate(sf, copy, newctx.getCurrentUserId());
            }
        });
        this.cache.putSession(uuid, newctx);
        return this.copy(orig);
    }

    protected SessionContext createSessionContext(List<?> list, SessionContext previous) {
        Experimenter exp = (Experimenter)list.get(0);
        ExperimenterGroup grp = (ExperimenterGroup)list.get(1);
        List memberOfGroupsIds = (List)list.get(2);
        List leaderOfGroupsIds = (List)list.get(3);
        List userRoles = (List)list.get(4);
        Principal principal = (Principal)list.get(5);
        Session session = (Session)list.get(6);
        this.parseAndSetDefaultType(principal.getEventType(), session);
        session.getDetails().setOwner(exp);
        session.getDetails().setGroup(grp);
        SessionContextImpl sessionContext = new SessionContextImpl(session, leaderOfGroupsIds, memberOfGroupsIds, userRoles, this.factory.createStats(), this.roles, previous);
        return sessionContext;
    }

    @Override
    public Session find(String uuid) {
        SessionContext sessionContext = this.cache.getSessionContext(uuid);
        this.checkIfShare(sessionContext);
        return sessionContext == null ? null : sessionContext.getSession();
    }

    private void checkIfShare(SessionContext sessionContext) {
        if (sessionContext.getSession() instanceof Share) {
            Long id = sessionContext.getSession().getId();
            String uuid = sessionContext.getSession().getUuid();
            String prefix = String.format("Share:%s (%s)", id, uuid);
            List<Object[]> rv = this.executeProjection("select s.active, s.timeToLive, s.started from Share s where s.id = :id", new Parameters().addId(sessionContext.getSession().getId()));
            if (rv.size() != 1) {
                throw new RuntimeException(prefix + " could not be found!");
            }
            Object[] items = rv.get(0);
            Boolean active = (Boolean)items[0];
            Long timeToLive = (Long)items[1];
            Timestamp started = (Timestamp)items[2];
            if (Boolean.FALSE.equals(active)) {
                throw new SecurityViolation(prefix + " is inactive");
            }
            if (System.currentTimeMillis() - started.getTime() > timeToLive) {
                String msg = String.format("%s has expired: %s, timeToLive=%s", prefix, started, timeToLive);
                throw new SecurityViolation(msg);
            }
        }
    }

    private List<Session> findByQuery(String query, Parameters p) {
        List<Object[]> ids_uuids = this.executeProjection(query, p);
        ArrayList<Session> rv = new ArrayList<Session>();
        for (Object[] arr : ids_uuids) {
            String uuid = (String)arr[1];
            try {
                SessionContext sc = this.cache.getSessionContext(uuid);
                rv.add(sc.getSession());
            }
            catch (Exception exception) {}
        }
        return rv;
    }

    @Override
    public List<Session> findByUser(String user) {
        return this.findByQuery("select s.id, s.uuid from Session s join s.owner o where s.closed is null and o.omeName = :name order by s.started desc", new Parameters().addString("name", user));
    }

    @Override
    public List<Session> findByUserAndAgent(String user, String ... agents) {
        StringBuilder sb = new StringBuilder();
        sb.append(findBy1);
        Parameters p = new Parameters().addString("name", user);
        if (agents == null || agents.length == 0 || agents.length == 1 && agents[0] == null) {
            sb.append("and s.userAgent is null ");
        } else {
            sb.append("and s.userAgent in (:agents) ");
            p.addList("agents", Arrays.asList(agents));
        }
        sb.append(findByOrder);
        return this.findByQuery(sb.toString(), p);
    }

    @Override
    public int getReferenceCount(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.count().get();
    }

    @Override
    public int detach(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.count().decrement();
    }

    @Override
    public SessionStats getSessionStats(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.stats();
    }

    @Override
    public int close(String uuid) {
        SessionContext ctx;
        try {
            ctx = this.cache.getSessionContext(uuid);
        }
        catch (SessionException se) {
            log.info("closeSession called but doesn't exist: " + uuid);
            return -1;
        }
        int refCount = ctx.count().decrement();
        if (refCount < 1) {
            log.info("closeSession called and no more references: " + uuid);
            this.cache.removeSession(uuid);
            return -2;
        }
        log.info("closeSession called but " + refCount + " more references: " + uuid);
        return refCount;
    }

    @Override
    public Map<String, Map<String, Object>> getSessionData() {
        Set<String> ids = this.cache.getIds();
        HashMap<String, Map<String, Object>> rv = new HashMap<String, Map<String, Object>>();
        for (String id : ids) {
            if (this.asroot.getName().equals(id)) continue;
            try {
                rv.put(id, this.cache.getSessionData(id, true));
            }
            catch (RemovedSessionException removedSessionException) {
            }
            catch (SessionTimeoutException sessionTimeoutException) {
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown on getAll: %s:%s", e.getClass().getName(), e.getMessage()));
            }
        }
        return rv;
    }

    @Override
    public int closeAll() {
        Set<String> ids = this.cache.getIds();
        for (String id : ids) {
            if (this.asroot.getName().equals(id)) continue;
            try {
                log.info("closeAll called for " + id);
                this.cache.removeSession(id);
            }
            catch (RemovedSessionException removedSessionException) {
            }
            catch (SessionTimeoutException sessionTimeoutException) {
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown on closeAll: %s:%s", e.getClass().getName(), e.getMessage()));
            }
        }
        return ids.size();
    }

    @Override
    public List<String> getUserRoles(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid: " + uuid);
        }
        return ctx.getUserRoles();
    }

    @Override
    public Ehcache inMemoryCache(String uuid) {
        return this.cache.inMemoryCache(uuid);
    }

    @Override
    public Ehcache onDiskCache(String uuid) {
        return this.cache.onDiskCache(uuid);
    }

    @Override
    public Object getInput(String session, String key) throws RemovedSessionException {
        return this.getEnvironmentVariable(session, key, INPUT_ENVIRONMENT);
    }

    @Override
    public Object getOutput(String session, String key) throws RemovedSessionException {
        return this.getEnvironmentVariable(session, key, OUTPUT_ENVIRONMENT);
    }

    @Override
    public Map<String, Object> inputEnvironment(String session) {
        return this.environment(session, INPUT_ENVIRONMENT);
    }

    @Override
    public Map<String, Object> outputEnvironment(String session) {
        return this.environment(session, OUTPUT_ENVIRONMENT);
    }

    protected Map<String, Object> environment(String session, String env) {
        this.getReferenceCount(session);
        HashMap<String, Object> rv = new HashMap<String, Object>();
        Element elt = this.inMemoryCache(session).get((Serializable)((Object)env));
        if (elt == null) {
            return rv;
        }
        Map cv = (Map)elt.getObjectValue();
        if (cv == null) {
            return rv;
        }
        rv.putAll(cv);
        return rv;
    }

    @Override
    public void setInput(String session, String key, Object object) throws RemovedSessionException {
        this.setEnvironmentVariable(session, key, object, INPUT_ENVIRONMENT);
    }

    @Override
    public void setOutput(String session, String key, Object object) throws RemovedSessionException {
        this.setEnvironmentVariable(session, key, object, OUTPUT_ENVIRONMENT);
    }

    private Object getEnvironmentVariable(String session, String key, String env) {
        Ehcache cache = this.inMemoryCache(session);
        Element elt = cache.get((Serializable)((Object)env));
        if (elt == null) {
            return null;
        }
        Map map = (Map)elt.getObjectValue();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    private void setEnvironmentVariable(String session, String key, Object object, String env) {
        ConcurrentMap<String, Object> map;
        Ehcache cache = this.inMemoryCache(session);
        Element elt = cache.get((Serializable)((Object)env));
        if (elt == null) {
            map = new MapMaker().makeMap();
            elt = new Element((Object)env, map);
            cache.put(elt);
        } else {
            map = (ConcurrentMap<String, Object>)elt.getObjectValue();
        }
        if (object == null) {
            map.remove(key);
        } else {
            map.put(key, object);
        }
    }

    @Override
    public EventContext getEventContext(Principal principal) {
        SessionContext ctx = this.cache.getSessionContext(principal.getName());
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid:" + principal.getName());
        }
        return ctx;
    }

    @Override
    public EventContext reload(final String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid:" + uuid);
        }
        Future<Object> future = this.executor.submit(Executor.Priority.SYSTEM, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SessionManagerImpl.this.cache.reload(uuid);
                return null;
            }
        });
        this.executor.get(future);
        return this.cache.getSessionContext(uuid);
    }

    public String[] notifications(String sessionId) {
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof UserGroupUpdateEvent) {
            this.cache.updateEvent((UserGroupUpdateEvent)event);
        } else if (event instanceof DestroySessionMessage) {
            this.executeCloseSession(((DestroySessionMessage)event).getSessionId());
        }
    }

    public void addCallback(String sessionId, SessionCallback cb) {
    }

    public Object getCallbackObject(String sessionId, String name) {
        return null;
    }

    private Principal validateSessionInputs(ServiceFactory sf, SessionManager.CreationRequest req) {
        long gid;
        String group;
        Principal p = req.principal;
        if (p == null || p.getName() == null) {
            throw new ApiUsageException("Null principal name.");
        }
        String type = p.getEventType();
        if (StringUtils.isEmpty(type)) {
            type = "User";
        }
        if (StringUtils.isEmpty(group = p.getGroup())) {
            group = "user";
        }
        if (this.roles.getUserGroupName().equals(group)) {
            ExperimenterGroup g = this._getDefaultGroup(sf, p.getName());
            if (g == null) {
                throw new ApiUsageException("Can't find default group for " + p.getName());
            }
            group = g.getName();
        }
        if (req.groupsLed != null && !req.groupsLed.contains(gid = sf.getAdminService().lookupGroup(group).getId().longValue())) {
            throw new SecurityViolation(String.format("Group sudo is not permitted for group %s (gid=%s)", group, gid));
        }
        type = sf.getTypesService().getEnumeration(EventType.class, type).getValue();
        Principal copy = new Principal(p.getName(), group, type);
        return copy;
    }

    private void parseAndSetDefaultType(String type, Session session) {
        String _type = type == null ? "User" : type;
        session.setDefaultEventType(_type);
    }

    private void parseAndSetUserAgent(String userAgent, Session session) {
        session.setUserAgent(userAgent);
    }

    private void parseAndSetTimeouts(Long timeToLive, Long timeToIdle, Session session, boolean trusted) {
        if (timeToLive != null) {
            if (trusted) {
                session.setTimeToLive(timeToLive);
            } else {
                long activeTTL = Math.min(this.maxUserTimeToLive, timeToLive);
                if (activeTTL == 0L && this.defaultTimeToLive != 0L) {
                    throw new SecurityViolation("Cannot disable timeToLive. Value must be between 1 and " + this.maxUserTimeToLive);
                }
                session.setTimeToLive(activeTTL);
            }
        }
        if (timeToIdle != null) {
            if (trusted) {
                session.setTimeToIdle(timeToIdle);
            } else {
                long activeTTI = Math.min(this.maxUserTimeToIdle, timeToIdle);
                if (activeTTI == 0L && this.defaultTimeToIdle != 0L) {
                    throw new SecurityViolation("Cannot disable timeToIdle. Value must be between 1 and " + this.maxUserTimeToIdle);
                }
                session.setTimeToIdle(activeTTI);
            }
        }
    }

    public Session copy(Session source) {
        if (source == null) {
            throw new ApiUsageException("Source may not be null.");
        }
        Session target = source instanceof Share ? this.newShare() : new Session();
        target.setId(source.getId());
        target.setClosed(source.getClosed());
        target.setDefaultEventType(source.getDefaultEventType());
        target.getDetails().shallowCopy(source.getDetails());
        target.setMessage(source.getMessage());
        target.setNode(source.getNode());
        target.setStarted(source.getStarted());
        target.setTimeToIdle(source.getTimeToIdle());
        target.setTimeToLive(source.getTimeToLive());
        target.setUserAgent(source.getUserAgent());
        target.setUuid(source.getUuid());
        if (target instanceof Share) {
            Share to = (Share)target;
            Share from = (Share)source;
            to.setItemCount(from.getItemCount());
            to.setActive(from.getActive());
            to.setGroup(from.getGroup());
            to.setData(from.getData());
        }
        return target;
    }

    public void prepareReload() {
    }

    @Override
    public SessionContext reload(final SessionContext ctx) {
        final Principal p = new Principal(ctx.getCurrentUserName(), ctx.getCurrentGroupName(), ctx.getCurrentEventType());
        List list = (List)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "reload", new Object[]{ctx.getSession().getUuid()}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, ctx.getSession());
            }
        });
        if (list == null) {
            return null;
        }
        return this.createSessionContext(list, ctx);
    }

    private List<Object[]> executeProjection(final String projection, final Parameters parameters) {
        return (List)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "executeProjection", new Object[]{projection}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return sf.getQueryService().projection(projection, parameters);
            }
        });
    }

    @Override
    public boolean executePasswordCheck(String name, String credentials) {
        if (this.cache.getIds().contains(credentials)) {
            return true;
        }
        return this.executeCheckPassword(new Principal(name), credentials);
    }

    private Session executeUpdate(ServiceFactory sf, Session session, long userId) {
        Node node = (Node)sf.getQueryService().findByQuery("select n from Node n where uuid = :uuid", new Parameters().addString("uuid", this.internal_uuid).setFilter(new Filter().page(0, 1)));
        if (node == null) {
            node = new Node(0L, false);
        }
        session.setNode(node);
        session.setOwner(new Experimenter(userId, false));
        Session rv = sf.getUpdateService().saveAndReturnObject(session);
        rv.putAt("#2733", session.retrieve("#2733"));
        return rv;
    }

    private boolean executeCheckPassword(Principal _principal, String credentials) {
        Boolean ok = this.executeCheckPasswordRO(_principal, credentials);
        if (ok == null) {
            ok = this.executeCheckPasswordRW(_principal, credentials);
        }
        return ok;
    }

    private Boolean executeCheckPasswordRO(final Principal _principal, final String credentials) {
        return (Boolean)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "executeCheckPasswordRO", new Object[]{_principal}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                try {
                    return ((LocalAdmin)sf.getAdminService()).checkPassword(_principal.getName(), credentials, true);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private Boolean executeCheckPasswordRW(final Principal _principal, final String credentials) {
        return (Boolean)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "executeCheckPasswordRW", new Object[]{_principal}){

            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return ((LocalAdmin)sf.getAdminService()).checkPassword(_principal.getName(), credentials, false);
            }
        });
    }

    private Session executeCloseSession(final String uuid) {
        return (Session)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeCloseSession", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                try {
                    int count = sql.closeSessions(uuid);
                    if (count == 0) {
                        log.warn("No session updated on closeSession:" + uuid);
                    } else {
                        log.debug("Session.closed set to now() for " + uuid);
                    }
                }
                catch (Exception e) {
                    log.error("FAILED TO CLOSE SESSION IN DATABASE: " + uuid, e);
                }
                return null;
            }
        });
    }

    private Session executeInternalSession() {
        final Long sessionId = this.executeNextSessionId();
        return (Session)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeInternalSession", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                Session s = new Session();
                SessionManagerImpl.this.define(s, SessionManagerImpl.this.internal_uuid, "Session Manager internal", System.currentTimeMillis(), Long.MAX_VALUE, 0L, "Sessions", "Internal", null);
                long nodeId = 0L;
                try {
                    nodeId = sql.nodeId(SessionManagerImpl.this.internal_uuid);
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    // empty catch block
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("sid", sessionId);
                params.put("ttl", s.getTimeToLive());
                params.put("tti", s.getTimeToIdle());
                params.put("start", s.getStarted());
                params.put("type", s.getDefaultEventType());
                params.put("uuid", s.getUuid());
                params.put("node", nodeId);
                params.put("owner", SessionManagerImpl.this.roles.getRootId());
                params.put("agent", s.getUserAgent());
                params.put("ip", s.getUserIP());
                int count = sql.insertSession(params);
                if (count == 0) {
                    throw new InternalException("Failed to insert new session: " + s.getUuid());
                }
                Long id = sql.sessionId(s.getUuid());
                s.setId(id);
                return s;
            }
        });
    }

    private Long executeNextSessionId() {
        return (Long)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeNextSessionId", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(SqlAction sql) {
                return sql.nextSessionId();
            }
        });
    }

    @Override
    public IObject setSecurityContext(Principal principal, IObject obj) {
        Long id;
        Long l = id = obj == null ? null : obj.getId();
        if (id == null) {
            throw new ApiUsageException("Security context must be managed!");
        }
        SessionContext sc = this.cache.getSessionContext(principal.getName());
        TextAnnotation ta = null;
        for (Annotation a : sc.getSession().linkedAnnotationList()) {
            if (a instanceof TextAnnotation && this.roles.isRootUser(a.getDetails().getOwner()) && GROUP_SUDO_NS.equals(a.getNs())) {
                ta = (TextAnnotation)a;
            }
            if (ta == null) continue;
            String[] groupIds = ta.getTextValue().split(",");
            throw new SecurityViolation("Group-sudo session cannot change context!");
        }
        long activeMethods = sc.stats().methodCount();
        if (activeMethods != 0L) {
            throw new SecurityViolation(activeMethods + " methods active. Aborting!");
        }
        Long shareId = sc.getCurrentShareId();
        Long groupId = sc.getCurrentGroupId();
        IGlobal prevCtx = null;
        prevCtx = shareId != null ? new Share(shareId, false) : new ExperimenterGroup(groupId, false);
        ChangeSecurityContextEvent csce = new ChangeSecurityContextEvent(this, principal.getName(), prevCtx, obj);
        try {
            this.context.publishMessage(csce);
            csce.throwIfCancelled();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            InternalException ie = new InternalException("Failed to set call publishMessage");
            ie.initCause(e);
            throw ie;
        }
        if (obj instanceof ExperimenterGroup) {
            this.setGroupSecurityContext(principal, id);
        } else if (obj instanceof Share) {
            this.setShareSecurityContext(principal, id);
        } else {
            throw new ApiUsageException("Unknown security context:" + obj);
        }
        return prevCtx;
    }

    private void setGroupSecurityContext(final Principal principal, final Long id) {
        final EventContext ec = this.getEventContext(principal);
        final ExperimenterGroup[] group = new ExperimenterGroup[1];
        final Session s = (Session)this.executor.execute(principal, new Executor.SimpleWork(this, "setGroupSecurityContext", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                if (ec.getCurrentShareId() != null) {
                    sf.getShareService().deactivate();
                }
                SessionContext sc = SessionManagerImpl.this.cache.getSessionContext(principal.getName());
                Session s = sc.getSession();
                if (!sc.isCurrentUserAdmin() && id >= 0L && !sc.getMemberOfGroupsList().contains(id)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("User ");
                    sb.append(sc.getCurrentUserId());
                    sb.append(" is not a member of group ");
                    sb.append(id);
                    throw new SecurityViolation(sb.toString());
                }
                group[0] = s.getDetails().getGroup();
                s.getDetails().setGroup(sf.getAdminService().getGroup(id));
                return s;
            }
        });
        this.executor.execute(principal, new Executor.SimpleWork(this, "checkGroupSecurityContext", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                try {
                    sf.getAdminService().getEventContext();
                }
                catch (RuntimeException re) {
                    s.getDetails().setGroup(group[0]);
                    throw re;
                }
                return null;
            }
        });
    }

    private void setShareSecurityContext(Principal principal, final Long id) {
        this.executor.execute(principal, new Executor.SimpleWork(this, "setShareSecurityContext", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                sf.getShareService().activate(id);
                return null;
            }
        });
    }

    private ExperimenterGroup _getDefaultGroup(ServiceFactory sf, String name) {
        LocalAdmin admin = (LocalAdmin)sf.getAdminService();
        try {
            Experimenter exp = admin.userProxy(name);
            ExperimenterGroup grp = admin.getDefaultGroup(exp.getId());
            return grp;
        }
        catch (Exception e) {
            log.warn("Exception while running executeDefaultGroup", e);
            return null;
        }
    }

    private long executeLookupUser(ServiceFactory sf, Principal p) {
        List<Object[]> rv = sf.getQueryService().projection("select e.id from Experimenter e where e.omeName = :name", new Parameters().addString("name", p.getName()));
        if (rv.size() == 0) {
            throw new RemovedSessionException("Cannot find a user with name " + p.getName());
        }
        return (Long)rv.get(0)[0];
    }

    private List<Object> executeSessionContextLookup(ServiceFactory sf, Principal principal, Session session) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            LocalAdmin admin = (LocalAdmin)sf.getAdminService();
            Experimenter exp = admin.userProxy(principal.getName());
            ExperimenterGroup grp = admin.groupProxy(principal.getGroup());
            List<Long> memberOfGroupsIds = admin.getMemberOfGroupIds(exp);
            List<Long> leaderOfGroupsIds = admin.getLeaderOfGroupIds(exp);
            List<String> userRoles = admin.getUserRoles(exp);
            Session reloaded = (Session)sf.getQueryService().findByQuery("select s from Session s left outer join fetch s.annotationLinks l left outer join fetch l.child a where s.id = :id", new Parameters().addId(session.getId()));
            list.add(exp);
            list.add(grp);
            list.add(memberOfGroupsIds);
            list.add(leaderOfGroupsIds);
            list.add(userRoles);
            list.add(principal);
            list.add(reloaded);
            return list;
        }
        catch (Exception e) {
            log.info("No info for " + principal.getName(), e);
            return null;
        }
    }

    private Share newShare() {
        Share share = new Share();
        share.putAt("#2733", "ALLOW");
        return share;
    }
}

