/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.util.List;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import ome.conditions.RemovedSessionException;
import ome.model.IObject;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.services.sessions.stats.SessionStats;
import ome.system.EventContext;
import ome.system.Principal;

public interface SessionManager {
    public Session createFromRequest(CreationRequest var1);

    public Session createWithAgent(Principal var1, String var2, String var3, String var4);

    public Session createWithAgent(Principal var1, String var2, String var3);

    public Share createShare(Principal var1, boolean var2, long var3, String var5, String var6, long var7);

    public IObject setSecurityContext(Principal var1, IObject var2);

    public Session update(Session var1);

    public Session update(Session var1, boolean var2);

    public int detach(String var1);

    public int getReferenceCount(String var1);

    public SessionStats getSessionStats(String var1);

    public Session find(String var1);

    public List<Session> findByUser(String var1);

    public List<Session> findByUserAndAgent(String var1, String ... var2);

    public Map<String, Map<String, Object>> getSessionData();

    public int close(String var1);

    public int closeAll();

    public EventContext getEventContext(Principal var1) throws RemovedSessionException;

    public EventContext reload(String var1) throws RemovedSessionException;

    public List<String> getUserRoles(String var1);

    public boolean executePasswordCheck(String var1, String var2);

    public Ehcache inMemoryCache(String var1);

    public Ehcache onDiskCache(String var1);

    public Object getInput(String var1, String var2) throws RemovedSessionException;

    public Object getOutput(String var1, String var2) throws RemovedSessionException;

    public void setInput(String var1, String var2, Object var3) throws RemovedSessionException;

    public void setOutput(String var1, String var2, Object var3) throws RemovedSessionException;

    public Map<String, Object> inputEnvironment(String var1);

    public Map<String, Object> outputEnvironment(String var1);

    public static class CreationRequest {
        public Principal principal;
        public String credentials;
        public String agent;
        public String ip;
        public List<Long> groupsLed;
        public Long timeToLive;
        public Long timeToIdle;
    }
}

