/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ome.model.internal.Permissions;
import ome.model.meta.Session;
import ome.services.sessions.SessionContext;
import ome.services.sessions.stats.SessionStats;
import ome.system.Roles;

public class SessionContextImpl
implements SessionContext {
    private final SessionContext.Count count;
    private final Roles _roles;
    private final Session session;
    private final SessionStats stats;
    private final List<Long> leaderOfGroups;
    private final List<Long> memberOfGroups;
    private final List<String> roles;
    private Long shareId = null;

    public SessionContextImpl(Session session, List<Long> lGroups, List<Long> mGroups, List<String> roles, SessionStats stats, SessionContext previous) {
        this(session, lGroups, mGroups, roles, stats, new Roles(), previous);
    }

    public SessionContextImpl(Session session, List<Long> lGroups, List<Long> mGroups, List<String> roles, SessionStats stats, Roles _roles, SessionContext previous) {
        this._roles = _roles;
        this.stats = stats;
        this.session = session;
        if (previous != null) {
            this.count = previous.count();
            this.shareId = previous.getCurrentShareId();
        } else {
            this.count = new SessionContext.Count(session.getUuid());
        }
        this.leaderOfGroups = Collections.unmodifiableList(new ArrayList<Long>(lGroups));
        this.memberOfGroups = Collections.unmodifiableList(new ArrayList<Long>(mGroups));
        this.roles = Collections.unmodifiableList(new ArrayList<String>(roles));
        this.getCurrentGroupPermissions();
    }

    @Override
    public SessionContext.Count count() {
        return this.count;
    }

    @Override
    public SessionStats stats() {
        return this.stats;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public List<String> getUserRoles() {
        return this.roles;
    }

    @Override
    public void setShareId(Long shareId) {
        this.shareId = shareId;
    }

    @Override
    public Long getCurrentShareId() {
        return this.shareId;
    }

    @Override
    public Long getCurrentSessionId() {
        return this.getSession().getId();
    }

    @Override
    public String getCurrentSessionUuid() {
        return this.getSession().getUuid();
    }

    @Override
    public Long getCurrentEventId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentEventType() {
        return this.session.getDefaultEventType();
    }

    @Override
    public Long getCurrentGroupId() {
        return this.session.getDetails().getGroup().getId();
    }

    @Override
    public String getCurrentGroupName() {
        return this.session.getDetails().getGroup().getName();
    }

    @Override
    public Permissions getCurrentGroupPermissions() {
        return this.session.getDetails().getGroup().getDetails().getPermissions();
    }

    @Override
    public Long getCurrentUserId() {
        return this.session.getDetails().getOwner().getId();
    }

    @Override
    public String getCurrentUserName() {
        return this.session.getDetails().getOwner().getOmeName();
    }

    @Override
    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    @Override
    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    @Override
    public boolean isCurrentUserAdmin() {
        if (this._roles == null) {
            throw new UnsupportedOperationException();
        }
        return this.memberOfGroups.contains(this._roles.getSystemGroupId());
    }

    @Override
    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    public Permissions getCurrentUmask() {
        throw new UnsupportedOperationException();
    }
}

