/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import ome.annotations.Hidden;
import ome.annotations.NotNull;
import ome.annotations.RolesAllowed;
import ome.api.ISession;
import ome.api.ServiceInterface;
import ome.conditions.AuthenticationException;
import ome.conditions.RootException;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionException;
import ome.model.meta.Session;
import ome.security.basic.CurrentDetails;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SessionBean
implements ISession {
    private static final Logger log = LoggerFactory.getLogger(SessionBean.class);
    private final SessionManager mgr;
    private final Executor ex;
    private final CurrentDetails cd;

    public SessionBean(SessionManager mgr, Executor ex, CurrentDetails cd) {
        this.mgr = mgr;
        this.ex = ex;
        this.cd = cd;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return ISession.class;
    }

    @Override
    @RolesAllowed(value={"user", "HasPassword"})
    public Session createUserSession(final long timeToLiveMs, final long timeToIdleMs, String defaultGroup) {
        String user = this.currentUser();
        if (user == null) {
            throw new SecurityViolation("No current user");
        }
        try {
            final Principal principal = this.principal(defaultGroup, user);
            Future<Session> future = this.ex.submit(new Callable<Session>(){

                @Override
                public Session call() throws Exception {
                    Session session = SessionBean.this.mgr.createWithAgent(principal, "createSession", null);
                    session.setTimeToIdle(timeToIdleMs);
                    session.setTimeToLive(timeToLiveMs);
                    return SessionBean.this.mgr.update(session, false);
                }
            });
            return this.ex.get(future);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public Session createSessionWithTimeout(@NotNull Principal principal, long milliseconds) {
        return this.createSessionWithTimeouts(principal, milliseconds, 0L);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Session createSessionWithTimeouts(final @NotNull Principal principal, final long timeToLiveMilliseconds, final long timeToIdleMilliseconds) {
        EventContext context = this.currentContext();
        final List<Long> groupsLed = context.isCurrentUserAdmin() ? null : context.getLeaderOfGroupsList();
        try {
            Future<Session> future = this.ex.submit(new Callable<Session>(){

                @Override
                public Session call() throws Exception {
                    SessionManager.CreationRequest req = new SessionManager.CreationRequest();
                    req.principal = principal;
                    req.agent = "OMERO.sudo";
                    req.groupsLed = groupsLed;
                    req.timeToIdle = timeToIdleMilliseconds;
                    req.timeToLive = timeToLiveMilliseconds;
                    return SessionBean.this.mgr.createFromRequest(req);
                }
            });
            return this.ex.get(future);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Session createSession(@NotNull Principal principal, @Hidden String credentials) {
        Session session = null;
        try {
            session = this.mgr.createWithAgent(principal, credentials, "createSession", null);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
        return session;
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Session getSession(@NotNull String sessionUuid) {
        return this.mgr.find(sessionUuid);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public int getReferenceCount(@NotNull String sessionUuid) {
        return this.mgr.getReferenceCount(sessionUuid);
    }

    @RolesAllowed(value={"user", "guest"})
    public Session updateSession(final @NotNull Session session) {
        Future<Session> future = this.ex.submit(new Callable<Session>(){

            @Override
            public Session call() throws Exception {
                return SessionBean.this.mgr.update(session);
            }
        });
        return this.ex.get(future);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public int closeSession(final @NotNull Session session) {
        Future<Integer> future = this.ex.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SessionBean.this.mgr.close(session.getUuid());
            }
        });
        return this.ex.get(future);
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenSessions() {
        final String user = this.currentUser();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findByUser(user);
            }
        });
        return this.ex.get(future);
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenAgentSessions(final String agent) {
        final String user = this.currentUser();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findByUserAndAgent(user, agent);
            }
        });
        return this.ex.get(future);
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenClientSessions() {
        final String user = this.currentUser();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findByUserAndAgent(user, "OMERO.insight", "OMERO.web", "OMERO.importer");
            }
        });
        return this.ex.get(future);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Object getInput(String session, String key) {
        return this.mgr.getInput(session, key);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Object getOutput(String session, String key) {
        return this.mgr.getOutput(session, key);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public void setInput(String session, String key, Object object) {
        this.mgr.setInput(session, key, object);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public void setOutput(String session, String key, Object object) {
        this.mgr.setOutput(session, key, object);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Set<String> getInputKeys(String session) {
        return this.mgr.inputEnvironment(session).keySet();
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Set<String> getOutputKeys(String session) {
        return this.mgr.outputEnvironment(session).keySet();
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Map<String, Object> getInputs(String session) {
        return this.mgr.inputEnvironment(session);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Map<String, Object> getOutputs(String session) {
        return this.mgr.outputEnvironment(session);
    }

    String currentUser() {
        return this.currentContext().getCurrentUserName();
    }

    EventContext currentContext() {
        String user = this.cd.getLast().getName();
        return this.mgr.getEventContext(new Principal(user));
    }

    private Principal principal(String defaultGroup, String user) {
        Principal p = defaultGroup != null ? new Principal(user, defaultGroup, "User") : new Principal(user);
        return p;
    }

    RuntimeException creationExceptionHandler(Exception e) {
        log.info("Handling session exception: ", e);
        if (e instanceof SessionException) {
            return (SessionException)e;
        }
        if (e instanceof SecurityViolation) {
            return (SecurityViolation)e;
        }
        if (e instanceof RootException) {
            return (AuthenticationException)new AuthenticationException("Error creating session.").initCause(e);
        }
        return new AuthenticationException("Unknown error (" + e.getClass().getName() + "):" + e.getMessage());
    }
}

