/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.io.Serializable;
import java.util.List;
import ome.conditions.InternalException;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.services.search.AnnotationCriteria;
import ome.services.search.OwnerOrGroup;
import ome.services.search.SearchValues;
import ome.services.util.Executor;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class SearchAction
implements Serializable,
Executor.Work {
    protected final SearchValues values = new SearchValues();
    protected List<IObject> chainedList;

    public SearchAction(SearchValues values) {
        if (values == null) {
            throw new IllegalArgumentException("SearchValues argument must not be null");
        }
        this.values.copy(values);
    }

    @Override
    public String description() {
        return this.getClass().getName();
    }

    public SearchValues copyOfValues() {
        SearchValues copy = new SearchValues();
        copy.copy(this.values);
        return copy;
    }

    public void chainedSearch(List<IObject> chainedList) {
        this.chainedList = chainedList;
    }

    protected void ids(Criteria criteria) {
        this.ids(criteria, null, null);
    }

    protected void ids(QueryBuilder qb, String path) {
        this.ids(null, qb, path);
    }

    private void ids(Criteria criteria, QueryBuilder qb, String path) {
        if (this.values.onlyIds != null) {
            if (criteria != null) {
                criteria.add(Restrictions.in((String)"id", this.values.onlyIds));
            }
            if (qb != null) {
                String unique = qb.unique_alias("ids");
                qb.and(String.format("%sid in (:%s) ", path, unique));
                qb.paramList(unique, this.values.onlyIds);
            }
        }
    }

    protected void ownerOrGroup(Class cls, Criteria criteria) {
        this.ownerOrGroup(cls, criteria, null, null);
    }

    protected void ownerOrGroup(Class cls, QueryBuilder qb, String path) {
        this.ownerOrGroup(cls, null, qb, path);
    }

    private void ownerOrGroup(Class cls, Criteria criteria, QueryBuilder qb, String path) {
        if (!IGlobal.class.isAssignableFrom(cls)) {
            OwnerOrGroup noog;
            OwnerOrGroup oog = new OwnerOrGroup(this.values.ownedBy, path);
            if (oog.needed()) {
                if (criteria != null) {
                    oog.on(criteria);
                }
                if (qb != null) {
                    oog.on(qb);
                }
            }
            if ((noog = new OwnerOrGroup(this.values.notOwnedBy, path)).needed()) {
                if (criteria != null) {
                    noog.on(criteria, false);
                }
                if (qb != null) {
                    noog.on(qb, false);
                }
            }
        }
    }

    protected void createdOrModified(Class cls, Criteria criteria) {
        this.createdOrModified(cls, criteria, null, null);
    }

    protected void createdOrModified(Class cls, QueryBuilder qb, String path) {
        this.createdOrModified(cls, null, qb, path);
    }

    private void createdOrModified(Class cls, Criteria criteria, QueryBuilder qb, String path) {
        if (!IGlobal.class.isAssignableFrom(cls)) {
            String ctime;
            if (criteria != null) {
                criteria.createAlias("details.creationEvent", "create");
            }
            if (this.values.createdStart != null) {
                if (criteria != null) {
                    criteria.add((Criterion)Restrictions.gt((String)"create.time", (Object)this.values.createdStart));
                }
                if (qb != null) {
                    ctime = qb.unique_alias("ctimestart");
                    qb.and(path + "details.creationEvent.time > :" + ctime);
                    qb.param(ctime, (Object)this.values.createdStart);
                }
            }
            if (this.values.createdStop != null) {
                if (criteria != null) {
                    criteria.add((Criterion)Restrictions.lt((String)"create.time", (Object)this.values.createdStop));
                }
                if (qb != null) {
                    ctime = qb.unique_alias("ctimestop");
                    qb.and(path + "details.creationEvent.time < :" + ctime);
                    qb.param(ctime, (Object)this.values.createdStop);
                }
            }
            if (IMutable.class.isAssignableFrom(cls)) {
                String mtime;
                if (criteria != null) {
                    criteria.createAlias("details.updateEvent", "update");
                }
                if (this.values.modifiedStart != null) {
                    if (criteria != null) {
                        criteria.add((Criterion)Restrictions.gt((String)"update.time", (Object)this.values.modifiedStart));
                    }
                    if (qb != null) {
                        mtime = qb.unique_alias("mtimestart");
                        qb.and(path + "details.updateEvent.time > :" + mtime);
                        qb.param(mtime, (Object)this.values.modifiedStart);
                    }
                }
                if (this.values.modifiedStop != null) {
                    if (criteria != null) {
                        criteria.add((Criterion)Restrictions.lt((String)"update.time", (Object)this.values.modifiedStop));
                    }
                    if (qb != null) {
                        mtime = qb.unique_alias("mtimestart");
                        qb.and(path + "details.updateEvent.time < :" + mtime);
                        qb.param(mtime, (Object)this.values.modifiedStop);
                    }
                }
            }
        }
    }

    protected void annotatedBy(AnnotationCriteria ann) {
        this.annotatedBy(ann, null, null);
    }

    protected void annotatedBy(QueryBuilder qb, String path) {
        this.annotatedBy(null, qb, path);
    }

    private void annotatedBy(AnnotationCriteria ann, QueryBuilder qb, String path) {
        OwnerOrGroup naoog;
        OwnerOrGroup aoog = new OwnerOrGroup(this.values.annotatedBy, path);
        if (aoog.needed()) {
            if (ann != null) {
                aoog.on(ann.getChild());
            }
            if (qb != null) {
                aoog.on(qb);
            }
        }
        if ((naoog = new OwnerOrGroup(this.values.notAnnotatedBy, path)).needed()) {
            if (ann != null) {
                naoog.on(ann.getChild(), false);
            }
            if (qb != null) {
                naoog.on(qb, false);
            }
        }
    }

    protected void annotatedBetween(AnnotationCriteria ann) {
        this.annotatedBetween(ann, null, null);
    }

    protected void annotatedBetween(QueryBuilder qb, String path) {
        this.annotatedBetween(null, qb, path);
    }

    private void annotatedBetween(AnnotationCriteria ann, QueryBuilder qb, String path) {
        if (this.values.annotatedStart != null) {
            if (ann != null) {
                ann.getCreate().add((Criterion)Restrictions.gt((String)"anncreate.time", (Object)this.values.annotatedStart));
            }
            if (qb != null) {
                String astart = qb.unique_alias("astart");
                qb.and(path + "details.creationEvent.time > :" + astart);
                qb.param(astart, (Object)this.values.annotatedStart);
            }
        }
        if (this.values.annotatedStop != null) {
            if (ann != null) {
                ann.getCreate().add((Criterion)Restrictions.lt((String)"anncreate.time", (Object)this.values.annotatedStop));
            }
            if (qb != null) {
                String astop = qb.unique_alias("astop");
                qb.and(path + "details.creationEvent.time < :" + astop);
                qb.param(astop, (Object)this.values.annotatedStop);
            }
        }
    }

    public static void notNullOrLikeOrEqual(QueryBuilder qb, String path, Class type, Object value, boolean useLike, boolean caseSensitive) {
        if (null == value) {
            qb.and(path + " is null ");
        } else {
            String operator = useLike && String.class.isAssignableFrom(type) ? (caseSensitive ? "like" : "ilike") : "=";
            String alias = qb.unique_alias("main");
            qb.and(path);
            qb.append(operator);
            qb.append(":");
            qb.append(alias);
            qb.appendSpace();
            qb.param(alias, value);
        }
    }

    public static Criterion notNullOrLikeOrEqual(String path, Class type, Object value, boolean useLike, boolean caseSensitive) {
        if (null == value) {
            return Restrictions.isNull((String)path);
        }
        if (useLike && String.class.isAssignableFrom(type)) {
            if (caseSensitive) {
                return Restrictions.like((String)path, (Object)value);
            }
            return Restrictions.ilike((String)path, (Object)value);
        }
        return Restrictions.eq((String)path, (Object)value);
    }

    public static String orderByPath(String orderBy) {
        String orderWithoutMode = orderBy.substring(1, orderBy.length());
        return orderWithoutMode;
    }

    public static boolean orderByAscending(String orderBy) {
        if (orderBy.startsWith("A")) {
            return true;
        }
        if (orderBy.startsWith("D")) {
            return false;
        }
        throw new InternalException("Unsupported orderBy mode added to values.orderBy");
    }
}

