/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scripts;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.local.LocalAdmin;
import ome.conditions.InternalException;
import ome.conditions.RemovedSessionException;
import ome.conditions.ValidationException;
import ome.model.core.OriginalFile;
import ome.model.enums.ChecksumAlgorithm;
import ome.model.meta.ExperimenterGroup;
import ome.services.delete.Deletion;
import ome.services.scripts.RepoFile;
import ome.services.scripts.ScriptFileType;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import ome.tools.spring.OnContextRefreshedEventListener;
import ome.util.SqlAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class ScriptRepoHelper
extends OnContextRefreshedEventListener {
    public static final String SCRIPT_REPO = "ScriptRepo";
    public static final IOFileFilter BASE_SCRIPT_FILTER = new AndFileFilter(Arrays.asList(EmptyFileFilter.NOT_EMPTY, HiddenFileFilter.VISIBLE, CanReadFileFilter.CAN_READ));
    private final Map<String, ScriptFileType> types = new HashMap<String, ScriptFileType>();
    private Set<String> mimetypes = new HashSet<String>();
    private Set<String> inertMimetypes = new HashSet<String>();
    private final String uuid;
    private final File dir;
    private final Executor ex;
    private final Principal p;
    private final Roles roles;
    private IOFileFilter scriptFilter;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public ScriptRepoHelper(Executor ex, String sessionUuid, Roles roles) {
        this(new File(ScriptRepoHelper.getDefaultScriptDir()), ex, new Principal(sessionUuid), roles);
    }

    public ScriptRepoHelper(File dir, Executor ex, Principal p, Roles roles) {
        this(SCRIPT_REPO, dir, ex, p, roles);
    }

    public ScriptRepoHelper(String uuid, File dir, Executor ex, Principal p, Roles roles) {
        this.roles = roles;
        this.uuid = uuid;
        this.dir = ScriptRepoHelper.sanityCheck(this.log, dir);
        this.ex = ex;
        this.p = p;
    }

    @Override
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        this.types.putAll(event.getApplicationContext().getBeansOfType(ScriptFileType.class));
        ArrayList<IOFileFilter> andFilters = new ArrayList<IOFileFilter>();
        ArrayList<IOFileFilter> orFilters = new ArrayList<IOFileFilter>();
        for (Map.Entry<String, ScriptFileType> entry : this.types.entrySet()) {
            IOFileFilter found = entry.getValue().getFileFilter();
            this.log.info("Registering {}: {}", (Object)entry.getKey(), (Object)found);
            orFilters.add(found);
            this.mimetypes.add(entry.getValue().getMimetype());
            if (!entry.getValue().isInert()) continue;
            this.inertMimetypes.add(entry.getValue().getMimetype());
        }
        this.mimetypes = Collections.unmodifiableSet(this.mimetypes);
        this.inertMimetypes = Collections.unmodifiableSet(this.inertMimetypes);
        andFilters.add(BASE_SCRIPT_FILTER);
        andFilters.add(new OrFileFilter(orFilters));
        this.scriptFilter = new AndFileFilter(andFilters);
        try {
            this.loadAll(true);
        }
        catch (RemovedSessionException rse) {
            this.log.error("Script failure!!! RemovedSession on startup: are we testing?");
        }
    }

    public void buildQuery(QueryBuilder qb) {
        boolean first = true;
        qb.and(" (");
        for (String mimetype : this.mimetypes) {
            if (first) {
                first = false;
            } else {
                qb.append(" OR ");
            }
            qb.append("o.mimetype = '" + mimetype + "'");
        }
        qb.append(") ");
    }

    public void setMimetype(OriginalFile ofile) {
        for (Map.Entry<String, ScriptFileType> entry : this.types.entrySet()) {
            if (!entry.getValue().setMimetype(ofile)) continue;
            this.log.debug("Mimetype set by {} for {}", (Object)entry.getKey(), (Object)ofile.getName());
            return;
        }
        this.log.warn("No mimetype set for {}", (Object)ofile.getName());
    }

    protected Map.Entry<String, ScriptFileType> findByMimetype(String mimetype) {
        for (Map.Entry<String, ScriptFileType> entry : this.types.entrySet()) {
            ScriptFileType type = entry.getValue();
            if (!type.getMimetype().equals(mimetype)) continue;
            return entry;
        }
        return null;
    }

    public String getLauncher(String mimetype) {
        Map.Entry<String, ScriptFileType> entry = this.findByMimetype(mimetype);
        if (entry == null) {
            this.log.warn("No mimetype equals to {}", (Object)mimetype);
            return "";
        }
        return entry.getValue().getLauncher();
    }

    public String getProcess(String mimetype) {
        Map.Entry<String, ScriptFileType> entry = this.findByMimetype(mimetype);
        if (entry == null) {
            this.log.warn("No mimetype equals to {}", (Object)mimetype);
            return "";
        }
        return entry.getValue().getProcess();
    }

    static File sanityCheck(Logger log, File dir) {
        String error = null;
        String testing = System.getProperty("omero.testing", "false").toLowerCase();
        testing = testing.toLowerCase();
        if (dir == null) {
            throw new InternalException("Null dir!");
        }
        if (!dir.exists()) {
            error = "Does not exist: ";
        } else if (!dir.canRead()) {
            error = "Cannot read: ";
        }
        if (error != null) {
            if (testing.equals("true")) {
                log.error(error + dir.getAbsolutePath());
                try {
                    dir = ScriptRepoHelper.getTmpDir();
                }
                catch (IOException e) {
                    throw new InternalException("Failed to make temp path for testing");
                }
            } else {
                throw new InternalException(error + dir.getAbsolutePath());
            }
        }
        return dir;
    }

    static File getTmpDir() throws IOException {
        String tmpDirName = System.getProperty("java.io.tmpdir", null);
        File tmpDir = new File(tmpDirName);
        File libDir = new File(tmpDir, "tmp_lib_scripts");
        File dir = File.createTempFile("lib", "scripts", tmpDir);
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    public static String getDefaultScriptDir() {
        File current = new File(".");
        File lib = new File(current, "lib");
        File scripts = new File(lib, "scripts");
        return scripts.getAbsolutePath();
    }

    public String getScriptDir() {
        return this.dir.getAbsolutePath();
    }

    public String getUuid() {
        return this.uuid;
    }

    public int countOnDisk() {
        int size = 0;
        Iterator<File> it = this.iterate();
        while (it.hasNext()) {
            File f = it.next();
            if (!f.canRead() || !f.isFile() || f.isHidden()) continue;
            ++size;
        }
        return size;
    }

    public int countInDb() {
        return (Integer)this.ex.executeSql(new Executor.SimpleSqlWork(this, "countInDb", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return ScriptRepoHelper.this.countInDb(sql);
            }
        });
    }

    public int countInDb(SqlAction sql) {
        return sql.repoScriptCount(this.uuid, this.mimetypes);
    }

    public List<Long> idsInDb() {
        return (List)this.ex.executeSql(new Executor.SimpleSqlWork(this, "idsInDb", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return ScriptRepoHelper.this.idsInDb(sql);
            }
        });
    }

    public List<Long> idsInDb(SqlAction sql) {
        try {
            return sql.fileIdsInDb(this.uuid, this.mimetypes);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
    }

    public boolean isInRepo(final long id) {
        return (Boolean)this.ex.executeSql(new Executor.SimpleSqlWork(this, "isInRepo", new Object[]{id}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return ScriptRepoHelper.this.isInRepo(sql, id);
            }
        });
    }

    public boolean isInRepo(SqlAction sql, long id) {
        try {
            int count = sql.isFileInRepo(this.uuid, id, this.mimetypes);
            return count > 0;
        }
        catch (EmptyResultDataAccessException e) {
            return false;
        }
    }

    public Long findInDb(String path, boolean scriptsOnly) {
        RepoFile repoFile = new RepoFile(this.dir, path);
        return this.findInDb(repoFile, scriptsOnly);
    }

    public Long findInDb(final RepoFile file2, final boolean scriptsOnly) {
        return (Long)this.ex.executeSql(new Executor.SimpleSqlWork(this, "findInDb", new Object[]{file2, scriptsOnly}){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return ScriptRepoHelper.this.findInDb(sql, file2, scriptsOnly);
            }
        });
    }

    public Long findInDb(SqlAction sql, RepoFile repoFile, boolean scriptsOnly) {
        return sql.findRepoFile(this.uuid, repoFile.dirname(), repoFile.basename(), scriptsOnly ? this.mimetypes : null);
    }

    public Iterator<File> iterate() {
        ArrayList<String> problems = new ArrayList<String>();
        if (!this.dir.exists()) {
            problems.add("does not exist");
        } else {
            if (!this.dir.canRead()) {
                problems.add("is not readable");
            }
            if (!this.dir.isDirectory()) {
                problems.add("is not a directory");
            }
        }
        if (!problems.isEmpty()) {
            throw new InternalException(String.format("Cannot list %s since it %s", this.dir, StringUtils.join(problems, " and ")));
        }
        return FileUtils.iterateFiles(this.dir, this.scriptFilter, TrueFileFilter.TRUE);
    }

    private List<OriginalFile> loadAllScripts(final boolean modificationCheck, final String mimetype, Principal pp) {
        final Iterator<File> it = this.iterate();
        final ArrayList rv = new ArrayList();
        return (List)this.ex.execute(pp, new Executor.SimpleWork(this, "loadAll", new Object[]{modificationCheck}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                SqlAction sqlAction = this.getSqlAction();
                ArrayList<OriginalFile> list = new ArrayList<OriginalFile>();
                File f = null;
                RepoFile file2 = null;
                HashSet<String> types = new HashSet<String>();
                if (StringUtils.isBlank(mimetype)) {
                    types.addAll(ScriptRepoHelper.this.mimetypes);
                    types.removeAll(ScriptRepoHelper.this.inertMimetypes);
                } else {
                    types.add(mimetype);
                }
                while (it.hasNext()) {
                    f = (File)it.next();
                    file2 = new RepoFile(ScriptRepoHelper.this.dir, f);
                    Long id = ScriptRepoHelper.this.findInDb(sqlAction, file2, false);
                    String hash = null;
                    OriginalFile ofile = null;
                    if (id == null) {
                        ofile = ScriptRepoHelper.this.addOrReplace(session, sqlAction, sf, file2, null);
                    } else {
                        ofile = ScriptRepoHelper.this.load(id, session, this.getSqlAction(), true);
                        if (ofile == null) continue;
                        if (modificationCheck && !(hash = file2.hash()).equals(ofile.getHash())) {
                            ofile = ScriptRepoHelper.this.addOrReplace(session, sqlAction, sf, file2, id);
                        }
                    }
                    if (types.contains(ofile.getMimetype())) {
                        rv.add(ofile);
                        continue;
                    }
                    list.add(ofile);
                }
                list.addAll(rv);
                ScriptRepoHelper.this.removeMissingFilesFromDb(sqlAction, session, list);
                return rv;
            }
        });
    }

    public List<OriginalFile> loadAll(boolean modificationCheck, String mimetype) {
        return this.loadAllScripts(modificationCheck, mimetype, this.p);
    }

    public List<OriginalFile> loadAll(boolean modificationCheck, String mimetype, Principal pp) {
        return this.loadAllScripts(modificationCheck, mimetype, pp);
    }

    public List<OriginalFile> loadAll(boolean modificationCheck) {
        return this.loadAll(modificationCheck, null);
    }

    public OriginalFile addOrReplace(final RepoFile repoFile, final Long old) {
        return (OriginalFile)this.ex.execute(this.p, new Executor.SimpleWork(this, "addOrReplace", new Object[]{repoFile, old}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return ScriptRepoHelper.this.addOrReplace(session, this.getSqlAction(), sf, repoFile, old);
            }
        });
    }

    protected OriginalFile addOrReplace(Session session, SqlAction sqlAction, ServiceFactory sf, RepoFile repoFile, Long old) {
        if (old != null) {
            this.unregister(old, sqlAction);
            this.log.info("Unregistered " + old);
        }
        OriginalFile ofile = new OriginalFile();
        return this.update(session, repoFile, sqlAction, sf, ofile);
    }

    public long removeMissingFilesFromDb(SqlAction sqlAction, Session session, List<OriginalFile> filesOnDisk) {
        List<Long> idsInDb = this.idsInDb(sqlAction);
        if (idsInDb.size() != filesOnDisk.size()) {
            this.log.info(String.format("Script missing from disk: %s in db, %s on disk!", idsInDb.size(), filesOnDisk.size()));
        }
        HashSet<Long> setInDb = new HashSet<Long>();
        HashSet<Long> setOnDisk = new HashSet<Long>();
        setInDb.addAll(idsInDb);
        for (OriginalFile f : filesOnDisk) {
            setOnDisk.add(f.getId());
        }
        setInDb.removeAll(setOnDisk);
        for (Long l : setInDb) {
            this.unregister(l, sqlAction);
        }
        return setInDb.size();
    }

    protected void unregister(Long old, SqlAction sqlAction) {
        sqlAction.setFileRepo(Collections.singleton(old), null);
    }

    public OriginalFile update(final RepoFile repoFile, final Long id, Map<String, String> context) {
        return (OriginalFile)this.ex.execute(context, this.p, new Executor.SimpleWork(this, "update", new Object[]{repoFile, id}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                OriginalFile ofile = ScriptRepoHelper.this.load(id, session, this.getSqlAction(), true);
                return ScriptRepoHelper.this.update(session, repoFile, this.getSqlAction(), sf, ofile);
            }
        });
    }

    private ExperimenterGroup loadUserGroup(Session session) {
        return (ExperimenterGroup)session.get(ExperimenterGroup.class, (Serializable)Long.valueOf(this.roles.getUserGroupId()));
    }

    private ChecksumAlgorithm loadChecksum(Session session, String hasher) {
        return (ChecksumAlgorithm)session.createQuery("select ca from ChecksumAlgorithm ca where ca.value = :value").setParameter("value", (Object)hasher).uniqueResult();
    }

    private OriginalFile update(Session session, RepoFile repoFile, SqlAction sqlAction, ServiceFactory sf, OriginalFile ofile) {
        ExperimenterGroup group = this.loadUserGroup(session);
        ChecksumAlgorithm hasher = this.loadChecksum(session, repoFile.hasher().getValue());
        ofile.setPath(repoFile.dirname());
        ofile.setName(repoFile.basename());
        ofile.setHasher(hasher);
        ofile.setHash(repoFile.hash());
        ofile.setSize(repoFile.length());
        ofile.getDetails().setGroup(group);
        ofile = sf.getUpdateService().saveAndReturnObject(ofile);
        this.setMimetype(ofile);
        sqlAction.setFileRepo(Collections.singleton(ofile.getId()), this.uuid);
        return ofile;
    }

    public String read(String path) throws IOException {
        RepoFile repo = new RepoFile(this.dir, path);
        return FileUtils.readFileToString(repo.file());
    }

    public RepoFile write(String path, String text) throws IOException {
        RepoFile repo = new RepoFile(this.dir, path);
        return this.write(repo, text);
    }

    public RepoFile write(RepoFile repo, String text) throws IOException {
        FileUtils.writeStringToFile(repo.file(), text);
        return repo;
    }

    public OriginalFile load(final long id, final boolean check) {
        return (OriginalFile)this.ex.execute(this.p, new Executor.SimpleWork(this, "load", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return ScriptRepoHelper.this.load(id, session, this.getSqlAction(), check);
            }
        });
    }

    public OriginalFile load(long id, Session s, SqlAction sqlAction, boolean check) {
        String repo;
        if (check && !this.uuid.equals(repo = sqlAction.scriptRepo(id, this.mimetypes))) {
            return null;
        }
        return (OriginalFile)s.get(OriginalFile.class, (Serializable)Long.valueOf(id));
    }

    public void modificationCheck() {
        this.loadAll(true);
    }

    public boolean delete(long id) {
        OriginalFile file2 = this.load(id, true);
        if (file2 == null) {
            return false;
        }
        this.simpleDelete(null, this.ex, this.p, id);
        FileUtils.deleteQuietly(new File(this.dir, file2.getPath() + file2.getName()));
        return true;
    }

    public void simpleDelete(Map<String, String> context, final Executor executor, Principal p, final long id) {
        Deletion deletion = (Deletion)executor.execute(context, p, new Executor.SimpleWork(this, "deleteOriginalFile", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                try {
                    EventContext ec = ((LocalAdmin)sf.getAdminService()).getEventContextQuiet();
                    Deletion d = (Deletion)executor.getContext().getBean(Deletion.class.getName(), Deletion.class);
                    HashMultimap<String, Long> toDelete = HashMultimap.create();
                    toDelete.put("OriginalFile", id);
                    d.deleteFiles(toDelete);
                    return null;
                }
                catch (ValidationException ve) {
                    ScriptRepoHelper.this.log.debug("ValidationException on delete", ve);
                }
                catch (Throwable e) {
                    ScriptRepoHelper.this.log.warn("Throwable while deleting script " + id, e);
                }
                return null;
            }
        });
    }

    public boolean isInert(OriginalFile f) {
        if (f == null) {
            return false;
        }
        String mimetype = f.getMimetype();
        if (StringUtils.isBlank(mimetype)) {
            return false;
        }
        return this.inertMimetypes.contains(mimetype);
    }
}

