/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scripts;

import java.io.File;
import java.util.List;
import ome.conditions.InternalException;
import ome.model.core.OriginalFile;
import ome.parameters.Parameters;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import omero.model.OriginalFileI;
import omero.model.ScriptJob;
import omero.model.ScriptJobI;
import omero.rtypes;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptFinder {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Principal principal;
    private final Executor ex;
    private final Roles roles;
    private final File source;

    public ScriptFinder(Roles roles, String uuid, Executor executor, File source) {
        this(roles, new Principal(uuid, "system", "Internal"), executor, source);
    }

    public ScriptFinder(Roles roles, Principal principal, Executor executor, File source) {
        this.roles = roles;
        this.principal = principal;
        this.ex = executor;
        this.source = source;
        if (!this.source.exists()) {
            this.log.error("SERVER IMPROPERLY CONFIGURED - CANNOT FIND " + source.getAbsolutePath());
            return;
        }
    }

    public abstract String getName();

    public OriginalFileI getFile(ServiceFactory sf) {
        OriginalFile file2 = null;
        ChecksumProviderFactoryImpl cpf = new ChecksumProviderFactoryImpl();
        try {
            byte[] buf = FileUtils.readFileToByteArray(this.source);
            String sha1 = cpf.getProvider(ChecksumType.SHA1).putBytes(buf).checksumAsString();
            this.log.debug("Loading script: " + sha1);
            Parameters p = new Parameters();
            p.addString("hash", sha1);
            p.addString("name", this.getName());
            List<OriginalFile> files = this.loadScripts(sf, p);
            if (files.size() < 1) {
                return null;
            }
            if (files.size() > 1) {
                this.log.warn("Multiple scripts found: " + files);
            }
            file2 = files.get(0);
        }
        catch (Exception e) {
            this.log.warn(e.toString());
        }
        if (file2 == null) {
            throw new InternalException("Failed to find script");
        }
        return new OriginalFileI(file2.getId(), false);
    }

    protected List<OriginalFile> loadScripts(ServiceFactory sf, Parameters p) {
        p.addLong("gid", this.roles.getUserGroupId());
        List<OriginalFile> files = sf.getQueryService().findAllByQuery("select f from OriginalFile f where f.hash = :hash and f.details.group.id = :gid and f.name = :name and f.mimetype = 'text/x-python'", p);
        return files;
    }

    public ScriptJob createJob(ServiceFactory sf) {
        ScriptJobI job = new ScriptJobI();
        job.linkOriginalFile(this.getFile(sf));
        job.setDescription(rtypes.rstring(this.getName()));
        return job;
    }
}

