/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scripts;

import java.io.File;
import ome.model.enums.ChecksumAlgorithm;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import org.apache.commons.io.FilenameUtils;

public class RepoFile {
    private static final ChecksumProviderFactory cpf = new ChecksumProviderFactoryImpl();
    private final FsFile fs;
    private final String rel;
    private final String root;
    private final String absPath;

    public static String norm(String path) {
        String s2u = FilenameUtils.separatorsToUnix(path);
        String tmp = FilenameUtils.normalizeNoEndSeparator(FilenameUtils.getPath(s2u));
        if (tmp == null) {
            tmp = "";
        } else if (!tmp.equals("")) {
            tmp = "/" + tmp;
        }
        return String.format("%s/%s.%s", tmp, FilenameUtils.getBaseName(s2u), FilenameUtils.getExtension(s2u));
    }

    public RepoFile(File root, String path) {
        this(root, new File(root, RepoFile.norm(path)));
    }

    public RepoFile(File root, File file2) {
        this.fs = new FsFile(file2);
        this.root = FilenameUtils.normalize(root.getAbsolutePath());
        this.rel = this.fs.path.substring(this.root.length());
        this.absPath = new File(root, this.rel).getAbsolutePath();
    }

    public boolean matches(File file2) {
        return FilenameUtils.equalsNormalizedOnSystem(this.absPath, file2.getAbsolutePath());
    }

    public File file() {
        return new File(this.fs.path);
    }

    public String basename() {
        return FilenameUtils.getName(this.rel);
    }

    public String dirname() {
        return FilenameUtils.getFullPath(this.rel);
    }

    public String fullname() {
        return this.rel;
    }

    public ChecksumAlgorithm hasher() {
        return this.fs.hasher();
    }

    public String hash() {
        return this.fs.hash();
    }

    public long length() {
        return this.fs.length();
    }

    public String toString() {
        return super.toString() + ":" + this.rel;
    }

    public static class FsFile {
        public final String path;
        public final String name;
        private final ChecksumAlgorithm hasher = new ChecksumAlgorithm("SHA1-160");

        FsFile(String path) {
            this.path = FilenameUtils.normalize(path);
            this.name = FilenameUtils.getName(this.path);
        }

        FsFile(File file2) {
            this(file2.getAbsolutePath());
        }

        public long length() {
            return new File(this.path).length();
        }

        public ChecksumAlgorithm hasher() {
            return this.hasher;
        }

        public String hash() {
            return cpf.getProvider(ChecksumType.SHA1).putFile(this.path).checksumAsString();
        }

        public String toString() {
            return super.toString() + ":" + this.path;
        }
    }
}

