/*
 * Decompiled with CFR 0.152.
 */
package ome.services.scheduler;

import java.util.HashMap;
import java.util.Map;
import ome.tools.spring.OnContextRefreshedEventListener;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

public class SchedulerFactoryBean
extends org.springframework.scheduling.quartz.SchedulerFactoryBean
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SchedulerFactoryBean.class);
    private final Map<String, Trigger> triggers = new HashMap<String, Trigger>();
    private final OnContextRefreshedEventListener handler = new OnContextRefreshedEventListener(true, Integer.MAX_VALUE){

        @Override
        public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
            SchedulerFactoryBean.this.handle(event);
        }
    };

    @Override
    public void setApplicationContext(ApplicationContext ctx) {
        this.handler.setApplicationContext(ctx);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.handler.onApplicationEvent(event);
    }

    private void handle(ContextRefreshedEvent cre) {
        String[] names;
        for (String name : names = cre.getApplicationContext().getBeanNamesForType(Trigger.class)) {
            if (this.triggers.containsKey(name)) {
                log.error("Scheduler already has trigger named: " + name);
                continue;
            }
            Trigger trigger = (Trigger)cre.getApplicationContext().getBean(name);
            this.registerTrigger(name, trigger);
        }
        this.restartIfNeeded();
    }

    protected void registerTrigger(String beanName, Trigger trigger) {
        try {
            Scheduler scheduler = this.getObject();
            this.triggers.put(beanName, trigger);
            JobDetailAwareTrigger jdat = (JobDetailAwareTrigger)trigger;
            JobDetail job = jdat.getJobDetail();
            scheduler.addJob(job, false);
            scheduler.scheduleJob(trigger);
            log.debug(String.format("Registered trigger \"%s\": %s", beanName, trigger));
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
    }

    protected void restartIfNeeded() {
        if (!this.isRunning()) {
            try {
                this.start();
            }
            catch (SchedulingException se) {
                log.info("Replacing scheduler");
                try {
                    this.afterPropertiesSet();
                    if (!this.isRunning()) {
                        this.start();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to restart scheduler", e);
                }
            }
        }
    }
}

