/*
 * Decompiled with CFR 0.152.
 */
package ome.services.roi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.conditions.ApiUsageException;
import ome.io.nio.PixelBuffer;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.roi.Roi;
import ome.services.roi.PixelData;
import ome.services.roi.RoiTypes;
import ome.services.util.Executor;
import ome.tools.hibernate.SessionFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import omero.api.RoiStats;
import omero.api.ShapePoints;
import omero.api.ShapeStats;
import omero.model.Ellipse;
import omero.model.IObject;
import omero.model.Line;
import omero.model.Point;
import omero.model.Rectangle;
import omero.model.Shape;
import omero.model.SmartEllipseI;
import omero.model.SmartLineI;
import omero.model.SmartPointI;
import omero.model.SmartRectI;
import omero.model.SmartShape;
import omero.rtypes;
import omero.util.IceMapper;
import omero.util.ObjectFactoryRegistry;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomTool {
    protected Logger log = LoggerFactory.getLogger(GeomTool.class);
    protected final AtomicBoolean hasShapes = new AtomicBoolean(true);
    protected final SqlAction sql;
    protected final SessionFactory factory;
    protected final PixelData data;
    protected final Executor ex;
    protected final String uuid;
    private static final String ORIGIN = "'(0,0)'";

    public GeomTool(PixelData data, SqlAction sql, SessionFactory factory) {
        this(data, sql, factory, null, null);
    }

    public GeomTool(PixelData data, SqlAction sql, SessionFactory factory, Executor ex, String uuid) {
        this.data = data;
        this.sql = sql;
        this.factory = factory;
        this.ex = ex;
        this.uuid = uuid;
    }

    private Shape justShapeById(long shapeId, Session session) {
        Query q = session.createQuery("select s from Shape s where s.id = :id");
        q.setParameter("id", (Object)shapeId);
        ome.model.roi.Shape shape = (ome.model.roi.Shape)q.uniqueResult();
        return (Shape)((Object)new ShapeMapper().map(shape));
    }

    public List<Shape> random(int count) {
        if (count < 1 || count > 100000) {
            throw new RuntimeException("Count out of bounds: " + count);
        }
        Map<String, ObjectFactoryRegistry.ObjectFactory> map = new RoiTypes.RoiTypesObjectFactoryRegistry().createFactories(null);
        ArrayList<String> types = new ArrayList<String>(map.keySet());
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        Random r = new Random();
        try {
            while (shapes.size() < count) {
                int which = r.nextInt(map.size());
                String typeName = (String)types.get(which);
                ObjectFactoryRegistry.ObjectFactory of = map.get(typeName);
                SmartShape s = (SmartShape)((Object)of.create(""));
                Method m = s.getClass().getMethod("randomize", Random.class);
                m.invoke((Object)s, r);
                shapes.add((Shape)((Object)s));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failure on creating shape " + shapes.size(), e);
        }
        return shapes;
    }

    public Line ln(double x1, double y1, double x2, double y2) {
        SmartLineI rect = new SmartLineI();
        rect.setX1(rtypes.rdouble(x1));
        rect.setY1(rtypes.rdouble(y1));
        rect.setX2(rtypes.rdouble(x2));
        rect.setY2(rtypes.rdouble(y2));
        return rect;
    }

    public Rectangle rect(double x, double y, double w, double h) {
        SmartRectI rect = new SmartRectI();
        rect.setX(rtypes.rdouble(x));
        rect.setY(rtypes.rdouble(y));
        rect.setWidth(rtypes.rdouble(w));
        rect.setHeight(rtypes.rdouble(h));
        return rect;
    }

    public Point pt(double x, double y) {
        SmartPointI pt = new SmartPointI();
        pt.setX(rtypes.rdouble(x));
        pt.setY(rtypes.rdouble(y));
        return pt;
    }

    public Ellipse ellipse(double x, double y, double radiusx, double radiusy) {
        SmartEllipseI ellipse = new SmartEllipseI();
        ellipse.setX(rtypes.rdouble(x));
        ellipse.setY(rtypes.rdouble(y));
        ellipse.setRadiusX(rtypes.rdouble(radiusx));
        ellipse.setRadiusY(rtypes.rdouble(radiusy));
        return ellipse;
    }

    public Ellipse ellipse(double x, double y, double radiusx, double radiusy, int t, int z) {
        Ellipse ellipse = this.ellipse(x, y, radiusx, radiusy);
        ellipse.setTheT(rtypes.rint(t));
        ellipse.setTheZ(rtypes.rint(z));
        return ellipse;
    }

    public String dbPath(Shape shape) {
        if (shape == null) {
            this.log.warn("Shape is null");
            return ORIGIN;
        }
        SmartShape ss = this.assertSmart(shape);
        List<Point> points = ss.asPoints();
        if (points == null) {
            return ORIGIN;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'(");
        for (int i = 0; i < points.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            SmartShape.Util.appendDbPoint(sb, points.get(i));
        }
        sb.append(")'");
        return sb.toString();
    }

    public ShapePoints getPoints(long shapeId, Session session) {
        Shape shape = this.justShapeById(shapeId, session);
        SmartShape smart = this.assertSmart(shape);
        final ArrayList xs = new ArrayList();
        final ArrayList ys = new ArrayList();
        smart.areaPoints(new SmartShape.PointCallback(){

            @Override
            public void handle(int x, int y) {
                xs.add(x);
                ys.add(y);
            }
        });
        ShapePoints sp = new ShapePoints();
        sp.x = new int[xs.size()];
        sp.y = new int[ys.size()];
        for (int i = 0; i < sp.x.length; ++i) {
            sp.x[i] = (Integer)xs.get(i);
            sp.y[i] = (Integer)ys.get(i);
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoiStats getStats(List<Long> shapeIds) {
        if (shapeIds == null) {
            return null;
        }
        Session session = this.factory.getSession();
        RoiStats rs = new RoiStats();
        rs.perShape = new ShapeStats[shapeIds.size()];
        for (int i = 0; i < shapeIds.size(); ++i) {
            long shapeId = shapeIds.get(i);
            ome.model.roi.Shape shape = (ome.model.roi.Shape)session.createQuery("select s from Shape s left outer join fetch s.channels selected join fetch s.roi r join fetch r.image i join fetch i.pixels p join fetch p.channels c join fetch c.logicalChannel lc where s.id = :id").setParameter("id", (Object)shapeId).uniqueResult();
            SmartShape smartShape = (SmartShape)((Object)new ShapeMapper().map(shape));
            Roi roi = shape.getRoi();
            Image img = roi.getImage();
            Pixels pix = img.getPrimaryPixels();
            long roiId = roi.getId();
            long imgId = img.getId();
            long pixId = pix.getId();
            int maxZ = pix.getSizeZ();
            int maxT = pix.getSizeT();
            if (rs.combined == null) {
                rs.roiId = roiId;
                rs.imageId = imgId;
                rs.pixelsId = pixId;
                int ch = pix.sizeOfChannels();
                rs.combined = this.makeStats(ch);
                rs.combined.shapeId = -1L;
                rs.combined.channelIds = new long[ch];
                for (int w = 0; w < ch; ++w) {
                    rs.combined.channelIds[w] = pix.getChannel(w).getLogicalChannel().getId();
                }
            }
            final ShapeStats stats = this.makeStats(pix, shape);
            stats.shapeId = shape.getId();
            final int ch = stats.channelIds.length;
            final double[] sumOfSquares = new double[ch];
            Integer theZ = shape.getTheZ();
            Integer theT = shape.getTheT();
            final int startZ = theZ == null ? 0 : theZ;
            final int startT = theT == null ? 0 : theT;
            final int endZ = theZ == null ? maxZ - 1 : theZ;
            final int endT = theT == null ? maxT - 1 : theT;
            final PixelBuffer buf = this.data.getBuffer(pixId);
            try {
                SmartShape.PointCallback cb = new SmartShape.PointCallback(){

                    @Override
                    public void handle(int x, int y) {
                        for (int w = 0; w < ch; ++w) {
                            for (int z = startZ; z <= endZ; ++z) {
                                for (int t = startT; t <= endT; ++t) {
                                    int n = w;
                                    stats.pointsCount[n] = stats.pointsCount[n] + 1L;
                                    double value = GeomTool.this.data.get(buf, x, y, z, w, t);
                                    stats.min[w] = Math.min(value, stats.min[w]);
                                    stats.max[w] = Math.max(value, stats.max[w]);
                                    int n2 = w;
                                    stats.sum[n2] = stats.sum[n2] + value;
                                    int n3 = w;
                                    sumOfSquares[n3] = sumOfSquares[n3] + value * value;
                                }
                            }
                        }
                    }
                };
                smartShape.areaPoints(cb);
            }
            finally {
                try {
                    buf.close();
                }
                catch (IOException e) {
                    this.log.error("Error closing " + buf, e);
                }
            }
            for (int w = 0; w < ch; ++w) {
                double sigmaSquare;
                stats.mean[w] = stats.sum[w] / (double)stats.pointsCount[w];
                if (stats.pointsCount[w] <= 1L || !((sigmaSquare = (sumOfSquares[w] - stats.sum[w] * stats.sum[w] / (double)stats.pointsCount[w]) / (double)(stats.pointsCount[w] - 1L)) > 0.0)) continue;
                stats.stdDev[w] = Math.sqrt(sigmaSquare);
            }
            rs.perShape[i] = stats;
        }
        return rs;
    }

    public Object discriminator(String string) {
        if (string == null || string.length() == 0) {
            throw new ApiUsageException("Empty string");
        }
        String[] s = string.split("[.:]");
        string = s[s.length - 1];
        if ((string = string.toLowerCase()).endsWith("i")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private ShapeStats makeStats(int ch) {
        ShapeStats stats = new ShapeStats();
        stats.channelIds = new long[ch];
        stats.min = new double[ch];
        stats.max = new double[ch];
        stats.sum = new double[ch];
        stats.mean = new double[ch];
        stats.stdDev = new double[ch];
        stats.pointsCount = new long[ch];
        Arrays.fill(stats.min, 0, ch, Double.MAX_VALUE);
        return stats;
    }

    private ShapeStats makeStats(Pixels pix, ome.model.roi.Shape shape) {
        Integer theC = shape.getTheC();
        int sizeC = pix.sizeOfChannels();
        if (theC != null) {
            sizeC = 1;
        }
        ShapeStats stats = this.makeStats(sizeC);
        for (int w = 0; w < sizeC; ++w) {
            stats.channelIds[w] = theC != null ? pix.getChannel(theC).getLogicalChannel().getId().longValue() : pix.getChannel(w).getLogicalChannel().getId().longValue();
        }
        return stats;
    }

    private SmartShape assertSmart(Shape shape) {
        if (!SmartShape.class.isAssignableFrom(shape.getClass())) {
            throw new RuntimeException("Internally only SmartShapes should be used! not " + shape.getClass());
        }
        SmartShape ss = (SmartShape)((Object)shape);
        return ss;
    }

    private static class ShapeMapper
    extends IceMapper {
        boolean called = false;

        private ShapeMapper() {
        }

        @Override
        public Filterable filter(String fieldId, Filterable source) {
            if (!this.called) {
                this.called = true;
                return super.filter(fieldId, source);
            }
            Object o = this.findTarget(source);
            if (o instanceof IObject) {
                ome.model.IObject iobj = (ome.model.IObject)source;
                IObject robj = (IObject)o;
                robj.setId(rtypes.rlong(iobj.getId()));
                robj.unload();
            }
            return source;
        }
    }
}

