/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

class ModelObjectCache {
    private final Map<Lookup, ImmutableSet<Long>> lookupCache = new HashMap<Lookup, ImmutableSet<Long>>();

    ModelObjectCache() {
    }

    ImmutableSet<Long> getFromCache(String fromType, Long fromId, String toType) {
        return this.lookupCache.get(new Lookup(fromType, fromId, toType));
    }

    void putIntoCache(String fromType, Long fromId, String toType, ImmutableSet<Long> toIds) {
        this.lookupCache.put(new Lookup(fromType, fromId, toType), toIds);
    }

    private static class Lookup {
        final String fromType;
        final long fromId;
        final String toType;

        private Lookup(String fromType, long fromId, String toType) {
            if (fromType == null || toType == null) {
                throw new IllegalArgumentException(new NullPointerException());
            }
            this.fromType = fromType.intern();
            this.fromId = fromId;
            this.toType = toType.intern();
        }

        public boolean equals(Object object) {
            if (object instanceof Lookup) {
                Lookup lookup = (Lookup)object;
                return this.fromType == lookup.fromType && this.fromId == lookup.fromId && this.toType == lookup.toType;
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.fromType).append(this.fromId).append(this.toType).toHashCode();
        }
    }
}

