/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ome.api.IQuery;
import ome.parameters.Parameters;
import ome.services.query.ModelObjectCache;

public class HierarchyNavigator {
    private static final ImmutableMap<Map.Entry<String, String>, String> hqlFromTo;
    protected final IQuery iQuery;
    private final ModelObjectCache cache = new ModelObjectCache();

    protected HierarchyNavigator(IQuery iQuery) {
        this.iQuery = iQuery;
    }

    private List<Object[]> doQuery(String toType, String fromType, Collection<Long> fromIds) {
        String queryString = hqlFromTo.get(Maps.immutableEntry(fromType, toType));
        if (queryString == null) {
            throw new IllegalArgumentException("not implemented for " + fromType + " to " + toType);
        }
        return this.iQuery.projection(queryString, new Parameters().addIds(fromIds));
    }

    protected void prepareLookups(String toType, String fromType, Collection<Long> fromIds) {
        HashSet<Long> fromIdsToQuery = new HashSet<Long>(fromIds);
        for (long fromId : fromIds) {
            if (this.cache.getFromCache(fromType, fromId, toType) == null) continue;
            fromIdsToQuery.remove(fromId);
        }
        if (fromIdsToQuery.isEmpty()) {
            return;
        }
        HashMultimap<Long, Long> fromIdsToIds = HashMultimap.create();
        for (List<Long> list : Iterables.partition(fromIdsToQuery, 256)) {
            for (Object[] queryResult : this.doQuery(toType, fromType, list)) {
                fromIdsToIds.put((Long)queryResult[0], (Long)queryResult[1]);
            }
        }
        for (Map.Entry entry : fromIdsToIds.asMap().entrySet()) {
            this.cache.putIntoCache(fromType, (Long)entry.getKey(), toType, ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        for (Long l : Sets.difference(fromIdsToQuery, fromIdsToIds.keySet())) {
            this.cache.putIntoCache(fromType, l, toType, ImmutableSet.of());
        }
    }

    protected ImmutableSet<Long> doLookup(String toType, String fromType, Long fromId) {
        ImmutableSet<Long> result = this.cache.getFromCache(fromType, fromId, toType);
        if (result == null) {
            ImmutableSet.Builder toIdsBuilder = ImmutableSet.builder();
            for (Object[] queryResult : this.doQuery(toType, fromType, Collections.singleton(fromId))) {
                toIdsBuilder.add((Long)queryResult[1]);
            }
            ImmutableCollection toIds = toIdsBuilder.build();
            this.cache.putIntoCache(fromType, fromId, toType, (ImmutableSet<Long>)toIds);
            return toIds;
        }
        return result;
    }

    static {
        ImmutableMap.Builder<Map.Entry<String, String>, String> builder = ImmutableMap.builder();
        builder.put(Maps.immutableEntry("Folder", "Folder"), "SELECT parentFolder.id, id FROM Folder WHERE parentFolder.id IN (:ids)");
        builder.put(Maps.immutableEntry("Folder", "Image"), "SELECT parent.id, child.id FROM FolderImageLink WHERE parent.id IN (:ids)");
        builder.put(Maps.immutableEntry("Project", "Dataset"), "SELECT parent.id, child.id FROM ProjectDatasetLink WHERE parent.id IN (:ids)");
        builder.put(Maps.immutableEntry("Dataset", "Image"), "SELECT parent.id, child.id FROM DatasetImageLink WHERE parent.id IN (:ids)");
        builder.put(Maps.immutableEntry("Screen", "Plate"), "SELECT parent.id, child.id FROM ScreenPlateLink WHERE parent.id IN (:ids)");
        builder.put(Maps.immutableEntry("Plate", "Well"), "SELECT plate.id, id FROM Well WHERE plate.id IN (:ids)");
        builder.put(Maps.immutableEntry("Well", "Image"), "SELECT well.id, image.id FROM WellSample WHERE well.id IN (:ids)");
        builder.put(Maps.immutableEntry("Fileset", "Image"), "SELECT fileset.id, id FROM Image WHERE fileset.id IN (:ids)");
        builder.put(Maps.immutableEntry("Image", "Fileset"), "SELECT id, fileset.id FROM Image WHERE fileset.id IS NOT NULL AND id IN (:ids)");
        builder.put(Maps.immutableEntry("Image", "Well"), "SELECT image.id, well.id FROM WellSample WHERE image.id IN (:ids)");
        builder.put(Maps.immutableEntry("Well", "Plate"), "SELECT id, plate.id FROM Well WHERE id IN (:ids)");
        builder.put(Maps.immutableEntry("Plate", "Screen"), "SELECT child.id, parent.id FROM ScreenPlateLink WHERE child.id IN (:ids)");
        builder.put(Maps.immutableEntry("Image", "Dataset"), "SELECT child.id, parent.id FROM DatasetImageLink WHERE child.id IN (:ids)");
        builder.put(Maps.immutableEntry("Dataset", "Project"), "SELECT child.id, parent.id FROM ProjectDatasetLink WHERE child.id IN (:ids)");
        builder.put(Maps.immutableEntry("Image", "Folder"), "SELECT child.id, parent.id FROM FolderImageLink WHERE child.id IN (:ids)");
        hqlFromTo = builder.build();
    }
}

