/*
 * Decompiled with CFR 0.152.
 */
package ome.services.procs;

import java.util.HashSet;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.services.procs.Process;
import ome.services.procs.ProcessCallback;
import ome.services.procs.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSkeleton
implements Process {
    private final Logger log;
    private final Set<ProcessCallback> cbs = new HashSet<ProcessCallback>();
    private final Processor processor;
    private boolean cancelled;
    private boolean finished;

    public ProcessSkeleton(Processor p) {
        this.processor = p;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public Processor processor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCallback(ProcessCallback cb) {
        Set<ProcessCallback> set = this.cbs;
        synchronized (set) {
            this.checkState();
            boolean added = this.cbs.add(cb);
            this.debug("Added", cb, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCallback(ProcessCallback cb) {
        Set<ProcessCallback> set = this.cbs;
        synchronized (set) {
            this.checkState();
            boolean removed = this.cbs.remove(cb);
            this.debug("removed", cb, removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Set<ProcessCallback> set = this.cbs;
        synchronized (set) {
            this.checkState();
            for (ProcessCallback cb : this.cbs) {
                try {
                    cb.processCancelled(this);
                }
                catch (Exception e) {
                    this.log.warn(String.format("Exception thrown by %s while cancelling %s. Removing callback.", cb, this), e);
                    this.cbs.remove(cb);
                }
            }
            this.cbs.clear();
            this.cancelled = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Process cancelled: " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        Set<ProcessCallback> set = this.cbs;
        synchronized (set) {
            this.checkState();
            for (ProcessCallback cb : this.cbs) {
                try {
                    cb.processFinished(this);
                }
                catch (Exception e) {
                    this.log.warn(String.format("Exception throw by %s while finished %s. Removing callback.", cb, this), e);
                    this.cbs.remove(cb);
                }
            }
            this.cbs.clear();
            this.finished = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Process finished: " + this);
            }
        }
    }

    @Override
    public boolean isActive() {
        return !this.cancelled && !this.finished;
    }

    protected void checkState() {
        if (!this.isActive()) {
            String state = this.cancelled ? "cancelled" : "finished";
            throw new ApiUsageException(String.format("Process already %s: %s", state, this));
        }
    }

    private void debug(String action, ProcessCallback cb, boolean added) {
        if (this.log.isDebugEnabled()) {
            if (added) {
                this.log.debug(String.format("%s %s to %s", cb, action, this));
            } else {
                this.log.debug(String.format("%s already %s to %s", cb, action, this));
            }
        }
    }
}

