/*
 * Decompiled with CFR 0.152.
 */
package ome.services.pixeldata;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ome.conditions.InternalException;
import ome.io.messages.MissingPyramidMessage;
import ome.model.core.Pixels;
import ome.model.enums.EventType;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.security.basic.CurrentDetails;
import ome.services.pixeldata.PixelDataHandler;
import ome.services.sessions.SessionManager;
import ome.services.util.ExecutionThread;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.system.metrics.Metrics;
import ome.system.metrics.NullMetrics;
import ome.system.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.transaction.annotation.Transactional;

public class PixelDataThread
extends ExecutionThread
implements ApplicationListener<MissingPyramidMessage> {
    private static final Logger log = LoggerFactory.getLogger(PixelDataThread.class);
    private static final Principal DEFAULT_PRINCIPAL = new Principal("root", "system", "Task");
    private static final int DEFAULT_THREADS = 1;
    private final String uuid;
    private final int numThreads;
    private final boolean performProcessing;
    private final Timer batchTimer;

    public PixelDataThread(SessionManager manager, Executor executor, PixelDataHandler handler, String uuid) {
        this(manager, executor, handler, DEFAULT_PRINCIPAL, uuid, 1);
    }

    public PixelDataThread(SessionManager manager, Executor executor, PixelDataHandler handler, String uuid, int numThreads) {
        this(manager, executor, handler, DEFAULT_PRINCIPAL, uuid, numThreads, new NullMetrics());
    }

    public PixelDataThread(SessionManager manager, Executor executor, PixelDataHandler handler, Principal principal, String uuid, int numThreads) {
        this(executor.getContext().containsBean("pixelDataTrigger"), manager, executor, handler, principal, uuid, numThreads, new NullMetrics());
    }

    public PixelDataThread(SessionManager manager, Executor executor, PixelDataHandler handler, String uuid, int numThreads, Metrics metrics) {
        this(executor.getContext().containsBean("pixelDataTrigger"), manager, executor, handler, DEFAULT_PRINCIPAL, uuid, numThreads, metrics);
    }

    public PixelDataThread(SessionManager manager, Executor executor, PixelDataHandler handler, Principal principal, String uuid, int numThreads, Metrics metrics) {
        this(executor.getContext().containsBean("pixelDataTrigger"), manager, executor, handler, principal, uuid, numThreads, metrics);
    }

    public PixelDataThread(boolean performProcessing, SessionManager manager, Executor executor, PixelDataHandler handler, Principal principal, String uuid, int numThreads) {
        this(performProcessing, manager, executor, handler, principal, uuid, numThreads, new NullMetrics());
    }

    public PixelDataThread(boolean performProcessing, SessionManager manager, Executor executor, PixelDataHandler handler, Principal principal, String uuid, int numThreads, Metrics metrics) {
        super(manager, executor, handler, principal);
        this.performProcessing = performProcessing;
        this.uuid = uuid;
        this.numThreads = numThreads;
        this.batchTimer = metrics.timer(this, "batch");
    }

    public void start() {
        StringBuilder sb = new StringBuilder();
        sb.append("Initializing PixelDataThread");
        if (this.performProcessing) {
            sb.append(String.format(" (threads=%s)", this.numThreads));
        } else {
            sb.append(" (create events only)");
        }
        log.info(sb.toString());
    }

    @Override
    public void doRun() {
        if (this.performProcessing) {
            ExecutorCompletionService<Object> ecs = new ExecutorCompletionService<Object>(this.executor.getService(), new ArrayBlockingQueue(this.numThreads));
            List eventLogs = (List)this.executor.execute(this.getPrincipal(), this.work);
            for (final EventLog log : eventLogs) {
                ecs.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return PixelDataThread.this.go(log);
                    }
                });
            }
            int count = eventLogs.size();
            while (count > 0) {
                try {
                    Future future = ecs.poll(500L, TimeUnit.MILLISECONDS);
                    if (future == null || future.get() == null) continue;
                    --count;
                }
                catch (ExecutionException ee) {
                    this.onExecutionException(ee);
                }
                catch (InterruptedException ie) {
                    log.debug("Interrupted; looping", ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object go(EventLog log) {
        Timer.Context timer = this.batchTimer.time();
        try {
            this.executor.execute(this.getPrincipal(), new HandleEventLog(log, (PixelDataHandler)this.work, (Object)this, "handleEventLog", new Object[0]));
            EventLog eventLog = log;
            return eventLog;
        }
        finally {
            timer.stop();
        }
    }

    protected void onExecutionException(ExecutionException ee) {
        log.error("ExceptionException!", ee.getCause());
    }

    public void stop() {
        log.info("Shutting down PixelDataThread");
        ((PixelDataHandler)this.work).loader.setStop(true);
    }

    public void onApplicationEvent(final MissingPyramidMessage mpm) {
        log.info("Received: " + (Object)((Object)mpm));
        CurrentDetails cd = (CurrentDetails)this.executor.getContext().getBean(CurrentDetails.class);
        if (cd.size() <= 0) {
            throw new InternalException("Not logged in.");
        }
        final EventContext ec = cd.getCurrentEventContext();
        if (null == ec.getCurrentUserId()) {
            throw new InternalException("No user! Must be wrapped by call to Executor?");
        }
        Future<EventLog> future = this.executor.submit(cd.getContext(), new Callable<EventLog>(){

            @Override
            public EventLog call() throws Exception {
                return PixelDataThread.this.makeEvent(ec, mpm);
            }
        });
        this.executor.get(future);
    }

    private EventLog makeEvent(final EventContext ec, final MissingPyramidMessage mpm) {
        Principal p = new Principal(this.uuid);
        HashMap<String, String> callContext = new HashMap<String, String>();
        callContext.put("omero.group", "-1");
        final Long groupID = (Long)this.executor.execute(callContext, p, new Executor.SimpleWork(this, "getGroupId", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                ExperimenterGroup group = (ExperimenterGroup)sf.getQueryService().findByQuery("select p.details.group from Pixels p where p.id = :id", new Parameters().addId(mpm.pixelsID));
                return group.getId();
            }
        });
        callContext.put("omero.group", groupID.toString());
        return (EventLog)this.executor.execute(callContext, p, new Executor.SimpleWork(this, "createEvent", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                log.info("Creating PIXELDATA event for pixels id:" + mpm.pixelsID);
                EventType type = sf.getTypesService().getEnumeration(EventType.class, ec.getCurrentEventType());
                EventLog el = new EventLog();
                Event e = new Event();
                e.setExperimenter(new Experimenter(ec.getCurrentUserId(), false));
                e.setExperimenterGroup(new ExperimenterGroup(groupID, false));
                e.setSession(new Session(ec.getCurrentSessionId(), false));
                e.setTime(new Timestamp(new Date().getTime()));
                e.setType(type);
                el.setAction("PIXELDATA");
                el.setEntityId(mpm.pixelsID);
                el.setEntityType(Pixels.class.getName());
                el.setEvent(e);
                return sf.getUpdateService().saveAndReturnObject(el);
            }
        });
    }

    private static class HandleEventLog
    extends Executor.SimpleWork {
        private final PixelDataHandler handler;
        private final EventLog log;

        HandleEventLog(EventLog log, PixelDataHandler handler, Object self, String description, Object ... args) {
            super(self, description, args);
            this.handler = handler;
            this.log = log;
        }

        @Transactional(readOnly=false)
        public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
            this.handler.handleEventLog(this.log, session, sf);
            return null;
        }
    }
}

