/*
 * Decompiled with CFR 0.152.
 */
package ome.services.pixeldata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ome.model.meta.EventLog;

public class PersistentEventLogLoader
extends ome.services.eventlogs.PersistentEventLogLoader {
    protected final String repo;
    protected long lowestEntityId = -1L;
    protected final int numThreads;
    protected List<long[]> dataPerUser = null;

    public PersistentEventLogLoader(String repo, int numThreads) {
        this.repo = repo;
        this.numThreads = numThreads;
    }

    @Override
    public void initialize() {
    }

    @Override
    protected EventLog query() {
        if (this.available()) {
            return this.pop();
        }
        long current_id = this.getCurrentId();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Locating next PIXELSDATA EventLog repo:%s > id:%d", this.repo, current_id));
        }
        this.dataPerUser = new ArrayList<long[]>();
        List<long[]> tmp = this.sql.nextPixelsDataLogForRepo(this.repo, current_id, this.numThreads);
        while (tmp.size() > 0) {
            long[] data = tmp.remove(0);
            if (this.dataPerUser.size() < this.numThreads) {
                this.dataPerUser.add(data);
                this.log.debug("Data: " + Arrays.toString(data));
                continue;
            }
            if (data[3] == 1L) {
                this.dataPerUser.add(data);
                this.log.debug("Data: " + Arrays.toString(data));
                continue;
            }
            this.log.debug("Skip: " + Arrays.toString(data));
        }
        if (this.available()) {
            return this.pop();
        }
        return null;
    }

    protected boolean available() {
        return this.dataPerUser != null && this.dataPerUser.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventLog pop() {
        if (!this.available()) {
            throw new IllegalStateException();
        }
        long[] data = this.dataPerUser.remove(0);
        long experimenter = data[0];
        long eventLog = data[1];
        long pixels = data[2];
        long row = data[3];
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Handling pixels id:%d for user id:%d", pixels, experimenter));
        }
        if (this.lowestEntityId < 0L) {
            this.lowestEntityId = eventLog;
        } else if (this.lowestEntityId > eventLog) {
            this.lowestEntityId = eventLog;
        }
        if (!this.available()) {
            this.dataPerUser = null;
            try {
                this.setCurrentId(this.lowestEntityId);
            }
            finally {
                this.lowestEntityId = -1L;
            }
        }
        return this.queryService.get(EventLog.class, eventLog);
    }
}

