/*
 * Decompiled with CFR 0.152.
 */
package ome.services.mail;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.parameters.Parameters;
import ome.services.mail.MailSender;
import ome.services.messages.EventLogsMessage;
import ome.system.Roles;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;

public class ObjectMailSender
extends MailSender
implements ApplicationListener<EventLogsMessage> {
    private Class<IObject> klass;
    private String action;
    private String queryString;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Class<IObject> getObjectClass() {
        return this.klass;
    }

    public void setObjectClass(Class<IObject> klass) {
        this.klass = klass;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void onApplicationEvent(EventLogsMessage elm) {
        if (!this.isEnabled()) {
            return;
        }
        if (StringUtils.isEmpty(this.queryString)) {
            return;
        }
        Collection<EventLog> matches = elm.matches(this.klass.getName(), this.action);
        if (matches.isEmpty()) {
            return;
        }
        this.sendEmail(matches);
    }

    protected void sendEmail(Collection<EventLog> matches) {
        Parameters p = new Parameters();
        Roles roles = this.getRoles();
        p.addString("systemGroup", roles.getSystemGroupName());
        p.addLong("systemGroupId", roles.getSystemGroupId());
        p.addString("userGroup", roles.getUserGroupName());
        p.addLong("userGroupId", roles.getUserGroupId());
        p.addString("rootUser", roles.getRootName());
        p.addLong("rootUserId", roles.getRootId());
        StringBuilder sb = new StringBuilder();
        sb.append("Modified objects:\n");
        for (EventLog el : matches) {
            HashSet<String> addresses = new HashSet<String>();
            p.addId(el.getEntityId());
            sb.append(this.klass);
            sb.append(":");
            sb.append(el.getEntityId());
            sb.append(" - ");
            sb.append(el.getAction());
            sb.append("\n");
            for (IObject obj : this.getQueryService().findAllByQuery(this.queryString, p)) {
                if (obj instanceof Experimenter) {
                    this.addUser(addresses, (Experimenter)obj);
                    continue;
                }
                if (!(obj instanceof ExperimenterGroup)) continue;
                for (Experimenter exp : ((ExperimenterGroup)obj).linkedExperimenterList()) {
                    this.addUser(addresses, exp);
                }
            }
            if (addresses.isEmpty()) continue;
            this.sendBlind(addresses, String.format("%s %s notification", this.action, this.klass.getSimpleName()), sb.toString());
        }
    }

    @Override
    protected void addUser(Set<String> addresses, Experimenter exp) {
        String email = exp.getEmail();
        if (!StringUtils.isEmpty(email)) {
            addresses.add(email);
        }
    }
}

