/*
 * Decompiled with CFR 0.152.
 */
package ome.services.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import ome.model.annotations.MapAnnotation;
import ome.model.internal.NamedValue;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SimpleMessageListener;

public class MapAnnotationSubethaListener
implements SimpleMessageListener {
    public static final String NAMESPACE = "openmicroscopy.org/testing/smtp";
    public static final String FROM = "from";
    public static final String TO = "to";
    private static final Logger log = LoggerFactory.getLogger(MapAnnotationSubethaListener.class);
    private final Executor executor;
    private final Principal principal;

    public MapAnnotationSubethaListener(Executor executor, Principal principal) {
        this.executor = executor;
        this.principal = principal;
    }

    public MapAnnotationSubethaListener(Executor executor, String uuid) {
        this.executor = executor;
        this.principal = new Principal(uuid);
    }

    public boolean accept(String arg0, String arg1) {
        return true;
    }

    public void deliver(final String from, final String recipient, final InputStream stream) throws TooMuchDataException, IOException {
        this.executor.execute(this.principal, new Executor.SimpleWork(this, "deliver", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                MapAnnotation ma = new MapAnnotation();
                ma.setNs(MapAnnotationSubethaListener.NAMESPACE);
                ma.setDescription(MapAnnotationSubethaListener.this.parseStream(stream));
                ma.setMapValue(new ArrayList<NamedValue>());
                ma.getMapValue().add(new NamedValue(MapAnnotationSubethaListener.FROM, from));
                ma.getMapValue().add(new NamedValue(MapAnnotationSubethaListener.TO, recipient));
                ma = sf.getUpdateService().saveAndReturnObject(ma);
                log.info("Saved email: MapAnnotation:" + ma.getId());
                return ma;
            }
        });
    }

    protected String parseStream(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

