/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.collect.ImmutableMap;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import ome.system.Roles;
import org.hibernate.Session;

public class GroupPredicate
implements GraphPolicyRulePredicate {
    private static ImmutableMap<String, GroupMarker> groupsByName = ImmutableMap.of("system", GroupMarker.SYSTEM, "user", GroupMarker.USER, "guest", GroupMarker.GUEST);
    private final ImmutableMap<Long, GroupMarker> groupsById;

    public GroupPredicate(Roles securityRoles) {
        this.groupsById = ImmutableMap.of(securityRoles.getSystemGroupId(), GroupMarker.SYSTEM, securityRoles.getUserGroupId(), GroupMarker.USER, securityRoles.getGuestGroupId(), GroupMarker.GUEST);
    }

    @Override
    public String getName() {
        return "group";
    }

    @Override
    public void noteDetails(Session session, IObject object, String realClass, long id) {
    }

    @Override
    public boolean isMatch(GraphPolicy.Details object, String parameter) throws GraphException {
        boolean isInvert;
        if (object.groupId == null) {
            throw new GraphException("no group for " + object);
        }
        if (parameter.startsWith("!")) {
            parameter = parameter.substring(1);
            isInvert = true;
        } else {
            isInvert = false;
        }
        GroupMarker sought = groupsByName.get(parameter);
        if (sought == null) {
            throw new GraphException("unknown group: " + parameter);
        }
        GroupMarker actual = this.groupsById.get(object.groupId);
        return isInvert != (sought == actual);
    }

    private static enum GroupMarker {
        SYSTEM,
        USER,
        GUEST;

    }
}

