/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicyRulePredicate;
import org.hibernate.Session;

public abstract class GraphPolicy {
    protected final Map<String, GraphPolicyRulePredicate> predicates = new HashMap<String, GraphPolicyRulePredicate>();

    public abstract GraphPolicy getCleanInstance();

    public void registerPredicate(GraphPolicyRulePredicate predicate) {
        this.predicates.put(predicate.getName(), predicate);
    }

    public abstract void setCondition(String var1);

    public abstract boolean isCondition(String var1);

    public void noteDetails(Session session, IObject object, String realClass, long id) {
        for (GraphPolicyRulePredicate predicate : this.predicates.values()) {
            predicate.noteDetails(session, object, realClass, id);
        }
    }

    public static Set<Details> allObjects(Collection<Set<Details>> linkedFrom, Details rootObject, Collection<Set<Details>> linkedTo) {
        HashSet<Details> allTerms = new HashSet<Details>();
        allTerms.add(rootObject);
        for (Set<Details> terms : linkedFrom) {
            allTerms.addAll(terms);
        }
        for (Set<Details> terms : linkedTo) {
            allTerms.addAll(terms);
        }
        return allTerms;
    }

    public abstract Set<Details> review(Map<String, Set<Details>> var1, Details var2, Map<String, Set<Details>> var3, Set<String> var4, boolean var5) throws GraphException;

    public static abstract class Details {
        public final IObject subject;
        public final Long ownerId;
        public final Long groupId;
        public final Set<Ability> permissions;
        public Action action;
        public Orphan orphan;
        public boolean isCheckPermissions;

        Details(IObject subject, Long ownerId, Long groupId, Action action, Orphan orphan, boolean mayUpdate, boolean mayDelete, boolean mayChmod, boolean isOwner, boolean isCheckPermissions) {
            this.subject = subject;
            this.ownerId = ownerId;
            this.groupId = groupId;
            this.action = action;
            this.orphan = orphan;
            this.permissions = EnumSet.noneOf(Ability.class);
            if (mayUpdate) {
                this.permissions.add(Ability.UPDATE);
            }
            if (mayDelete) {
                this.permissions.add(Ability.DELETE);
            }
            if (mayChmod) {
                this.permissions.add(Ability.CHMOD);
            }
            if (isOwner) {
                this.permissions.add(Ability.OWN);
            }
            this.isCheckPermissions = isCheckPermissions;
        }
    }

    public static enum Ability {
        UPDATE,
        DELETE,
        CHMOD,
        OWN;

    }

    public static enum Orphan {
        IRRELEVANT,
        RELEVANT,
        IS_LAST,
        IS_NOT_LAST;

    }

    public static enum Action {
        EXCLUDE,
        DELETE,
        INCLUDE,
        OUTSIDE;

    }
}

