/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.base.Joiner;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ome.model.units.GenericEnumType;
import ome.model.units.Unit;
import ome.services.graphs.GraphPathBean;
import ome.services.scheduler.ThreadPool;
import ome.system.OmeroContext;
import ome.tools.hibernate.ListAsSQLArrayUserType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

public class GraphPathReport {
    private static GraphPathBean model;
    private static Writer out;

    private static String getSimpleName(String fullName) {
        return fullName.substring(1 + fullName.lastIndexOf(46));
    }

    private static String labelFor(String className) {
        return "OMERO model class " + className;
    }

    private static String labelFor(String className, String propertyName) {
        return "OMERO model property " + className + '.' + propertyName;
    }

    private static String linkTo(String className) {
        StringBuffer sb = new StringBuffer();
        sb.append(":ref:");
        sb.append('`');
        sb.append(className);
        sb.append(' ');
        sb.append('<');
        sb.append(GraphPathReport.labelFor(className));
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String linkTo(String className, String propertyName) {
        StringBuffer sb = new StringBuffer();
        sb.append(":ref:");
        sb.append('`');
        sb.append(className);
        sb.append('.');
        sb.append(propertyName);
        sb.append(' ');
        sb.append('<');
        sb.append(GraphPathReport.labelFor(className));
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String linkToJavadoc(String className) {
        StringBuffer sb = new StringBuffer();
        sb.append(":javadoc:");
        sb.append('`');
        sb.append(GraphPathReport.getSimpleName(className));
        sb.append(' ');
        sb.append('<');
        sb.append(className.replace('.', '/'));
        sb.append(".html");
        sb.append('>');
        sb.append('`');
        return sb.toString();
    }

    private static String reportType(String className, String propertyName) {
        Type type = model.getPropertyType(className, propertyName);
        UserType userType = type instanceof CustomType ? ((CustomType)type).getUserType() : null;
        if (type instanceof EnumType) {
            return "enumeration";
        }
        if (userType instanceof GenericEnumType) {
            Class<Unit> unitQuantityClass = ((GenericEnumType)userType).getQuantityClass();
            return "enumeration of " + GraphPathReport.linkToJavadoc(unitQuantityClass.getName());
        }
        if (type instanceof ListType || userType instanceof ListAsSQLArrayUserType) {
            return "list";
        }
        if (type instanceof MapType) {
            return "map";
        }
        return "``" + type.getName() + "``";
    }

    private static void report() throws IOException {
        out.write("Glossary of all OMERO Model Objects\n");
        out.write("===================================\n\n");
        out.write("Overview\n");
        out.write("--------\n\n");
        out.write(".. include:: EveryObjectOverview.inc\n\n");
        out.write("Reference\n");
        out.write("---------\n\n");
        TreeMap<String, String> classNames = new TreeMap<String, String>();
        for (String string : model.getAllClasses()) {
            classNames.put(GraphPathReport.getSimpleName(string), string);
        }
        for (Map.Entry entry : classNames.entrySet()) {
            String simpleName = (String)entry.getKey();
            String className = (String)entry.getValue();
            out.write(".. _" + GraphPathReport.labelFor(simpleName) + ":\n\n");
            out.write(simpleName + "\n");
            char[] underline = new char[simpleName.length()];
            for (int i = 0; i < underline.length; ++i) {
                underline[i] = 34;
            }
            out.write(underline);
            out.write("\n\n");
            TreeSet<String> superclassOf = new TreeSet<String>();
            for (String string : model.getDirectSubclassesOf(className)) {
                superclassOf.add(GraphPathReport.linkTo(GraphPathReport.getSimpleName(string)));
            }
            TreeSet<String> linkerText = new TreeSet<String>();
            for (Map.Entry<String, String> linker : model.getLinkedBy(className)) {
                linkerText.add(GraphPathReport.linkTo(GraphPathReport.getSimpleName(linker.getKey()), linker.getValue()));
            }
            if (!superclassOf.isEmpty() || !linkerText.isEmpty()) {
                if (!superclassOf.isEmpty()) {
                    out.write("Subclasses: " + Joiner.on(", ").join(superclassOf) + "\n\n");
                }
                if (!linkerText.isEmpty()) {
                    out.write("Used by: " + Joiner.on(", ").join(linkerText) + "\n\n");
                }
            }
            out.write("Properties:\n");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            HashMap<String, String> valueText = new HashMap<String, String>();
            for (String string : model.getSuperclassesOfReflexive(className)) {
                for (Map.Entry<String, String> classAndPropertyNames : model.getLinkedTo(string)) {
                    String valueClassName = classAndPropertyNames.getKey();
                    String propertyName = classAndPropertyNames.getValue();
                    treeMap.put(propertyName, string);
                    valueText.put(propertyName, GraphPathReport.linkTo(GraphPathReport.getSimpleName(valueClassName)));
                }
                for (String propertyName : model.getSimpleProperties(string, true)) {
                    treeMap.put(propertyName, string);
                    valueText.put(propertyName, GraphPathReport.reportType(string, propertyName));
                }
            }
            for (Map.Entry entry2 : treeMap.entrySet()) {
                String propertyName = (String)entry2.getKey();
                String declarerName = (String)entry2.getValue();
                out.write("  | " + propertyName + ": " + (String)valueText.get(propertyName));
                switch (model.getPropertyKind(declarerName, propertyName)) {
                    case OPTIONAL: {
                        out.write(" (optional)");
                        break;
                    }
                    case REQUIRED: {
                        break;
                    }
                    case COLLECTION: {
                        out.write(" (multiple)");
                    }
                }
                if (!declarerName.equals(className)) {
                    out.write(" from " + GraphPathReport.linkTo(GraphPathReport.getSimpleName(declarerName)));
                } else {
                    String interfaceName = model.getInterfaceImplemented(className, propertyName);
                    if (interfaceName != null) {
                        out.write(", see " + GraphPathReport.linkToJavadoc(interfaceName));
                    }
                }
                out.write("\n");
            }
            out.write("\n");
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("must give output filename as single argument");
            System.exit(1);
        }
        out = new FileWriter(argv[0]);
        OmeroContext context = OmeroContext.getManagedServerContext();
        model = (GraphPathBean)context.getBean("graphPathBean", GraphPathBean.class);
        GraphPathReport.report();
        out.close();
        ((ThreadPool)context.getBean("threadPool", ThreadPool.class)).getExecutor().shutdown();
        context.closeAll();
    }
}

