/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.tools.spring.OnContextRefreshedEventListener;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public class GraphPathBean
extends OnContextRefreshedEventListener {
    private static final Logger log = LoggerFactory.getLogger(GraphPathBean.class);
    private final Map<String, Class<? extends IObject>> classesBySimpleName = new HashMap<String, Class<? extends IObject>>();
    private final Map<String, String> superclasses = new HashMap<String, String>();
    private final SetMultimap<String, String> subclasses = HashMultimap.create();
    private final SetMultimap<String, String> allSuperclasses = HashMultimap.create();
    private final SetMultimap<String, String> allSubclasses = HashMultimap.create();
    private final SetMultimap<String, Map.Entry<String, String>> linkedTo = HashMultimap.create();
    private final SetMultimap<String, Map.Entry<String, String>> linkedBy = HashMultimap.create();
    private final HashMap<Map.Entry<String, String>, PropertyKind> propertyKinds = new HashMap();
    private final Map<Map.Entry<String, String>, Type> propertyTypes = new HashMap<Map.Entry<String, String>, Type>();
    private final Map<Map.Entry<String, String>, String> implementedInterfaces = new HashMap<Map.Entry<String, String>, String>();
    private final Set<Map.Entry<String, String>> accessibleProperties = new HashSet<Map.Entry<String, String>>();
    private final Map<String, String> classIdProperties = new HashMap<String, String>();
    private final SetMultimap<String, String> simplePropertiesNested = HashMultimap.create();
    private final SetMultimap<String, String> simplePropertiesDirect = HashMultimap.create();

    @Override
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        if (this.propertyKinds.isEmpty()) {
            ApplicationContext context = event.getApplicationContext();
            SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)context.getBean("sessionFactory", SessionFactoryImplementor.class);
            this.initialize(sessionFactory);
        }
    }

    private Class<? extends IObject> getInterfaceForProperty(String className, String propertyName) {
        AbstractCollection interfacesFrom;
        Class interfaceForProperty = null;
        try {
            interfacesFrom = ImmutableSet.of(Class.forName(className).asSubclass(IObject.class));
        }
        catch (ClassNotFoundException e) {
            log.error("could not load " + IObject.class.getName() + " subclass " + className);
            return null;
        }
        while (!interfacesFrom.isEmpty()) {
            HashSet<Class<IObject>> interfacesTo = new HashSet<Class<IObject>>();
            for (Class clazz : interfacesFrom) {
                if (clazz.isInterface() && BeanUtils.getPropertyDescriptor((Class)clazz, (String)propertyName) != null) {
                    interfaceForProperty = clazz;
                }
                for (Class<?> newInterface : clazz.getInterfaces()) {
                    if (newInterface == IObject.class || !IObject.class.isAssignableFrom(newInterface)) continue;
                    interfacesTo.add(newInterface.asSubclass(IObject.class));
                    this.classesBySimpleName.put(newInterface.getSimpleName(), newInterface.asSubclass(IObject.class));
                }
            }
            interfacesFrom = interfacesTo;
        }
        return interfaceForProperty == null ? null : interfaceForProperty;
    }

    private static boolean ignoreProperty(String name) {
        return "perm1".equals(name) || name.startsWith("_") || name.endsWith("CountPerOwner");
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(SessionFactoryImplementor sessionFactory) {
        Map classesMetadata = sessionFactory.getAllClassMetadata();
        for (String string : classesMetadata.keySet()) {
            try {
                Class<?> actualClass = Class.forName(string);
                if (IObject.class.isAssignableFrom(actualClass)) {
                    this.classesBySimpleName.put(actualClass.getSimpleName(), actualClass.asSubclass(IObject.class));
                    Set set = sessionFactory.getEntityPersister(string).getEntityMetamodel().getSubclassEntityNames();
                    for (String subclassName : set) {
                        Class<?> actualSubclass;
                        if (subclassName.equals(string) || (actualSubclass = Class.forName(subclassName)).getSuperclass() != actualClass) continue;
                        this.superclasses.put(subclassName, string);
                        this.subclasses.put(string, subclassName);
                    }
                    continue;
                }
                log.warn("mapped class " + string + " is not a " + IObject.class.getName());
            }
            catch (ClassNotFoundException e) {
                log.error("could not instantiate class", e);
            }
        }
        for (Map.Entry entry : this.superclasses.entrySet()) {
            void var6_13;
            String startClass = (String)entry.getKey();
            String string = (String)entry.getValue();
            while (var6_13 != null) {
                this.allSuperclasses.put(startClass, (String)var6_13);
                this.allSubclasses.put((String)var6_13, startClass);
                String string2 = this.superclasses.get(var6_13);
            }
        }
        LinkedList<PropertyDetails> propertyQueue = new LinkedList<PropertyDetails>();
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : classesMetadata.entrySet()) {
            String className = (String)entry.getKey();
            ClassMetadata metadata = (ClassMetadata)entry.getValue();
            this.classIdProperties.put(metadata.getEntityName(), metadata.getIdentifierPropertyName());
            String[] propertyNames = metadata.getPropertyNames();
            Type[] propertyTypes = metadata.getPropertyTypes();
            boolean[] propertyNullabilities = metadata.getPropertyNullability();
            for (int i = 0; i < propertyNames.length; ++i) {
                List<String> propertyPath = Collections.singletonList(propertyNames[i]);
                propertyQueue.add(new PropertyDetails(className, propertyPath, propertyTypes[i], propertyNullabilities[i]));
            }
            HashSet<String> propertyNamesSet = new HashSet<String>(propertyNames.length);
            propertyNamesSet.addAll(Arrays.asList(propertyNames));
            hashMap.put(className, propertyNamesSet);
        }
        while (!propertyQueue.isEmpty()) {
            String valueClassName;
            void var6_20;
            PropertyDetails property = (PropertyDetails)propertyQueue.remove();
            if (GraphPathBean.ignoreProperty(property.path.get(property.path.size() - 1))) continue;
            if (property.type instanceof ComponentType) {
                ComponentType componentType = (ComponentType)property.type;
                String[] componentPropertyNames = componentType.getPropertyNames();
                Type[] componentPropertyTypes = componentType.getSubtypes();
                boolean[] componentPropertyNullabilities = componentType.getPropertyNullability();
                for (int i = 0; i < componentPropertyNames.length; ++i) {
                    ArrayList<String> componentPropertyPath = new ArrayList<String>(property.path.size() + 1);
                    componentPropertyPath.addAll(property.path);
                    componentPropertyPath.add(componentPropertyNames[i]);
                    propertyQueue.add(new PropertyDetails(property.holder, componentPropertyPath, componentPropertyTypes[i], componentPropertyNullabilities[i]));
                }
                continue;
            }
            if (property.type instanceof CollectionType) {
                CollectionType ct = (CollectionType)property.type;
                boolean bl = sessionFactory.getCollectionPersister(ct.getRole()).getElementType().isEntityType();
            } else {
                boolean bl = property.type instanceof AssociationType;
            }
            String fullPropertyPath = Joiner.on('.').join(property.path);
            boolean propertyIsAccessible = false;
            String classToInstantiateName = property.holder;
            Class<?> classToInstantiate = null;
            try {
                classToInstantiate = Class.forName(classToInstantiateName);
                while (Modifier.isAbstract(classToInstantiate.getModifiers())) {
                    classToInstantiateName = this.allSubclasses.get(classToInstantiateName).iterator().next();
                    classToInstantiate = Class.forName(classToInstantiateName);
                }
                try {
                    PropertyUtils.getNestedProperty(classToInstantiate.newInstance(), (String)fullPropertyPath);
                    propertyIsAccessible = true;
                }
                catch (NoSuchMethodException componentPropertyPath) {
                }
                catch (NestedNullException e) {
                    log.debug("guessing " + fullPropertyPath + " of " + property.holder + " to be accessible");
                    propertyIsAccessible = true;
                }
            }
            catch (ReflectiveOperationException e) {
                log.error("could not probe property " + fullPropertyPath + " of " + property.holder, e);
                continue;
            }
            char arrowShaft = property.isNullable ? (char)'-' : '=';
            StringBuffer sb = new StringBuffer();
            sb.append(property.holder);
            sb.append(' ');
            for (String propertyName : property.path) {
                sb.append(arrowShaft);
                sb.append(arrowShaft);
                sb.append(propertyName);
            }
            sb.append(arrowShaft);
            sb.append(arrowShaft);
            sb.append("> ");
            if (var6_20 != false) {
                valueClassName = ((AssociationType)property.type).getAssociatedEntityName(sessionFactory);
                sb.append(valueClassName);
            } else {
                valueClassName = null;
                sb.append("value");
            }
            if (property.type.isCollectionType()) {
                sb.append("[]");
            }
            if (!propertyIsAccessible) {
                sb.append(" (inaccessible)");
            }
            String shortPropertyPath = property.path.get(0);
            String superclassWithProperty = null;
            String currentClass = property.holder;
            while ((currentClass = this.superclasses.get(currentClass)) != null) {
                if (!((Set)hashMap.get(currentClass)).contains(shortPropertyPath)) continue;
                superclassWithProperty = currentClass;
            }
            String declaringClassName = superclassWithProperty == null ? property.holder : superclassWithProperty;
            Class<? extends IObject> interfaceForProperty = this.getInterfaceForProperty(declaringClassName, shortPropertyPath);
            if (superclassWithProperty != null) {
                sb.append(" from ");
                sb.append(superclassWithProperty);
            } else {
                Map.Entry<String, String> classPropertyFullName = Maps.immutableEntry(property.holder, fullPropertyPath);
                if (interfaceForProperty != null) {
                    sb.append(" see ");
                    String implementedInterface = interfaceForProperty.getName();
                    sb.append(implementedInterface);
                    this.implementedInterfaces.put(classPropertyFullName, implementedInterface);
                }
                Map.Entry<String, String> classPropertyShortName = Maps.immutableEntry(property.holder, shortPropertyPath);
                if (valueClassName == null) {
                    this.simplePropertiesNested.put(property.holder, fullPropertyPath);
                    this.simplePropertiesDirect.put(property.holder, shortPropertyPath);
                } else {
                    this.linkedTo.put(property.holder, Maps.immutableEntry(valueClassName, fullPropertyPath));
                    this.linkedBy.put(valueClassName, classPropertyFullName);
                }
                PropertyKind propertyKind = property.type.isCollectionType() ? PropertyKind.COLLECTION : (property.isNullable ? PropertyKind.OPTIONAL : PropertyKind.REQUIRED);
                this.propertyKinds.put(classPropertyFullName, propertyKind);
                if (propertyIsAccessible) {
                    this.accessibleProperties.add(classPropertyFullName);
                }
                if (valueClassName == null && !fullPropertyPath.equals(shortPropertyPath)) {
                    this.propertyKinds.put(classPropertyShortName, propertyKind);
                    if (propertyIsAccessible) {
                        this.accessibleProperties.add(classPropertyShortName);
                    }
                }
                this.propertyTypes.put(classPropertyFullName, property.type);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(sb.toString());
        }
        log.info("initialized graph path bean with " + this.propertyKinds.size() + " properties");
    }

    public Class<? extends IObject> getClassForSimpleName(String simpleName) {
        Class<? extends IObject> namedClass = this.classesBySimpleName.get(simpleName);
        if (namedClass != null) {
            return namedClass;
        }
        try {
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        for (Class<?> subclass = Class.forName(new StringBuilder().append("omero.model.").append(simpleName).toString()); namedClass == null && subclass != Object.class; subclass = subclass.getSuperclass()) {
            namedClass = this.classesBySimpleName.get(subclass.getSimpleName());
        }
        return namedClass;
    }

    public Collection<String> getAllClasses() {
        return this.classIdProperties.keySet();
    }

    public String getDirectSuperclassOf(String className) {
        return this.superclasses.get(className);
    }

    public Set<String> getSuperclassesOf(String className) {
        return this.allSuperclasses.get(className);
    }

    public Collection<String> getSuperclassesOfReflexive(String className) {
        Set<String> superclasses = this.getSuperclassesOf(className);
        ArrayList<String> superclassesReflexive = new ArrayList<String>(superclasses.size() + 1);
        superclassesReflexive.add(className);
        superclassesReflexive.addAll(superclasses);
        return superclassesReflexive;
    }

    public Set<String> getDirectSubclassesOf(String className) {
        return this.subclasses.get(className);
    }

    public Set<String> getSubclassesOf(String className) {
        return this.allSubclasses.get(className);
    }

    public Collection<String> getSubclassesOfReflexive(String className) {
        Set<String> subclasses = this.getSubclassesOf(className);
        ArrayList<String> subclassesReflexive = new ArrayList<String>(subclasses.size() + 1);
        subclassesReflexive.add(className);
        subclassesReflexive.addAll(subclasses);
        return subclassesReflexive;
    }

    public Set<Map.Entry<String, String>> getLinkedTo(String className) {
        return this.linkedTo.get(className);
    }

    public Set<Map.Entry<String, String>> getLinkedBy(String className) {
        return this.linkedBy.get(className);
    }

    public PropertyKind getPropertyKind(String className, String propertyName) {
        return this.propertyKinds.get(Maps.immutableEntry(className, propertyName));
    }

    public Type getPropertyType(String className, String propertyName) {
        return this.propertyTypes.get(Maps.immutableEntry(className, propertyName));
    }

    public String getInterfaceImplemented(String className, String propertyName) {
        return this.implementedInterfaces.get(Maps.immutableEntry(className, propertyName));
    }

    public boolean isPropertyAccessible(String className, String propertyName) {
        return this.accessibleProperties.contains(Maps.immutableEntry(className, propertyName));
    }

    public String getIdentifierProperty(String className) {
        return this.classIdProperties.get(className);
    }

    @Deprecated
    public Set<String> getSimpleProperties(String className) {
        return this.getSimpleProperties(className, false);
    }

    public Set<String> getSimpleProperties(String className, boolean isNested) {
        return (isNested ? this.simplePropertiesNested : this.simplePropertiesDirect).get(className);
    }

    static class PropertyDetails {
        final String holder;
        final List<String> path;
        final Type type;
        final boolean isNullable;

        PropertyDetails(String className, List<String> path, Type type, boolean isNullable) {
            this.holder = className;
            this.path = path;
            this.type = type;
            this.isNullable = isNullable;
        }
    }

    static enum PropertyKind {
        OPTIONAL,
        REQUIRED,
        COLLECTION;

    }
}

