/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.File;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(PdfThread.class);
    final File file;
    final PipedWriter writer;
    final PipedReader reader;
    PDDocument document = null;

    PdfThread(File file2) throws IOException {
        this.file = file2;
        this.reader = new PipedReader();
        this.writer = new PipedWriter(this.reader);
    }

    Reader getReader() {
        return this.reader;
    }

    @Override
    public void run() {
        block9: {
            try {
                this.document = PDDocument.load((File)this.file);
            }
            catch (IOException e) {
                log.warn("Could not load Pdf " + this.file, e);
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                if (this.document == null || this.document.isEncrypted()) break block9;
                try {
                    PDFTextStripper stripper = null;
                    stripper = new PDFTextStripper();
                    stripper.writeText(this.document, (Writer)this.writer);
                }
                finally {
                    this.close();
                }
            }
            catch (IOException e) {
                log.warn("Error reading pdf file", e);
            }
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                log.warn("Error closing writer", e);
            }
        }
        if (this.document != null) {
            try {
                this.document.close();
            }
            catch (Exception e) {
                log.warn("Error closing PDF document", e);
            }
        }
    }
}

