/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.File;
import java.io.Reader;
import ome.services.fulltext.FileParser;
import ome.services.fulltext.PdfThread;
import ome.services.messages.ParserOpenFileMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfParser
extends FileParser {
    private static final Logger log = LoggerFactory.getLogger(PdfParser.class);

    @Override
    public Iterable<Reader> doParse(File file2) throws Exception {
        final PdfThread pdfThread = new PdfThread(file2);
        this.context.publishEvent(new ParserOpenFileMessage(this, pdfThread){

            @Override
            public void close() {
                try {
                    pdfThread.close();
                }
                catch (Exception e) {
                    log.warn("Error closing PdfThread " + pdfThread, e);
                }
            }
        });
        pdfThread.start();
        return this.wrap(pdfThread.getReader());
    }
}

