/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import Ice.Communicator;
import Ice.ObjectAdapter;
import Ice.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.api.IQuery;
import ome.services.eventlogs.AllEntitiesPseudoLogLoader;
import ome.services.eventlogs.AllEventsLogLoader;
import ome.services.eventlogs.EventLogLoader;
import ome.services.eventlogs.PersistentEventLogLoader;
import ome.services.fulltext.FullTextBridge;
import ome.services.fulltext.FullTextIndexer;
import ome.services.fulltext.FullTextThread;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.system.metrics.Metrics;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static AtomicBoolean shutdown = new AtomicBoolean(false);
    static String uuid;
    static String[] excludes;
    static OmeroContext context;
    static Executor executor;
    static SessionFactory factory;
    static IQuery rawQuery;
    static SessionManager manager;
    static FullTextBridge bridge;
    static PersistentEventLogLoader loader;
    static Metrics metrics;

    public static void init() {
        if (shutdown.get()) {
            return;
        }
        context = OmeroContext.getInstance("ome.fulltext");
        try {
            Scheduler scheduler = (Scheduler)context.getBean("scheduler", Scheduler.class);
            scheduler.pauseAll();
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                Main.close(sig, null);
            }
        };
        for (String sig : new String[]{"INT", "TERM", "BREAK"}) {
            try {
                Signal.handle(new Signal(sig), handler);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        uuid = (String)context.getBean("uuid", String.class);
        executor = (Executor)context.getBean("executor");
        factory = (SessionFactory)context.getBean("sessionFactory");
        rawQuery = (IQuery)context.getBean("internal-ome.api.IQuery");
        manager = (SessionManager)context.getBean("sessionManager");
        bridge = (FullTextBridge)context.getBean("fullTextBridge");
        loader = (PersistentEventLogLoader)context.getBean("eventLogLoader");
        metrics = (Metrics)context.getBean("metrics");
        String excludesStr = context.getProperty("omero.search.excludes");
        excludes = excludesStr != null ? excludesStr.split(",") : new String[0];
    }

    public static void close(Signal sig, Integer rc) {
        if (!shutdown.get()) {
            if (sig != null) {
                log.info(sig.getName() + ": Shutdown requested.");
            }
            shutdown.set(true);
            OmeroContext copy = context;
            context = null;
            copy.close();
            log.info("Done");
            if (sig != null) {
                System.exit(sig.getNumber());
            } else {
                System.exit(rc);
            }
        }
    }

    protected static FullTextThread createFullTextThread(EventLogLoader loader) {
        return Main.createFullTextThread(loader, false);
    }

    protected static FullTextThread createFullTextThread(EventLogLoader loader, boolean dryRun) {
        FullTextIndexer fti = new FullTextIndexer(loader, metrics);
        fti.setApplicationContext((ApplicationContext)context);
        fti.setDryRun(dryRun);
        FullTextThread ftt = new FullTextThread(manager, executor, fti, bridge);
        return ftt;
    }

    public static void usage() {
        StringBuilder sb = new StringBuilder();
        sb.append("usage: [-Dlogback.configurationFile=stderr.xml] ");
        sb.append("ome.service.fulltext.Main [help|foreground|dryrun|reset|standalone|events|full|");
        sb.append("reindex class1 class2 class3 ...]\n");
        System.out.println(sb.toString());
        System.exit(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        int rc = 0;
        try {
            if (args == null || args.length == 0) {
                Main.usage();
            } else if ("reset".equals(args[0])) {
                Main.reset(args);
            } else if ("dryrun".equals(args[0])) {
                Main.foreground(true, args);
            } else if ("foreground".equals(args[0])) {
                Main.foreground(false, args);
            } else if ("standalone".equals(args[0])) {
                Main.standalone(args);
            } else if ("events".equals(args[0])) {
                Main.indexAllEvents();
            } else if ("full".equals(args[0])) {
                Main.indexFullDb();
            } else if ("reindex".equals(args[0])) {
                if (args.length < 2) {
                    Main.usage();
                }
                HashSet<String> set = new HashSet<String>();
                for (int i = 1; i < args.length; ++i) {
                    set.add(args[i]);
                }
                Main.indexByClass(set);
            } else {
                Main.usage();
            }
        }
        catch (Throwable t) {
            rc = 1;
            t.printStackTrace();
        }
        finally {
            Main.close(null, rc);
        }
    }

    public static void indexFullDb() {
        Main.init();
        AllEntitiesPseudoLogLoader loader = new AllEntitiesPseudoLogLoader();
        loader.setQueryService(rawQuery);
        loader.setExcludes(excludes);
        loader.setClasses(factory.getAllClassMetadata().keySet());
        FullTextThread ftt = Main.createFullTextThread(loader);
        while (loader.more() > 0L) {
            ftt.run();
        }
    }

    public static void indexByClass(Set<String> set) {
        Main.init();
        AllEntitiesPseudoLogLoader loader = new AllEntitiesPseudoLogLoader();
        loader.setQueryService(rawQuery);
        loader.setClasses(set);
        FullTextThread ftt = Main.createFullTextThread(loader);
        while (loader.more() > 0L) {
            ftt.run();
        }
    }

    public static void indexAllEvents() {
        Main.init();
        AllEventsLogLoader loader = new AllEventsLogLoader();
        loader.setExcludes(excludes);
        loader.setQueryService(rawQuery);
        FullTextThread ftt = Main.createFullTextThread(loader);
        while (loader.more() > 0L) {
            ftt.run();
        }
    }

    public static void reset(String[] args) {
        Main.init();
        long oldValue = -1L;
        long newValue = 0L;
        if (args == null || args.length != 2) {
            System.out.println("Using 0 as reset target");
        } else {
            newValue = Long.valueOf(args[1]);
        }
        oldValue = loader.getCurrentId();
        loader.setCurrentId(newValue);
        System.out.println("=================================================");
        System.out.println(String.format("Value reset to %s. Was %s", newValue, oldValue));
        System.out.println("=================================================");
    }

    public static void foreground(boolean dryrun, String[] args) {
        Main.init();
        FullTextThread ftt = Main.createFullTextThread(loader, dryrun);
        long loops = 0L;
        long current = Main.current(loader);
        while (true) {
            ++loops;
            ftt.run();
            long newCurrent = Main.current(loader);
            if (newCurrent == current) break;
            current = newCurrent;
        }
        System.out.println("=================================================");
        System.out.println(String.format("Done in %s loops. Now at: %s", loops, current));
        System.out.println("=================================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void standalone(String[] args) {
        Communicator ic = Util.initialize(args);
        ObjectAdapter oa = ic.createObjectAdapter("IndexerAdapter");
        oa.activate();
        String cron = ic.getProperties().getProperty("omero.search.cron");
        if (cron == null || cron.length() == 0) {
            System.out.println("Using default cron value.");
        } else {
            System.setProperty("omero.search.cron", cron);
        }
        try {
            Main.init();
        }
        finally {
            ic.waitForShutdown();
        }
    }

    private static long current(final PersistentEventLogLoader loader) {
        Principal p = new Principal(uuid);
        return (Long)executor.execute(p, new Executor.SimpleWork((Object)loader, "more", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return loader.getCurrentId();
            }
        });
    }
}

