/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.Serializable;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.meta.EventLog;
import ome.services.eventlogs.EventLogFailure;
import ome.services.eventlogs.EventLogLoader;
import ome.services.eventlogs.PersistentEventLogLoader;
import ome.services.fulltext.ParserSession;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.ServiceFactory;
import ome.system.metrics.Histogram;
import ome.system.metrics.Metrics;
import ome.system.metrics.NullMetrics;
import ome.system.metrics.Timer;
import ome.tools.hibernate.QueryBuilder;
import ome.util.SqlAction;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
public class FullTextIndexer
extends Executor.SimpleWork
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FullTextIndexer.class);
    public static final int DEFAULT_REPORTING_LOOPS = 100;
    protected final EventLogLoader loader;
    protected final ParserSession parserSession;
    protected final Timer batchTimer;
    protected final Histogram completeSlow;
    protected final Histogram completeFast;
    protected int reps = 5;
    protected long batch;
    protected int reportingLoops = 100;
    protected boolean dryRun = false;
    protected OmeroContext context = null;

    public void setRepetitions(int reps) {
        this.reps = reps;
    }

    public void setReportingLoops(int loops) {
        this.reportingLoops = loops;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.context = (OmeroContext)ctx;
    }

    public FullTextIndexer(EventLogLoader ll) {
        this(ll, new NullMetrics());
    }

    public FullTextIndexer(EventLogLoader ll, Metrics metrics) {
        super((Object)"FullTextIndexer", "index", new Object[0]);
        this.loader = ll;
        this.parserSession = new ParserSession();
        this.batchTimer = metrics.timer(this, "batch");
        this.completeSlow = metrics.histogram(this, "percentCompleteSlow");
        this.completeFast = metrics.histogram(this, "percentCompleteFast");
    }

    @Override
    public synchronized void setSqlAction(SqlAction sql) {
        if (this.getSqlAction() == null) {
            super.setSqlAction(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false, isolation=Isolation.SERIALIZABLE)
    public Object doWork(Session session, ServiceFactory sf) {
        int count = 1;
        int perbatch = 0;
        long start = System.currentTimeMillis();
        Timer.Context timer = null;
        do {
            ++this.batch;
            timer = this.batchTimer.time();
            try {
                this.getSqlAction().deferConstraints();
                FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
                fullTextSession.setFlushMode(FlushMode.MANUAL);
                fullTextSession.setCacheMode(CacheMode.IGNORE);
                perbatch = this.doIndexingWithWorldRead(sf, fullTextSession);
            }
            finally {
                timer.stop();
                ++count;
            }
        } while (this.doMore(count));
        if (perbatch == 0) {
            log.debug("No objects indexed");
        } else {
            long elapsed = System.currentTimeMillis() - start;
            if (this.loader instanceof PersistentEventLogLoader) {
                long currId = ((PersistentEventLogLoader)this.loader).getCurrentId();
                long lastId = this.loader.lastEventLog().getId();
                String which = "~";
                double perc = 0.0;
                if (this.batchTimer.getCount() % (long)this.reportingLoops == 0L) {
                    which = "";
                    perc = this.getSqlAction().getEventLogPercent(((PersistentEventLogLoader)this.loader).getKey());
                    this.completeSlow.update((int)perc);
                } else {
                    perc = 100.0 * (double)currId / (double)lastId;
                    this.completeFast.update((int)perc);
                }
                log.info(String.format("INDEXED %4s objects in batch#%-6s [%7d ms.]  %s%2d%% done (%d of %d)", perbatch, this.batch, elapsed, which, (int)perc, currId, lastId));
            } else {
                log.info(String.format("INDEXED %4s objects in batch#%-6s [%7d ms.]", perbatch, this.batch, elapsed));
            }
        }
        return null;
    }

    private int doIndexingWithWorldRead(ServiceFactory sf, FullTextSession session) {
        int rc = this.doIndexing(session);
        return rc;
    }

    public int doIndexing(FullTextSession session) {
        int count = 0;
        for (EventLog eventLog : this.loader) {
            if (this.dryRun) continue;
            if (eventLog != null) {
                this.handleEventLog(session, eventLog);
                ++count;
            }
            session.flush();
            this.parserSession.closeParsedFiles();
        }
        return count;
    }

    protected void handleEventLog(FullTextSession session, EventLog eventLog) {
        String act = eventLog.getAction();
        Class type = this.asClassOrNull(eventLog.getEntityType());
        if (type != null) {
            long id = eventLog.getEntityId();
            Action action = null;
            if ("DELETE".equals(act)) {
                action = new Purge(type, id);
            } else if ("REINDEX".equals(act) || "UPDATE".equals(act) || "INSERT".equals(act)) {
                IObject obj = this.get((Session)session, type, id);
                if (obj == null) {
                    log.debug(String.format("Null returned! Purging since cannot index %s:Id_%s for %s", type.getName(), id, eventLog));
                    action = new Purge(type, id);
                } else {
                    action = new Index(obj);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Unknown action type: " + act);
            }
            if (action != null) {
                try {
                    ((Action)action).go(session);
                }
                catch (Exception e) {
                    try {
                        this.context.publishMessage(new EventLogFailure(this.loader, eventLog, e));
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Throwable e1) {
                        throw new RuntimeException(e1);
                    }
                }
                ((Action)action).log(log);
            }
        }
    }

    public boolean doMore(int count) {
        if (count < this.reps && this.loader.more() > (long)(this.loader.getBatchSize() * 100)) {
            log.info(String.format("Suggesting round %s of indexing to reduce backlog of %s:", count, this.loader.more()));
            return true;
        }
        return false;
    }

    protected Class asClassOrNull(String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            log.warn("Unknown entity type found in database: " + str);
            return null;
        }
    }

    protected IObject get(Session session, Class type, long id) {
        QueryBuilder qb = new QueryBuilder();
        qb.select("this").from(type.getName(), "this");
        if (IAnnotated.class.isAssignableFrom(type)) {
            qb.join("this.annotationLinks", "l1", true, true);
            qb.join("l1.child", "a1", true, true);
            qb.join("a1.annotationLinks", "l2", true, true);
            qb.join("l2.child", "a2", true, true);
        }
        if (!IGlobal.class.isAssignableFrom(type)) {
            if (IMutable.class.isAssignableFrom(type)) {
                qb.join("this.details.updateEvent", "update", false, true);
            }
            qb.join("this.details.creationEvent", "create", false, true);
            qb.join("this.details.owner", "owner", false, true);
            qb.join("this.details.group", "group", false, true);
        }
        qb.where().and("this.id = :id");
        qb.param("id", (Object)id);
        return (IObject)qb.query(session).uniqueResult();
    }

    class Index
    extends Action {
        Index(IObject obj) {
            this.obj = obj;
        }

        @Override
        void go(FullTextSession session) {
            session.index((Object)this.obj);
            session.flushToIndexes();
        }

        @Override
        void log(Logger log) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Indexed: %s", this.obj));
            }
        }
    }

    class Purge
    extends Action {
        Purge(Class type, long id) {
            this.type = type;
            this.id = id;
        }

        @Override
        void go(FullTextSession session) {
            session.purge(this.type, (Serializable)Long.valueOf(this.id));
            session.flushToIndexes();
        }

        @Override
        void log(Logger log) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Purged: %s:Id_%d", this.type, this.id));
            }
        }
    }

    abstract class Action {
        Class type;
        long id;
        IObject obj;

        Action() {
        }

        abstract void go(FullTextSession var1);

        abstract void log(Logger var1);
    }
}

