/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.io.nio.OriginalFilesService;
import ome.model.IAnnotated;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.FileAnnotation;
import ome.model.annotations.MapAnnotation;
import ome.model.annotations.TagAnnotation;
import ome.model.annotations.TermAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.model.containers.Folder;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.internal.Details;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.roi.Roi;
import ome.services.fulltext.BridgeHelper;
import ome.services.fulltext.FileParser;
import ome.services.fulltext.SimpleLuceneOptions;
import ome.util.Utils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.builtin.DateBridge;

@Deprecated
public class FullTextBridge
extends BridgeHelper {
    protected final OriginalFilesService files;
    protected final Map<String, FileParser> parsers;
    protected final Class<FieldBridge>[] classes;

    public FullTextBridge() {
        this(null, null);
    }

    public FullTextBridge(OriginalFilesService files, Map<String, FileParser> parsers) {
        this(files, parsers, new Class[0]);
    }

    public FullTextBridge(OriginalFilesService files, Map<String, FileParser> parsers, Class<FieldBridge>[] bridgeClasses) {
        this.files = files;
        this.parsers = parsers;
        this.classes = bridgeClasses == null ? new Class[]{} : bridgeClasses;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions opts) {
        IObject object = (IObject)value;
        String cls = Utils.trueClass(object.getClass()).getName();
        this.add(document, null, cls, opts);
        this.set_file(name, object, document, opts);
        this.set_annotations(name, object, document, opts);
        this.set_details(name, object, document, opts);
        this.set_folders(name, object, document, opts);
        this.set_custom(name, object, document, opts);
    }

    public void set_file(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof OriginalFile) {
            OriginalFile file2 = (OriginalFile)object;
            this.addContents(document, "file.contents", file2, this.files, this.parsers, opts);
        }
    }

    public void set_annotations(String name, IObject object, Document document, LuceneOptions opts) {
        ILink link;
        if (object instanceof ILink && (link = (ILink)object).getChild() instanceof Annotation) {
            this.reindex(link.getParent());
        }
        if (object instanceof IAnnotated) {
            IAnnotated annotated = (IAnnotated)object;
            List<Annotation> list = annotated.linkedAnnotationList();
            for (Annotation annotation : list) {
                String at = this.annotationTypeString(annotation);
                this.add(document, "annotation.type", at, opts);
                if (annotation.getName() != null) {
                    this.add(document, "annotation.name", annotation.getName(), opts);
                }
                if (annotation.getNs() != null) {
                    this.add(document, "annotation.ns", annotation.getNs(), opts);
                }
                if (annotation instanceof TermAnnotation) {
                    TermAnnotation term = (TermAnnotation)annotation;
                    String termValue = term.getTermValue();
                    termValue = termValue == null ? "" : termValue;
                    this.add(document, "term", termValue, opts);
                    continue;
                }
                if (annotation instanceof TextAnnotation) {
                    TextAnnotation text = (TextAnnotation)annotation;
                    String textValue = text.getTextValue();
                    textValue = textValue == null ? "" : textValue;
                    this.add(document, "annotation", textValue, opts);
                    if (!(annotation instanceof TagAnnotation)) continue;
                    this.add(document, "tag", textValue, opts);
                    List<Annotation> list2 = annotation.linkedAnnotationList();
                    for (Annotation annotation2 : list2) {
                        if (!(annotation2 instanceof TextAnnotation)) continue;
                        TextAnnotation text2 = (TextAnnotation)annotation2;
                        String textValue2 = text2.getTextValue();
                        textValue2 = textValue2 == null ? "" : textValue2;
                        this.add(document, "annotation", textValue2, opts);
                    }
                    continue;
                }
                if (annotation instanceof FileAnnotation) {
                    FileAnnotation fileAnnotation = (FileAnnotation)annotation;
                    this.handleFileAnnotation(document, opts, fileAnnotation);
                    continue;
                }
                if (!(annotation instanceof MapAnnotation)) continue;
                MapAnnotation mapAnnotation = (MapAnnotation)annotation;
                this.handleMapAnnotation(document, opts, mapAnnotation);
            }
        }
        if (object instanceof FileAnnotation) {
            FileAnnotation fileAnnotation = (FileAnnotation)object;
            this.handleFileAnnotation(document, opts, fileAnnotation);
        } else if (object instanceof MapAnnotation) {
            MapAnnotation mapAnnotation = (MapAnnotation)object;
            this.handleMapAnnotation(document, opts, mapAnnotation);
        }
    }

    public void set_details(String name, IObject object, Document document, LuceneOptions opts) {
        SimpleLuceneOptions stored = new SimpleLuceneOptions(opts, Field.Store.YES);
        SimpleLuceneOptions storedNotAnalyzed = new SimpleLuceneOptions(opts, Field.Index.NOT_ANALYZED, Field.Store.YES);
        Details details = object.getDetails();
        if (details != null) {
            Permissions perms;
            Event updateEvent;
            Event creationEvent;
            ExperimenterGroup g;
            Experimenter e = details.getOwner();
            if (e != null && e.isLoaded()) {
                String omename = e.getOmeName();
                String firstName = e.getFirstName();
                String lastName = e.getLastName();
                this.add(document, "details.owner.omeName", omename, stored);
                this.add(document, "details.owner.firstName", firstName, opts);
                this.add(document, "details.owner.lastName", lastName, opts);
            }
            if ((g = details.getGroup()) != null && g.isLoaded()) {
                String groupName = g.getName();
                this.add(document, "details.group.name", groupName, stored);
            }
            if ((creationEvent = details.getCreationEvent()) != null) {
                this.add(document, "details.creationEvent.id", creationEvent.getId().toString(), storedNotAnalyzed);
                if (creationEvent.isLoaded()) {
                    String creation = DateBridge.DATE_SECOND.objectToString((Object)creationEvent.getTime());
                    this.add(document, "details.creationEvent.time", creation, storedNotAnalyzed);
                }
            }
            if ((updateEvent = details.getUpdateEvent()) != null) {
                this.add(document, "details.updateEvent.id", updateEvent.getId().toString(), storedNotAnalyzed);
                if (updateEvent.isLoaded()) {
                    String update = DateBridge.DATE_SECOND.objectToString((Object)updateEvent.getTime());
                    this.add(document, "details.updateEvent.time", update, storedNotAnalyzed);
                }
            }
            if ((perms = details.getPermissions()) != null) {
                this.add(document, "details.permissions", perms.toString(), stored);
            }
        }
    }

    public void set_folders(String name, IObject object, Document document, LuceneOptions opts) {
        if (object instanceof Image) {
            Image image = (Image)object;
            Iterator<Roi> roiIterator = image.iterateRois();
            while (roiIterator.hasNext()) {
                Roi roi = roiIterator.next();
                Iterator<Folder> folderIterator = roi.linkedFolderIterator();
                while (folderIterator.hasNext()) {
                    Folder folder = folderIterator.next();
                    this.add(document, "roi.folder.name", folder.getName(), opts);
                }
            }
        }
    }

    public void set_custom(String name, IObject object, Document document, LuceneOptions opts) {
        for (Class<FieldBridge> bridgeClass : this.classes) {
            if (bridgeClass == null) continue;
            FieldBridge bridge = null;
            try {
                bridge = bridgeClass.newInstance();
                if (bridge instanceof BridgeHelper) {
                    BridgeHelper helper = (BridgeHelper)bridge;
                    helper.setApplicationEventPublisher(this.publisher);
                }
                bridge.set(name, (Object)object, document, opts);
            }
            catch (Exception e) {
                String msg = String.format("Error calling set on custom bridge type:%s; instance:%s", bridgeClass, bridge);
                this.logger().error(msg, e);
            }
        }
    }

    private void handleFileAnnotation(Document document, LuceneOptions opts, FileAnnotation fileAnnotation) {
        OriginalFile file2 = fileAnnotation.getFile();
        if (file2 != null) {
            this.add(document, "file.name", file2.getName(), opts);
            this.add(document, "file.path", file2.getPath(), opts);
            if (file2.getHasher() != null) {
                this.add(document, "file.hasher", file2.getHasher().getValue(), opts);
            }
            if (file2.getHash() != null) {
                this.add(document, "file.hash", file2.getHash(), opts);
            }
            if (file2.getMimetype() != null) {
                this.add(document, "file.format", file2.getMimetype(), opts);
                this.add(document, "file.mimetype", file2.getMimetype(), opts);
            }
            this.addContents(document, "file.contents", file2, this.files, this.parsers, opts);
        }
    }

    private void handleMapAnnotation(Document document, LuceneOptions opts, MapAnnotation mapAnnotation) {
        List<NamedValue> nvs = mapAnnotation.getMapValue();
        if (nvs != null && nvs.size() > 0) {
            for (NamedValue nv : nvs) {
                if (nv == null) continue;
                this.add(document, nv.getName(), nv.getValue(), opts);
                this.add(document, "has_key", nv.getName(), opts);
                this.add(document, "annotation", nv.getValue(), opts);
                this.add(document, "annotation", nv.getName(), opts);
            }
        }
    }

    private String annotationTypeString(Annotation annotation) {
        Class<?> ac = Utils.trueClass(annotation.getClass());
        int dot = ac.getName().lastIndexOf(46);
        if (dot < 0) {
            dot = -1;
        }
        String at = ac.getName().substring(dot + 1, ac.getName().length());
        return at;
    }
}

