/*
 * Decompiled with CFR 0.152.
 */
package ome.services.eventlogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.api.IQuery;
import ome.model.IObject;
import ome.model.meta.EventLog;
import ome.parameters.Parameters;
import ome.services.eventlogs.EventBacklog;
import ome.services.messages.ReindexMessage;
import ome.tools.hibernate.QueryBuilder;
import ome.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class EventLogLoader
implements Iterator<EventLog>,
Iterable<EventLog>,
ApplicationListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_BATCH_SIZE = 100;
    protected int batchSize = 100;
    private int count = 0;
    private final EventBacklog backlog = new EventBacklog();
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private EventLog eventLog;
    protected List<String> excludes = Collections.emptyList();
    protected String query;
    protected IQuery queryService;

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = Collections.unmodifiableList(Arrays.asList(excludes));
        this.initQueryString();
    }

    private void initQueryString() {
        List<String> copy = this.excludes;
        QueryBuilder qb = new QueryBuilder();
        qb.select("el");
        qb.from("EventLog", "el");
        qb.where();
        qb.and("el.id > :id");
        if (copy != null) {
            for (String exclude : copy) {
                qb.and("el.entityType != '" + exclude + "'");
            }
        }
        qb.order("id", true);
        this.query = qb.queryString();
    }

    public void setQueryService(IQuery queryService) {
        this.queryService = queryService;
    }

    @Override
    public boolean hasNext() {
        boolean endBatch;
        if (this.stop.get()) {
            return false;
        }
        if (this.eventLog != null) {
            return true;
        }
        if (this.count == 0) {
            this.backlog.flipState();
        }
        if (this.count == this.batchSize) {
            this.count = 0;
            return false;
        }
        ++this.count;
        this.eventLog = this.backlog.removingOnly() ? this.backlog.remove() : this.query();
        boolean bl = endBatch = this.eventLog == null;
        if (endBatch) {
            this.count = 0;
        }
        return !endBatch;
    }

    @Override
    public EventLog next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        EventLog rv = this.eventLog;
        this.eventLog = null;
        return rv;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Cannot remove EventLogs");
    }

    public void rollback(EventLog el) {
        if (this.excludes.contains(el.getEntityType()) && this.log.isDebugEnabled()) {
            this.log.debug("Skipping rollback of " + el.getEntityType());
        }
        this.backlog.add(el);
    }

    protected abstract EventLog query();

    @Override
    public Iterator<EventLog> iterator() {
        return this;
    }

    public abstract long more();

    public final EventLog nextEventLog(long id) {
        if (this.query == null) {
            this.initQueryString();
        }
        Parameters params = new Parameters().page(0, 1).addId(id);
        return (EventLog)this.queryService.findByQuery(this.query, params);
    }

    public final EventLog lastEventLog() {
        return (EventLog)this.queryService.findByQuery("select el from EventLog el order by id desc", new Parameters().page(0, 1));
    }

    public boolean addEventLog(Class<? extends IObject> cls, long id) {
        if (this.excludes.contains(cls.getName()) && this.log.isDebugEnabled()) {
            this.log.debug("Skipping addition of " + cls.getName());
            return false;
        }
        EventLog el = new EventLog();
        el.setEntityId(id);
        el.setEntityType(cls.getName());
        el.setAction("INSERT");
        return this.backlog.add(el);
    }

    public void onApplicationEvent(ApplicationEvent arg0) {
        if (arg0 instanceof ReindexMessage) {
            ReindexMessage rm = (ReindexMessage)arg0;
            for (IObject obj : rm.objects) {
                Class<?> trueClass = Utils.trueClass(obj.getClass());
                this.addEventLog(trueClass, obj.getId());
            }
        }
    }

    public boolean isStopSet() {
        return this.stop.get();
    }

    public void setStop(boolean stop) {
        if (stop) {
            this.log.info("Shutting down EventLogLoader");
        } else {
            this.log.info("Restarting EventLogLoader");
        }
        this.stop.set(stop);
    }
}

