/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete.files;

import java.io.File;
import java.util.Set;
import ome.io.nio.AbstractFileSystemService;
import ome.services.delete.files.AbstractFileDeletions;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelsFileDeletions
extends AbstractFileDeletions {
    private static final Logger log = LoggerFactory.getLogger(PixelsFileDeletions.class);

    public PixelsFileDeletions(AbstractFileSystemService afs, Set<Long> deletedIds) {
        super(afs, deletedIds);
        for (Long id : deletedIds) {
            String filePath = afs.getPixelsPath(id);
            File file2 = new File(filePath);
            File pyrFile = new File(filePath + "_pyramid");
            File dir = file2.getParentFile();
            File lockFile = new File(dir, "." + id + "_pyramid" + ".pyr_lock");
            this.addLocalFile(file2, id);
            this.addLocalFile(pyrFile, id);
            this.addLocalFile(lockFile, id);
            WildcardFileFilter tmpFileFilter = new WildcardFileFilter("." + id + "_pyramid" + "*.tmp");
            File[] tmpFiles = dir.listFiles(tmpFileFilter);
            if (tmpFiles == null) continue;
            for (int i = 0; i < tmpFiles.length; ++i) {
                this.addLocalFile(tmpFiles[i], id);
            }
        }
    }
}

