/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete.files;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import ome.io.nio.AbstractFileSystemService;
import ome.services.delete.files.AbstractFileDeletions;
import ome.services.messages.DeleteLogMessage;
import ome.services.messages.DeleteLogsMessage;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalFileDeletions
extends AbstractFileDeletions {
    private static final Logger log = LoggerFactory.getLogger(OriginalFileDeletions.class);

    public OriginalFileDeletions(AbstractFileSystemService afs, Set<Long> deletedIds, OmeroContext ctx) {
        super(afs, deletedIds);
        ArrayList<Long> orderedIds = new ArrayList<Long>(deletedIds);
        DeleteLogsMessage dlms = new DeleteLogsMessage(this, orderedIds);
        try {
            ctx.publishMessage(dlms);
            for (DeleteLogMessage dlm : dlms.getMessages()) {
                if (dlm.count() != 0) continue;
                String filePath = afs.getFilesPath(dlm.getFileId());
                this.addLocalFile(new File(filePath), dlm.getFileId());
            }
        }
        catch (Throwable e) {
            log.warn("Error on DeleteLogMessage", e);
            for (Long id : orderedIds) {
                String filePath = afs.getFilesPath(id);
                File file2 = new File(filePath);
                this.fail(file2, id, null);
            }
        }
    }
}

