/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete.files;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.io.nio.AbstractFileSystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileDeletions {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileDeletions.class);
    protected final Set<Long> deletedIds;
    protected final AbstractFileSystemService afs;
    private Map<File, Long> localFiles = new HashMap<File, Long>();
    private Map<File, Long> failedFiles = new HashMap<File, Long>();
    private long bytesFailed = 0L;

    public AbstractFileDeletions(AbstractFileSystemService afs, Set<Long> deletedIds) {
        this.afs = afs;
        this.deletedIds = deletedIds;
    }

    public void fail(File file2, Long id, Long size) {
        this.failedFiles.put(file2, id);
        if (size != null) {
            this.bytesFailed += size.longValue();
        }
    }

    public void addLocalFile(File file2, long fileId) {
        this.localFiles.put(file2, fileId);
    }

    public int deleteLocal() {
        for (Map.Entry<File, Long> entry : this.localFiles.entrySet()) {
            File file2 = entry.getKey();
            Long id = entry.getValue();
            if (file2.exists()) {
                if (file2.delete()) {
                    log.debug("DELETED: " + file2.getAbsolutePath());
                    continue;
                }
                log.debug("Failed to delete " + file2.getAbsolutePath());
                this.fail(file2, id, file2.length());
                continue;
            }
            log.debug("File " + file2.getAbsolutePath() + " does not exist.");
        }
        return this.failedFiles.size();
    }

    public long getBytesFailed() {
        return this.bytesFailed;
    }

    public long[] getUndeletedFiles() {
        ArrayList<Long> copy = new ArrayList<Long>(this.failedFiles.values());
        long[] ids = new long[copy.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Long)copy.get(i);
        }
        return ids;
    }
}

