/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete;

import java.util.List;
import ome.api.local.LocalAdmin;
import ome.api.local.LocalQuery;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.services.delete.UnloadedCollector;

public class QueryConstraints
implements AdminAction {
    public static final String dsAllQuery = "select ds from Dataset ds join ds.imageLinks il  join il.child as img where img.id = :id";
    public static final String dsNotOwnQuery = "select ds from Dataset ds join ds.imageLinks il  join il.child as img where img.id = :id  and ds.details.owner.id != :owner";
    final LocalAdmin iAdmin;
    final LocalQuery iQuery;
    final long id;
    final boolean force;
    final UnloadedCollector rv;
    final Parameters p;

    public QueryConstraints(LocalAdmin iAdmin, LocalQuery iQuery, long id, boolean force) {
        this.iAdmin = iAdmin;
        this.iQuery = iQuery;
        this.id = id;
        this.force = force;
        this.p = new Parameters().addId(id);
        this.rv = new UnloadedCollector(iQuery, iAdmin, false);
    }

    @Override
    public void runAsAdmin() {
        String dsQuery;
        if (this.force) {
            dsQuery = dsNotOwnQuery;
            this.p.addLong("owner", this.iAdmin.getEventContext().getCurrentUserId());
        } else {
            dsQuery = dsAllQuery;
        }
        this.rv.addAll(this.iQuery.findAllByQuery(dsQuery, this.p));
    }

    public List<IObject> getResults() {
        return this.rv.list;
    }
}

