/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Ice.Current;
import Ice.Identity;
import Ice.UserException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import ome.model.core.OriginalFile;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.FindServiceFactoryMessage;
import ome.services.scripts.ScriptRepoHelper;
import ome.system.OmeroContext;
import ome.system.Roles;
import omero.ValidationException;
import omero.api.ServiceFactoryPrx;
import omero.grid.JobParams;
import omero.grid.ParamsHelper;
import omero.model.ExperimenterGroupI;
import omero.util.IceMapper;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ParamsCache
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ParamsCache.class);
    private final LoadingCache<Key, JobParams> cache;
    private final Registry reg;
    private final Roles roles;
    private final ScriptRepoHelper scripts;
    private OmeroContext ctx;

    public ParamsCache(Registry reg, Roles roles, ScriptRepoHelper scripts, String spec) {
        this.reg = reg;
        this.roles = roles;
        this.scripts = scripts;
        this.cache = CacheBuilder.from(spec).build(new CacheLoader<Key, JobParams>(){

            @Override
            public JobParams load(Key key) throws Exception {
                return ParamsCache.this.lookup(key);
            }
        });
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (OmeroContext)ctx;
    }

    public JobParams getParams(Long id, String sha1, Current curr) throws UserException {
        Slf4JStopWatch get = this.sw("get." + id);
        try {
            JobParams jobParams = this.cache.get(new Key(id, sha1, curr));
            return jobParams;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DynamicException) {
                JobParams jobParams = ((DynamicException)cause).params;
                return jobParams;
            }
            UserException ue = new IceMapper().handleException(cause, this.ctx);
            log.warn("Error on scripts cache lookup", ue);
            throw ue;
        }
        finally {
            get.stop();
        }
    }

    public void removeParams(Long id) {
        if (id == null) {
            return;
        }
        HashSet matching = new HashSet(this.cache.asMap().keySet());
        Iterator it = matching.iterator();
        while (it.hasNext()) {
            if (!id.equals(((Key)it.next()).id)) continue;
            it.remove();
        }
        this.cache.invalidateAll(matching);
    }

    public JobParams lookup(Key key) throws Exception {
        return this._load(key);
    }

    public void lookupAll() throws Exception {
        this._load(null);
    }

    private Slf4JStopWatch sw(String suffix) {
        return new Slf4JStopWatch("omero.scripts.cache." + suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobParams _load(Key key) throws Exception {
        Slf4JStopWatch load = this.sw(key == null ? "all" : Long.toString(key.id));
        Loader loader = null;
        try {
            if (key != null) {
                loader = new UserLoader(this.reg, this.ctx, key);
                JobParams params = loader.createParams(key);
                if (this.isDynamic(params)) {
                    throw new DynamicException(params);
                }
                JobParams jobParams = params;
                return jobParams;
            }
            loader = new RootLoader(this.reg, this.ctx, this.roles);
            Slf4JStopWatch list = this.sw("list");
            List<OriginalFile> files = this.scripts.loadAll(true);
            list.stop();
            for (OriginalFile file2 : files) {
                try {
                    Slf4JStopWatch single = this.sw(file2.getId().toString());
                    Key newkey = new Key(file2.getId(), file2.getHash());
                    JobParams params = loader.createParams(newkey);
                    if (!this.isDynamic(params)) {
                        this.cache.put(newkey, params);
                    }
                    single.stop();
                }
                catch (ValidationException ve) {
                    log.warn("Failed to load params for {}", (Object)file2.getId(), (Object)ve);
                }
                catch (Exception e) {
                    log.error("Failed to load params for {}", (Object)file2.getId(), (Object)e);
                }
            }
            log.info("New size of scripts cache: {} ({} ms.)", (Object)this.cache.size(), (Object)load.getElapsedTime());
            Iterator<OriginalFile> iterator = null;
            return iterator;
        }
        finally {
            load.stop();
            if (loader != null) {
                loader.close();
            }
        }
    }

    private boolean isDynamic(JobParams params) throws DynamicException {
        return params.namespaces != null && params.namespaces.contains("openmicroscopy.org/omero/scripts/job/dynamic");
    }

    private static class Key {
        final Long id;
        final String sha1;
        final Current curr;

        Key(Long id, String sha1) {
            this(id, sha1, null);
        }

        Key(Long id, String sha1, Current curr) {
            this.id = id;
            this.sha1 = sha1;
            this.curr = curr;
        }

        public int hashCode() {
            int prime = 113;
            int result = 1;
            result = 113 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 113 * result + (this.sha1 == null ? 0 : this.sha1.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.sha1 == null ? other.sha1 != null : !this.sha1.equals(other.sha1));
        }
    }

    private static class UserLoader
    extends Loader {
        final Key key;

        UserLoader(Registry reg, OmeroContext ctx, Key key) throws Exception {
            super(reg, ctx);
            this.key = key;
        }

        @Override
        ServiceFactoryI getFactory() throws Exception {
            return this.lookupFactory(new FindServiceFactoryMessage((Object)this, this.key.curr));
        }

        @Override
        Current getCurrent() {
            return this.key.curr;
        }

        @Override
        void close() {
        }
    }

    private static class RootLoader
    extends Loader {
        final String root;
        final Long gid;
        Current curr;

        RootLoader(Registry reg, OmeroContext ctx, Roles roles) throws Exception {
            this(reg, ctx, roles, null);
        }

        RootLoader(Registry reg, OmeroContext ctx, Roles roles, Long gid) throws Exception {
            super(reg, ctx);
            this.root = roles.getRootName();
            this.gid = gid;
        }

        @Override
        ServiceFactoryI getFactory() throws Exception {
            ServiceFactoryPrx prx = this.reg.getInternalServiceFactory(this.root, "unused", 3, 1, UUID.randomUUID().toString());
            Identity id = prx.ice_getIdentity();
            ServiceFactoryI sf = this.lookupFactory(new FindServiceFactoryMessage((Object)this, id));
            this.curr = sf.newCurrent(id, "loadScripts");
            if (this.gid != null) {
                sf.setSecurityContext(new ExperimenterGroupI(this.gid, false), this.curr);
            }
            return sf;
        }

        @Override
        Current getCurrent() {
            return this.curr;
        }

        @Override
        void close() {
            if (this.sf != null) {
                this.sf.destroy(null);
            }
        }
    }

    private static abstract class Loader {
        final Registry reg;
        final OmeroContext ctx;
        ServiceFactoryI sf;
        ParamsHelper helper;

        Loader(Registry reg, OmeroContext ctx) throws Exception {
            this.reg = reg;
            this.ctx = ctx;
        }

        abstract ServiceFactoryI getFactory() throws Exception;

        ServiceFactoryI lookupFactory(FindServiceFactoryMessage msg) throws UserException {
            try {
                this.ctx.publishMessage(msg);
                return msg.getServiceFactory();
            }
            catch (Throwable t) {
                throw new IceMapper().handleException(t, this.ctx);
            }
        }

        ParamsHelper getHelper() throws Exception {
            if (this.helper != null) {
                return this.helper;
            }
            if (this.sf == null) {
                this.sf = this.getFactory();
            }
            ParamsHelper.Acquirer acq = (ParamsHelper.Acquirer)this.sf.getServant(this.sf.sharedResources(this.getCurrent()).ice_getIdentity());
            this.helper = new ParamsHelper(acq, this.sf.getExecutor(), this.sf.getPrincipal());
            return this.helper;
        }

        JobParams createParams(Key key) throws Exception {
            ParamsHelper helper = this.getHelper();
            Current curr = this.getCurrent();
            return helper.generateScriptParams(key.id, false, curr);
        }

        abstract Current getCurrent();

        abstract void close();
    }

    private static class DynamicException
    extends Exception {
        private final JobParams params;

        DynamicException(JobParams params) {
            this.params = params;
        }
    }
}

