/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import ome.util.checksum.ChecksumType;
import omero.model.ChecksumAlgorithm;
import omero.model.ChecksumAlgorithmI;
import omero.rtypes;

public class ChecksumAlgorithmMapper {
    public static Function<ChecksumAlgorithm, String> CHECKSUM_ALGORITHM_NAMER = new Function<ChecksumAlgorithm, String>(){

        @Override
        public String apply(ChecksumAlgorithm checksumAlgorithm) {
            return checksumAlgorithm.getValue().getValue();
        }
    };
    private static final ImmutableMap<String, ChecksumType> checksumAlgorithms = ImmutableMap.builder().put("Adler-32", ChecksumType.ADLER32).put("CRC-32", ChecksumType.CRC32).put("MD5-128", ChecksumType.MD5).put("Murmur3-32", ChecksumType.MURMUR32).put("Murmur3-128", ChecksumType.MURMUR128).put("SHA1-160", ChecksumType.SHA1).put("File-Size-64", ChecksumType.FILE_SIZE).build();

    private static ChecksumAlgorithm getChecksumAlgorithmWithValue(String name) {
        ChecksumAlgorithmI algorithm = new ChecksumAlgorithmI();
        algorithm.setValue(rtypes.rstring(name));
        return algorithm;
    }

    public static ChecksumType getChecksumType(ome.model.enums.ChecksumAlgorithm algorithm) {
        return checksumAlgorithms.get(algorithm.getValue());
    }

    public static ChecksumType getChecksumType(ChecksumAlgorithm algorithm) {
        return checksumAlgorithms.get(algorithm.getValue().getValue());
    }

    public static ChecksumAlgorithm getChecksumAlgorithm(String name) {
        if (!checksumAlgorithms.containsKey(name)) {
            throw new IllegalArgumentException(name + " is not recognized as a value of the enumeration " + ome.model.enums.ChecksumAlgorithm.class.getCanonicalName());
        }
        return ChecksumAlgorithmMapper.getChecksumAlgorithmWithValue(name);
    }

    public static List<ChecksumAlgorithm> getAllChecksumAlgorithms() {
        ArrayList<ChecksumAlgorithm> algorithms = new ArrayList<ChecksumAlgorithm>(checksumAlgorithms.size());
        for (String name : checksumAlgorithms.keySet()) {
            algorithms.add(ChecksumAlgorithmMapper.getChecksumAlgorithmWithValue(name));
        }
        return algorithms;
    }
}

