/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ome.services.blitz.fire.TopicManager;
import ome.services.util.Executor;
import ome.tools.spring.OnContextRefreshedEventListener;
import ome.util.SqlAction;
import omero.grid.ProcessorCallbackPrx;
import omero.grid.ProcessorCallbackPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.grid._ProcessorCallbackDisp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.transaction.annotation.Transactional;

public class CheckAllJobs
extends OnContextRefreshedEventListener {
    private static final Logger log = LoggerFactory.getLogger(CheckAllJobs.class);
    private final Executor ex;
    private final ObjectAdapter oa;
    private final TopicManager tm;
    private final Identity id;
    private final long waitMs;

    public CheckAllJobs(Executor ex, ObjectAdapter oa, TopicManager tm) {
        this(ex, oa, tm, 10000L);
    }

    public CheckAllJobs(Executor ex, ObjectAdapter oa, TopicManager tm, long waitMs) {
        this.waitMs = waitMs;
        this.ex = ex;
        this.oa = oa;
        this.tm = tm;
        this.id = new Identity(UUID.randomUUID().toString(), "ProcessorCallback");
    }

    @Override
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        this.run();
    }

    public void run() {
        Callback cb = new Callback();
        ObjectPrx prx = this.oa.add(cb, this.id);
        ProcessorCallbackPrx cbPrx = ProcessorCallbackPrxHelper.uncheckedCast(prx);
        this.tm.onApplicationEvent(new TopicManager.TopicMessage(this, "/internal/ProcessorAccept", new ProcessorPrxHelper(), "requestRunning", cbPrx));
        new Thread(){

            @Override
            public void run() {
                log.info("Waiting " + CheckAllJobs.this.waitMs / 1000L + " secs. for callbacks");
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + CheckAllJobs.this.waitMs) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CheckAllJobs.this.synchronizeJobs();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeJobs() {
        Callback cb = (Callback)this.oa.find(this.id);
        final ArrayList ids = new ArrayList();
        List list = cb.openJobs;
        synchronized (list) {
            ids.addAll(cb.openJobs);
        }
        try {
            this.ex.executeSql(new Executor.SimpleSqlWork(this, "synchronizeJobs", new Object[0]){

                @Override
                @Transactional(readOnly=false)
                public Object doWork(SqlAction sql) {
                    int count = sql.synchronizeJobs(ids);
                    if (count > 0) {
                        log.warn("Forcibly closed " + count + " abandoned job(s).");
                    }
                    return null;
                }
            });
        }
        finally {
            this.oa.remove(this.id);
        }
    }

    private class Callback
    extends _ProcessorCallbackDisp {
        private final List<Long> openJobs = new ArrayList<Long>();

        private Callback() {
        }

        @Override
        public void isAccepted(boolean accepted, String sessionUuid, String proxyConn, Current __current) {
            log.error("isAccepted should not have been called");
        }

        @Override
        public void isProxyAccepted(boolean accepted, String sessionUuid, ProcessorPrx procProxy, Current __current) {
            log.error("isProxyAccepted should not have been called");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void responseRunning(List<Long> jobIds, Current __current) {
            List<Long> list = this.openJobs;
            synchronized (list) {
                if (jobIds != null) {
                    log.info("Received " + jobIds.size() + " job(s)");
                    this.openJobs.addAll(jobIds);
                } else {
                    log.warn("Null jobIds list sent.");
                }
            }
        }
    }
}

