/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import Glacier2.PermissionsVerifier;
import Ice.Communicator;
import Ice.Identity;
import Ice.InitializationData;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Util;
import java.net.URL;
import ome.security.SecuritySystem;
import ome.services.blitz.fire.PermissionsVerifierI;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.fire.Ring;
import ome.services.blitz.fire.SessionManagerI;
import ome.services.blitz.fire.TopicManager;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ResourceUtils;

public class BlitzConfiguration {
    private static final String CONFIG_KEY = "--Ice.Config=";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Ring blitzRing;
    private final Communicator communicator;
    private final ObjectAdapter blitzAdapter;
    private final SessionManagerI blitzManager;
    private final PermissionsVerifier blitzVerifier;
    private final Registry registry;
    private final TopicManager topicManager;
    private final InitializationData id;
    private final ObjectPrx managerDirectProxy;
    private final int servantsPerSession;

    public BlitzConfiguration(Ring ring, SessionManager sessionManager, SecuritySystem securitySystem, Executor executor, int servantsPerSession) throws RuntimeException {
        this(BlitzConfiguration.createId(), ring, sessionManager, securitySystem, executor, servantsPerSession);
    }

    public BlitzConfiguration(InitializationData id, Ring ring, SessionManager sessionManager, SecuritySystem securitySystem, Executor executor, int servantsPerSession) throws RuntimeException {
        this.logger.info("Initializing Ice.Communicator");
        this.id = id;
        this.blitzRing = ring;
        this.communicator = this.createCommunicator();
        this.servantsPerSession = servantsPerSession;
        if (this.communicator == null) {
            throw new RuntimeException("No communicator cannot continue.");
        }
        try {
            this.registry = new Registry.Impl(this.communicator);
            this.topicManager = new TopicManager.Impl(this.communicator);
            this.blitzAdapter = this.createAdapter();
            this.blitzManager = this.createAndRegisterManager(sessionManager, securitySystem, executor);
            this.blitzVerifier = this.createAndRegisterVerifier(sessionManager, executor);
            this.managerDirectProxy = this.blitzAdapter.createDirectProxy(this.managerId());
            this.blitzAdapter.activate();
            this.blitzRing.setRegistry(this.registry);
            this.blitzRing.init(this.blitzAdapter, this.communicator.proxyToString(this.getDirectProxy()));
        }
        catch (RuntimeException e) {
            try {
                this.destroy();
            }
            catch (Exception e2) {
                this.logger.error("Error destroying configuration after initialization exception. Throwing initialization exception", e2);
            }
            throw e;
        }
    }

    protected final void throwIfInitialized(Object instance) {
        if (instance != null) {
            throw new IllegalStateException("Configuration has already taken place.");
        }
    }

    protected Communicator createCommunicator() {
        this.throwIfInitialized(this.communicator);
        String ICE_CONFIG = System.getProperty("ICE_CONFIG");
        if (ICE_CONFIG != null) {
            this.id.properties.load(ICE_CONFIG);
        }
        Communicator ic = Util.initialize(this.id);
        return ic;
    }

    protected Communicator createCommunicator(String configFile, String[] arguments) {
        this.throwIfInitialized(this.communicator);
        if (configFile == null) {
            throw new IllegalArgumentException("No config file given.");
        }
        configFile = this.resolveConfigFile(configFile);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Reading config file:" + configFile);
        }
        Communicator ic = null;
        InitializationData id = new InitializationData();
        if (arguments == null) {
            id.properties = Util.createProperties(new String[0]);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                String s = arguments[i];
                if (s == null || !s.startsWith(CONFIG_KEY)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Overriding args setting %s with %s", s, configFile));
                }
                arguments[i] = CONFIG_KEY + configFile;
            }
            id.properties = Util.createProperties(arguments);
        }
        ic = Util.initialize(id);
        return ic;
    }

    protected String resolveConfigFile(String configFile) {
        try {
            URL file2 = ResourceUtils.getURL(configFile);
            if (ResourceUtils.isJarURL(file2)) {
                throw new RuntimeException(configFile + " is in a jar: " + file2);
            }
            configFile = file2.getPath();
        }
        catch (Exception e) {
            throw new RuntimeException("Error resolving config file: " + configFile, e);
        }
        return configFile;
    }

    protected ObjectAdapter createAdapter() {
        ObjectAdapter adapter;
        this.throwIfInitialized(this.blitzAdapter);
        try {
            adapter = this.communicator.createObjectAdapter("BlitzAdapter");
        }
        catch (Exception e) {
            this.logger.error("Fatal error creating adapter. See the troubleshooting page", e);
            throw new FatalBeanException("Could not find Ice config for object adapter [ BlitzAdapter ]");
        }
        return adapter;
    }

    protected SessionManagerI createAndRegisterManager(SessionManager sessionManager, SecuritySystem securitySystem, Executor executor) {
        this.throwIfInitialized(this.blitzManager);
        SessionManagerI manager = new SessionManagerI(this.blitzRing, this.blitzAdapter, securitySystem, sessionManager, executor, this.topicManager, this.registry, this.servantsPerSession);
        Identity id = this.managerId();
        ObjectPrx prx = this.blitzAdapter.add(manager, id);
        return manager;
    }

    protected PermissionsVerifier createAndRegisterVerifier(SessionManager sessionManager, Executor executor) {
        this.throwIfInitialized(this.blitzVerifier);
        PermissionsVerifierI verifier = new PermissionsVerifierI(this.blitzRing, sessionManager, executor, this.blitzRing.uuid);
        this.blitzAdapter.add(verifier, Util.stringToIdentity("BlitzVerifier"));
        return verifier;
    }

    public void destroy() {
        if (this.blitzRing != null) {
            this.blitzRing.destroy();
        }
        this.logger.debug(String.format("Destroying Ice.Communicator (%s)", this.communicator));
        this.logger.info("Shutting down Ice.Communicator");
        if (this.blitzAdapter != null) {
            this.logger.debug(String.format("Deactivating BlitzAdapter (%s)", this.blitzAdapter));
            this.blitzAdapter.deactivate();
        }
        this.communicator.destroy();
    }

    public Ring getRing() {
        if (this.blitzRing == null) {
            throw new IllegalStateException("Ring is null");
        }
        return this.blitzRing;
    }

    public Communicator getCommunicator() {
        if (this.communicator == null) {
            throw new IllegalStateException("Communicator is null");
        }
        return this.communicator;
    }

    public ObjectAdapter getBlitzAdapter() {
        if (this.blitzAdapter == null) {
            throw new IllegalStateException("Adapter is null");
        }
        return this.blitzAdapter;
    }

    public Glacier2.SessionManager getBlitzManager() {
        if (this.blitzManager == null) {
            throw new IllegalStateException("Manager is null");
        }
        return this.blitzManager;
    }

    public PermissionsVerifier getBlitzVerifier() {
        if (this.blitzVerifier == null) {
            throw new IllegalStateException("Verifier is null");
        }
        return this.blitzVerifier;
    }

    public Registry getRegistry() {
        if (this.registry == null) {
            throw new IllegalStateException("Registry is null");
        }
        return this.registry;
    }

    public TopicManager getTopicManager() {
        if (this.topicManager == null) {
            throw new IllegalStateException("TopicManager is null");
        }
        return this.topicManager;
    }

    public ObjectPrx getDirectProxy() {
        if (this.managerDirectProxy == null) {
            throw new IllegalStateException("Direct proxy is null");
        }
        return this.managerDirectProxy;
    }

    private static InitializationData createId() {
        InitializationData iData = new InitializationData();
        iData.properties = Util.createProperties();
        return iData;
    }

    private Identity managerId() {
        Identity id = Util.stringToIdentity("BlitzManager");
        return id;
    }
}

