/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;

public class FilePathRestrictions {
    private static final ImmutableSet<Integer> controlCodePoints;
    private static final Predicate<Integer> isNotControlCodePoint;
    public final ImmutableSetMultimap<Integer, Integer> transformationMatrix;
    public final ImmutableSet<String> unsafePrefixes;
    public final ImmutableSet<String> unsafeSuffixes;
    public final ImmutableSet<String> unsafeNames;
    public final ImmutableSet<Character> safeCharacters;
    public final char safeCharacter;
    public final ImmutableMap<Integer, Integer> transformationMap;

    private static FilePathRestrictions includeControlTransformations(FilePathRestrictions rules) {
        HashSet<Character> safeCharacters = new HashSet<Character>(rules.safeCharacters.size());
        HashSet<Integer> safeCodePoints = new HashSet<Integer>(rules.safeCharacters.size());
        for (Character safeCharacter : rules.safeCharacters) {
            int safeCodePoint = FilePathRestrictionInstance.getCodePoint(safeCharacter.charValue());
            if (controlCodePoints.contains(safeCodePoint)) continue;
            safeCharacters.add(safeCharacter);
            safeCodePoints.add(safeCodePoint);
        }
        HashMultimap<Integer, Integer> newTransformationMatrix = HashMultimap.create(Multimaps.filterValues(rules.transformationMatrix, isNotControlCodePoint));
        Iterator iterator = controlCodePoints.iterator();
        while (iterator.hasNext()) {
            int controlCodePoint = (Integer)iterator.next();
            if (newTransformationMatrix.containsKey(controlCodePoint)) continue;
            if (rules.transformationMatrix.containsKey(controlCodePoint)) {
                throw new IllegalArgumentException("only control character mappings available for Unicode code point " + controlCodePoint);
            }
            newTransformationMatrix.putAll(controlCodePoint, safeCodePoints);
        }
        return FilePathRestrictions.combineRules(rules, new FilePathRestrictions(newTransformationMatrix, null, null, null, safeCharacters));
    }

    private static FilePathRestrictions combineRules(FilePathRestrictions ... rules) {
        if (rules.length == 0) {
            throw new IllegalArgumentException("cannot combine an empty list of rules");
        }
        int index = 0;
        FilePathRestrictions product = rules[index++];
        while (index < rules.length) {
            boolean transitiveClosing;
            FilePathRestrictions toCombine = rules[index++];
            Sets.SetView<Character> safeCharacters = Sets.intersection(product.safeCharacters, toCombine.safeCharacters);
            if (safeCharacters.isEmpty()) {
                throw new IllegalArgumentException("cannot combine safe characters");
            }
            Sets.SetView<Integer> allKeys = Sets.union(product.transformationMatrix.keySet(), toCombine.transformationMatrix.keySet());
            Map productMatrixMap = product.transformationMatrix.asMap();
            Map toCombineMatrixMap = toCombine.transformationMatrix.asMap();
            HashMultimap<Integer, Integer> newTransformationMatrix = HashMultimap.create();
            for (Integer key : allKeys) {
                Object valuesSet;
                Object values;
                if (!((ImmutableMap)productMatrixMap).containsKey(key)) {
                    values = (Collection)((ImmutableMap)toCombineMatrixMap).get(key);
                } else if (!((ImmutableMap)toCombineMatrixMap).containsKey(key)) {
                    values = (Collection)((ImmutableMap)productMatrixMap).get(key);
                } else {
                    valuesSet = new HashSet((Collection)((ImmutableMap)productMatrixMap).get(key));
                    valuesSet.retainAll((Collection)((ImmutableMap)toCombineMatrixMap).get(key));
                    if (valuesSet.isEmpty()) {
                        throw new IllegalArgumentException("cannot combine transformations for Unicode code point " + key);
                    }
                    values = valuesSet;
                }
                valuesSet = values.iterator();
                while (valuesSet.hasNext()) {
                    Integer value = (Integer)valuesSet.next();
                    newTransformationMatrix.put(key, value);
                }
            }
            HashMultimap<Integer, Integer> entriesRemoved = HashMultimap.create();
            block3: do {
                transitiveClosing = false;
                for (Map.Entry transformation : newTransformationMatrix.entries()) {
                    int to = (Integer)transformation.getValue();
                    if (!newTransformationMatrix.containsKey(to)) continue;
                    int from = (Integer)transformation.getKey();
                    if (!entriesRemoved.put(from, to)) {
                        throw new IllegalArgumentException("cyclic transformation involving Unicode code point " + from);
                    }
                    newTransformationMatrix.remove(from, to);
                    newTransformationMatrix.putAll(from, newTransformationMatrix.get(to));
                    transitiveClosing = true;
                    continue block3;
                }
            } while (transitiveClosing);
            product = new FilePathRestrictions(newTransformationMatrix, Sets.union(product.unsafePrefixes, toCombine.unsafePrefixes), Sets.union(product.unsafeSuffixes, toCombine.unsafeSuffixes), Sets.union(product.unsafeNames, toCombine.unsafeNames), safeCharacters);
        }
        return product;
    }

    public static FilePathRestrictions combineFilePathRestrictions(FilePathRestrictions ... rules) {
        return FilePathRestrictions.includeControlTransformations(FilePathRestrictions.combineRules(rules));
    }

    public FilePathRestrictions(SetMultimap<Integer, Integer> transformationMatrix, Set<String> unsafePrefixes, Set<String> unsafeSuffixes, Set<String> unsafeNames, Set<Character> safeCharacters) {
        this.transformationMatrix = transformationMatrix == null ? ImmutableSetMultimap.of() : ImmutableSetMultimap.copyOf(transformationMatrix);
        this.unsafePrefixes = unsafePrefixes == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafePrefixes);
        this.unsafeSuffixes = unsafeSuffixes == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafeSuffixes);
        this.unsafeNames = unsafeNames == null ? ImmutableSet.of() : ImmutableSet.copyOf(unsafeNames);
        this.safeCharacters = ImmutableSet.copyOf(safeCharacters);
        this.safeCharacter = ((Character)this.safeCharacters.iterator().next()).charValue();
        int safeCodePoint = FilePathRestrictionInstance.getCodePoint(this.safeCharacter);
        ImmutableMap.Builder transformationMapBuilder = ImmutableMap.builder();
        for (Map.Entry transformation : ((ImmutableMap)this.transformationMatrix.asMap()).entrySet()) {
            Collection values = (Collection)transformation.getValue();
            Integer selectedValue = values.contains(safeCodePoint) ? safeCodePoint : (Integer)values.iterator().next();
            transformationMapBuilder.put(transformation.getKey(), selectedValue);
        }
        this.transformationMap = transformationMapBuilder.build();
    }

    static {
        ImmutableSet.Builder controlCodePointsBuilder = ImmutableSet.builder();
        for (int codePoint = 0; codePoint < 256; ++codePoint) {
            if (Character.getType(codePoint) != 15) continue;
            controlCodePointsBuilder.add((Object)codePoint);
        }
        controlCodePoints = controlCodePointsBuilder.build();
        isNotControlCodePoint = new Predicate<Integer>(){

            @Override
            public boolean apply(Integer codePoint) {
                return !controlCodePoints.contains(codePoint);
            }
        };
    }
}

