/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.util.CurrentPlatform;

public enum FilePathRestrictionInstance {
    WINDOWS_REQUIRED("Windows required"),
    WINDOWS_OPTIONAL("Windows optional"),
    UNIX_REQUIRED("UNIX required"),
    UNIX_OPTIONAL("UNIX optional"),
    LOCAL_REQUIRED("local required"),
    LOCAL_OPTIONAL("local optional");

    private static ImmutableMap<String, FilePathRestrictionInstance> nameLookup;
    public final String name;
    private FilePathRestrictions rules;

    static int getCodePoint(char character) {
        char[] singletonCharacterArray = new char[]{character};
        return Character.codePointAt(singletonCharacterArray, 0);
    }

    public static FilePathRestrictions getFilePathRestrictions(String ... names) {
        FilePathRestrictionInstance[] enums = new FilePathRestrictionInstance[names.length];
        for (int index = 0; index < names.length; ++index) {
            enums[index] = nameLookup.get(names[index]);
        }
        return FilePathRestrictionInstance.getFilePathRestrictions(enums);
    }

    public static FilePathRestrictions getFilePathRestrictions(FilePathRestrictionInstance ... enums) {
        FilePathRestrictions[] rules = new FilePathRestrictions[enums.length];
        for (int index = 0; index < enums.length; ++index) {
            rules[index] = enums[index].rules;
        }
        return FilePathRestrictions.combineFilePathRestrictions(rules);
    }

    private FilePathRestrictionInstance(String name) {
        this.name = name;
    }

    static {
        ImmutableMap.Builder<String, FilePathRestrictionInstance> nameLookupBuilder = ImmutableMap.builder();
        nameLookupBuilder.put(FilePathRestrictionInstance.WINDOWS_REQUIRED.name, WINDOWS_REQUIRED);
        nameLookupBuilder.put(FilePathRestrictionInstance.WINDOWS_OPTIONAL.name, WINDOWS_OPTIONAL);
        nameLookupBuilder.put(FilePathRestrictionInstance.UNIX_REQUIRED.name, UNIX_REQUIRED);
        nameLookupBuilder.put(FilePathRestrictionInstance.UNIX_OPTIONAL.name, UNIX_OPTIONAL);
        nameLookupBuilder.put(FilePathRestrictionInstance.LOCAL_REQUIRED.name, LOCAL_REQUIRED);
        nameLookupBuilder.put(FilePathRestrictionInstance.LOCAL_OPTIONAL.name, LOCAL_OPTIONAL);
        nameLookup = nameLookupBuilder.build();
        ImmutableSet<Character> safeCharacters = ImmutableSet.of(Character.valueOf('_'));
        int safeCodePoint = FilePathRestrictionInstance.getCodePoint(((Character)safeCharacters.iterator().next()).charValue());
        HashMultimap<Integer, Integer> transformationMatrix = HashMultimap.create();
        HashSet<String> unsafePrefixes = new HashSet<String>();
        HashSet<String> unsafeSuffixes = new HashSet<String>();
        HashSet<String> unsafeNames = new HashSet<String>();
        for (int codePoint = 0; codePoint < 32; ++codePoint) {
            transformationMatrix.put(codePoint, safeCodePoint);
        }
        transformationMatrix.put(34, FilePathRestrictionInstance.getCodePoint('\''));
        transformationMatrix.put(42, FilePathRestrictionInstance.getCodePoint('x'));
        transformationMatrix.put(47, FilePathRestrictionInstance.getCodePoint('!'));
        transformationMatrix.put(58, FilePathRestrictionInstance.getCodePoint(';'));
        transformationMatrix.put(60, FilePathRestrictionInstance.getCodePoint('['));
        transformationMatrix.put(62, FilePathRestrictionInstance.getCodePoint(']'));
        transformationMatrix.put(63, FilePathRestrictionInstance.getCodePoint('%'));
        transformationMatrix.put(92, FilePathRestrictionInstance.getCodePoint('!'));
        transformationMatrix.put(124, FilePathRestrictionInstance.getCodePoint('!'));
        unsafeNames.add("AUX");
        unsafeNames.add("CLOCK$");
        unsafeNames.add("CON");
        unsafeNames.add("NUL");
        unsafeNames.add("PRN");
        for (char number = '1'; number <= '9'; number = (char)(number + '\u0001')) {
            unsafeNames.add("COM" + number);
            unsafeNames.add("LPT" + number);
        }
        for (String unsafeName : unsafeNames) {
            unsafePrefixes.add(unsafeName + ".");
        }
        unsafePrefixes.add("$");
        FilePathRestrictionInstance.WINDOWS_REQUIRED.rules = new FilePathRestrictions(transformationMatrix, unsafePrefixes, null, unsafeNames, safeCharacters);
        unsafeSuffixes.clear();
        unsafeSuffixes.add(".");
        unsafeSuffixes.add(" ");
        FilePathRestrictionInstance.WINDOWS_OPTIONAL.rules = new FilePathRestrictions(null, null, unsafeSuffixes, null, safeCharacters);
        transformationMatrix.clear();
        transformationMatrix.put(0, safeCodePoint);
        transformationMatrix.put(47, FilePathRestrictionInstance.getCodePoint('!'));
        FilePathRestrictionInstance.UNIX_REQUIRED.rules = new FilePathRestrictions(transformationMatrix, null, null, null, safeCharacters);
        unsafePrefixes.clear();
        unsafePrefixes.add(".");
        unsafePrefixes.add("-");
        FilePathRestrictionInstance.UNIX_OPTIONAL.rules = new FilePathRestrictions(null, unsafePrefixes, null, null, safeCharacters);
        if (CurrentPlatform.isWindows()) {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.WINDOWS_REQUIRED.rules;
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.WINDOWS_OPTIONAL.rules;
        } else if (CurrentPlatform.isLinux() || CurrentPlatform.isMacOSX()) {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.UNIX_REQUIRED.rules;
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.UNIX_OPTIONAL.rules;
        } else {
            FilePathRestrictionInstance.LOCAL_REQUIRED.rules = FilePathRestrictionInstance.getFilePathRestrictions(WINDOWS_REQUIRED, UNIX_REQUIRED);
            FilePathRestrictionInstance.LOCAL_OPTIONAL.rules = FilePathRestrictionInstance.getFilePathRestrictions(WINDOWS_OPTIONAL, UNIX_OPTIONAL);
        }
    }
}

