/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.ObjectAdapter;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.AbstractRepositoryI;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.scripts.ScriptRepoHelper;
import ome.services.util.Executor;
import ome.system.Principal;
import omero.ServerError;
import omero.ValidationException;
import omero.model.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRepositoryI
extends AbstractRepositoryI {
    private static final Logger log = LoggerFactory.getLogger(ScriptRepositoryI.class);
    private final ScriptRepoHelper helper;

    public ScriptRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, Principal p, ScriptRepoHelper helper, PublicRepositoryI servant) {
        super(oa, reg, ex, p, helper.getScriptDir(), servant);
        this.helper = helper;
    }

    @Override
    public String generateRepoUuid() {
        return this.helper.getUuid();
    }

    @Override
    public String getFilePath(OriginalFile file2, Current __current) throws ServerError {
        String repo = this.getFileRepo(file2);
        String uuid = this.getRepoUuid();
        if (repo == null || !repo.equals(uuid)) {
            throw new ValidationException(null, null, repo + " does not belong to this repository: " + uuid);
        }
        return file2.getPath() == null ? null : file2.getPath().getValue();
    }
}

