/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import java.util.concurrent.atomic.AtomicReference;
import ome.api.RawFileStore;
import ome.services.blitz.impl.RawFileStoreI;
import ome.services.blitz.util.BlitzExecutor;
import omero.ApiUsageException;
import omero.ServerError;
import omero.api.AMD_RawFileStore_read;
import omero.api.AMD_RawFileStore_setFileId;
import omero.api.AMD_RawFileStore_write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoRawFileStoreI
extends RawFileStoreI {
    private static final Logger log = LoggerFactory.getLogger(RepoRawFileStoreI.class);
    private AtomicReference<Callback> cb = new AtomicReference();

    public RepoRawFileStoreI(BlitzExecutor be, RawFileStore service, Current curr) {
        super(service, be);
    }

    public void setCallback(Callback cb) {
        this.cb.set(cb);
    }

    @Override
    public void setFileId_async(AMD_RawFileStore_setFileId __cb, long fileId, Current __current) throws ServerError {
        ApiUsageException aue = new ApiUsageException();
        aue.message = "Cannot reset id to " + fileId;
        __cb.ice_exception(aue);
    }

    @Override
    public void read_async(AMD_RawFileStore_read __cb, long position, int length, Current __current) throws ServerError {
        if (length > 64000000) {
            __cb.ice_exception(new ApiUsageException(null, null, "Too big: " + length));
            return;
        }
        super.read_async(__cb, position, length, __current);
    }

    @Override
    public void write_async(AMD_RawFileStore_write __cb, byte[] buf, long position, int length, Current __current) throws ServerError {
        super.write_async(__cb, buf, position, length, __current);
        Callback cb = this.cb.get();
        if (cb != null) {
            cb.onWrite(buf, position, length);
        }
    }

    @Override
    protected void preClose(Current current) throws Throwable {
        try {
            super.preClose(current);
        }
        finally {
            Callback cb = this.cb.get();
            if (cb != null) {
                cb.onPreClose();
            }
        }
    }

    @Override
    protected void postClose(Current c) {
        try {
            super.postClose(c);
        }
        finally {
            Callback cb = this.cb.get();
            if (cb != null) {
                cb.onPostClose();
            }
        }
    }

    static class NoOpCallback
    implements Callback {
        NoOpCallback() {
        }

        @Override
        public void onWrite(byte[] buf, long position, long length) {
        }

        @Override
        public void onPreClose() {
        }

        @Override
        public void onPostClose() {
        }
    }

    static interface Callback {
        public void onWrite(byte[] var1, long var2, long var4);

        public void onPreClose();

        public void onPostClose();
    }
}

