/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.Identity;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import ome.io.nio.FileBuffer;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.AbstractRepositoryI;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import omero.ApiUsageException;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.Unknown;
import omero.grid.FileDeleteException;
import omero.grid.InternalRepositoryPrx;
import omero.grid.RawAccessRequest;
import omero.grid.RepositoryException;
import omero.model.ChecksumAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAccessRequestI
extends RawAccessRequest
implements IRequest {
    private static final long serialVersionUID = -303948503984L;
    private static Logger log = LoggerFactory.getLogger(RawAccessRequestI.class);
    private final Registry reg;
    protected Helper helper;
    protected InternalRepositoryPrx repo;

    public RawAccessRequestI(Registry reg) {
        this.reg = reg;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        if (!helper.getEventContext().isCurrentUserAdmin()) {
            throw helper.cancel(new ERR(), (Throwable)new SecurityViolation(), "not-admin", new String[0]);
        }
        log.debug("Looking repo " + this.repoUuid);
        try {
            InternalRepositoryPrx[] proxies;
            String proposedName = "InternalRepository-" + this.repoUuid;
            for (InternalRepositoryPrx prx : proxies = this.reg.lookupRepositories()) {
                Identity id = prx.ice_getIdentity();
                if (!proposedName.equals(id.name)) continue;
                this.repo = prx;
                log.debug("Found repo " + this.repoUuid);
                break;
            }
        }
        catch (Exception e) {
            throw helper.cancel(new ERR(), (Throwable)e, "registry-lookup", "repoUuid", this.repoUuid);
        }
        if (this.repo == null) {
            throw helper.cancel((ERR)new Unknown(), null, "unknown-repo", "repoUuid", this.repoUuid);
        }
        this.helper.setSteps(1);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        return this.rawAccess();
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        this.helper.setResponseIfNull((Response)object);
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    public Response rawAccess() {
        try {
            log.debug("Calling raw access for command " + this.command);
            Response response = this.repo.rawAccess(this);
            return response;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "raw-access", "command", this.command);
        }
        finally {
            log.debug("Done calling raw access for command " + this.command);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void local(AbstractRepositoryI abstractRepositoryI, PublicRepositoryI servant, Current __current) throws Exception {
        if ("touch".equals(this.command)) {
            Iterator iterator = this.args.iterator();
            while (iterator.hasNext()) {
                String arg = (String)iterator.next();
                CheckedPath checked = servant.checkPath(this.parse(arg), null, __current);
                if (!checked.exists()) {
                    CheckedPath parent = checked.parent();
                    if (!parent.isDirectory() && !checked.parent().mkdirs()) {
                        throw new RepositoryException(null, null, "cannot create directory: " + parent);
                    }
                    FileBuffer buffer = checked.getFileBuffer("rw");
                    buffer.write(ByteBuffer.allocate(0));
                    buffer.close();
                    continue;
                }
                if (!checked.markModified()) throw new RepositoryException(null, null, "cannot touch file: " + checked);
            }
            return;
        }
        if ("exists".equals(this.command)) {
            String arg = (String)this.args.get(0);
            CheckedPath checked = servant.checkPath(this.parse(arg), null, __current);
            if (checked.exists()) return;
            throw new RepositoryException(null, null, "file does not exist: " + checked);
        }
        if ("mkdir".equals(this.command)) {
            boolean parents = false;
            Iterator checked = this.args.iterator();
            while (checked.hasNext()) {
                String arg = (String)checked.next();
                if ("-p".equals(arg)) {
                    parents = true;
                    continue;
                }
                CheckedPath checked2 = servant.checkPath(this.parse(arg), null, __current);
                if (parents) {
                    checked2.mkdirs();
                    continue;
                }
                checked2.mkdir();
            }
            return;
        }
        if ("rm".equals(this.command)) {
            if (this.args.size() != 1) throw new ApiUsageException(null, null, "Command: " + this.command + " takes just one argument");
            CheckedPath checked = servant.checkPath(this.parse((String)this.args.get(0)), null, __current);
            if (checked.delete()) return;
            throw new FileDeleteException(null, null, "Delete file failed: " + (String)this.args.get(0));
        }
        if ("mv".equals(this.command)) {
            if (this.args.size() != 2) throw new ApiUsageException(null, null, "Command: " + this.command + " takes two arguments");
            CheckedPath source = servant.checkPath(this.parse((String)this.args.get(0)), null, __current);
            CheckedPath target = servant.checkPath(this.parse((String)this.args.get(1)), null, __current);
            boolean success = false;
            if (target.exists() && target.isDirectory()) {
                try {
                    source.moveToDir(target, false);
                    return;
                }
                catch (IOException ex) {
                    success = false;
                    log.warn("IOException on moveToDir: {}->{}", source, target, ex);
                }
            } else {
                success = source.renameTo(target);
            }
            if (success) return;
            throw new ResourceError(null, null, String.format("'mv %s %s' failed", source, target));
        }
        if ("checksum".equals(this.command)) {
            if (this.args.size() != 3) throw new ApiUsageException(null, null, "'checksum' requires HASHER HASH FILEPATH, not: " + this.args.toString());
            String checksumType = (String)this.args.get(0);
            ChecksumAlgorithm algo = ChecksumAlgorithmMapper.getChecksumAlgorithm(checksumType);
            String expectedHash = (String)this.args.get(1);
            CheckedPath checked = servant.checkPath(this.parse((String)this.args.get(2)), algo, __current);
            String currentHash = checked.hash();
            if (currentHash.equals(expectedHash)) return;
            throw new ResourceError(null, null, String.format("Checksum mismatch (%s): expected=%s found=%s", checksumType, expectedHash, currentHash));
        }
        if (!"read-only".equals(this.command)) throw new ApiUsageException(null, null, "Unknown command: " + this.command);
        if (this.args.size() != 1) throw new ApiUsageException(null, null, "Command: " + this.command + " takes just one argument");
        CheckedPath checked = servant.checkPath(this.parse((String)this.args.get(0)), null, __current);
        if (checked.setReadOnly()) return;
        throw new ResourceError(null, null, "setReadOnly failed: " + (String)this.args.get(0));
    }

    private String parse(String arg) {
        if (arg.startsWith("/")) {
            arg = "./" + arg;
        }
        return arg;
    }
}

