/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.ObjectNotExistException;
import ch.qos.logback.classic.ClassicConstants;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.MissingLibraryException;
import loci.formats.UnknownFormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.MIASReader;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.OverlayMetadataStore;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportSize;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.targets.ServerTemplateImportTarget;
import ome.formats.importer.util.ErrorHandler;
import ome.io.nio.TileSizes;
import ome.model.annotations.Annotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.ManagedImportLocationI;
import ome.services.blitz.repo.RepositoryDao;
import omero.ServerError;
import omero.api.ServiceFactoryPrx;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.HandlePrx;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.grid.ImportRequest;
import omero.grid.ImportResponse;
import omero.model.IObject;
import omero.model.Image;
import omero.model.IndexingJob;
import omero.model.Job;
import omero.model.MetadataImportJob;
import omero.model.OriginalFile;
import omero.model.PixelDataJob;
import omero.model.Pixels;
import omero.model.Plate;
import omero.model.ScriptJob;
import omero.model.ThumbnailGenerationJob;
import omero.rtypes;
import omero.util.IceMapper;
import omero.util.Resources;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ManagedImportRequestI
extends ImportRequest
implements IRequest {
    private static final long serialVersionUID = -303948503985L;
    private static Logger log = LoggerFactory.getLogger(ManagedImportRequestI.class);
    private Helper helper;
    private byte[] arrayBuf = new byte[5000000];
    private final Registry reg;
    private final TileSizes sizes;
    private final RepositoryDao dao;
    private CheckedPath logPath;
    private String logFilename;
    private ServiceFactoryPrx sf = null;
    private OMEROMetadataStoreClient store = null;
    private Resources resources = null;
    private Resources.Entry resourcesEntry = null;
    private OMEROWrapper reader = null;
    private CheckedPath file = null;
    private IObject userSpecifiedTarget = null;
    private String userSpecifiedName = null;
    private String userSpecifiedDescription = null;
    private double[] userPixels = null;
    private List<omero.model.Annotation> annotationList = null;
    private boolean doThumbnails = true;
    private boolean noStatsInfo = false;
    private String fileName = null;
    private String shortName = null;
    private String format = null;
    private String formatString = null;
    private String[] usedFiles = null;
    private Map<String, List<IObject>> objects;
    private List<Pixels> pixList;
    private List<Image> imageList;
    private List<Plate> plateList;
    private boolean autoClose;
    private final String token;
    public HandlePrx handle;

    public ManagedImportRequestI(Registry reg, TileSizes sizes, RepositoryDao dao, OMEROWrapper wrapper, String token) {
        this.reg = reg;
        this.sizes = sizes;
        this.dao = dao;
        this.reader = wrapper;
        this.token = token;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        helper.setSteps(5);
        ImportConfig config = new ImportConfig();
        String sessionUuid = helper.getEventContext().getCurrentSessionUuid();
        if (!(this.location instanceof ManagedImportLocationI)) {
            throw helper.cancel(new ERR(), null, "bad-location", "location-type", this.location.getClass().getName());
        }
        ManagedImportLocationI managedLocation = (ManagedImportLocationI)this.location;
        this.logPath = managedLocation.getLogFile();
        this.logFilename = this.logPath.getFullFsPath();
        MDC.put("fileset", this.logFilename);
        this.file = ((ManagedImportLocationI)this.location).getTarget();
        try {
            this.sf = this.reg.getInternalServiceFactory(sessionUuid, "unused", 3, 1, this.clientUuid);
            this.store = new OMEROMetadataStoreClient();
            this.store.setCurrentLogFile(this.logFilename, this.token);
            this.store.initialize(this.sf);
            this.registerKeepAlive();
            this.fileName = this.file.getFullFsPath();
            this.shortName = this.file.getName();
            this.format = null;
            this.usedFiles = new String[]{this.fileName};
            this.open(this.reader, this.store, this.file);
            this.format = this.reader.getFormat();
            if (this.reader.getUsedFiles() != null) {
                this.usedFiles = this.reader.getUsedFiles();
            }
            if (this.usedFiles == null) {
                throw new NullPointerException("usedFiles must be non-null");
            }
            this.detectKnownAnnotations();
            this.userSpecifiedTarget = this.settings.userSpecifiedTarget;
            this.userSpecifiedName = this.settings.userSpecifiedName == null ? null : this.settings.userSpecifiedName.getValue();
            this.userSpecifiedDescription = this.settings.userSpecifiedDescription == null ? null : this.settings.userSpecifiedDescription.getValue();
            this.userPixels = this.settings.userSpecifiedPixels;
            this.annotationList = this.settings.userSpecifiedAnnotationList;
            this.doThumbnails = this.settings.doThumbnails == null ? true : this.settings.doThumbnails.getValue();
            this.noStatsInfo = this.settings.noStatsInfo == null ? false : this.settings.noStatsInfo.getValue();
            IFormatReader baseReader = this.reader.getImageReader().getReader();
            if (log.isInfoEnabled()) {
                log.info("File format: " + this.format);
                log.info("Base reader: " + baseReader.getClass().getName());
            }
            this.notifyObservers(new ImportEvent.LOADED_IMAGE(this.shortName, 0, 0, 0));
            this.formatString = baseReader.getClass().getSimpleName();
            this.formatString = this.formatString.replace("Reader", "");
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            throw helper.cancel(new ERR(), t, "error-on-init", new String[0]);
        }
        finally {
            MDC.clear();
        }
    }

    protected void registerKeepAlive() {
        if (this.resources != null) {
            this.resourcesEntry = new Resources.Entry(){

                @Override
                public boolean check() {
                    try {
                        if (ManagedImportRequestI.this.sf != null) {
                            ManagedImportRequestI.this.sf.keepAlive(null);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Proxy keep alive failed.", e);
                    }
                    return false;
                }

                @Override
                public void cleanup() {
                }
            };
            this.resources.add(this.resourcesEntry);
        }
    }

    private void cleanupReader() {
        block5: {
            try {
                if (this.reader == null) break block5;
                try {
                    this.reader.close();
                }
                finally {
                    this.reader = null;
                }
            }
            catch (Throwable e) {
                log.error("Failed on cleanupReader", e);
            }
        }
    }

    private void cleanupStore() {
        block5: {
            try {
                if (this.store == null) break block5;
                try {
                    this.store.logout();
                }
                finally {
                    this.store = null;
                }
            }
            catch (Throwable e) {
                log.error("Failed on cleanupStore", e);
            }
        }
    }

    private void cleanupSession() {
        block5: {
            try {
                if (this.sf == null) break block5;
                try {
                    this.sf.destroy();
                }
                finally {
                    this.sf = null;
                }
            }
            catch (Throwable e) {
                log.error("Failed on cleanupSession", e);
            }
        }
    }

    private void detectKnownAnnotations() throws Exception {
        if (this.settings == null || this.settings.userSpecifiedAnnotationList == null) {
            return;
        }
        Annotation lastCA = null;
        long maxCAId = 0L;
        for (omero.model.Annotation a : this.settings.userSpecifiedAnnotationList) {
            CommentAnnotation ca;
            if (a == null) continue;
            Annotation ann = null;
            String ns = null;
            if (a.isLoaded()) {
                ns = a.getNs() == null ? null : a.getNs().getValue();
                ann = (Annotation)new IceMapper().reverse(a);
            } else {
                if (a.getId() == null) continue;
                ann = (Annotation)this.helper.getSession().get(Annotation.class, (Serializable)Long.valueOf(a.getId().getValue()));
                ns = ann.getNs();
            }
            if ("openmicroscopy.org/omero/import/autoClose".equals(ns)) {
                this.autoClose = true;
                continue;
            }
            if (!"openmicroscopy.org/omero/import/targetTemplate".equals(ns) || (ca = (CommentAnnotation)ann).getId() <= maxCAId) continue;
            maxCAId = ca.getId();
            lastCA = ca;
        }
        if (lastCA != null) {
            if (this.settings.userSpecifiedTarget != null) {
                String kls = this.settings.userSpecifiedTarget.getClass().getSimpleName();
                long id = this.settings.userSpecifiedTarget.getId().getValue();
                log.error("User-specified template target '{}' AND {}:{}", ((TextAnnotation)lastCA).getTextValue(), kls, id);
            } else {
                String path = lastCA.getDescription();
                File file2 = new File(path);
                for (int i = 0; i < this.location.omittedLevels; ++i) {
                    file2 = file2.getParentFile();
                }
                path = file2.toString();
                log.debug("Using target path {}", (Object)path);
                ServerTemplateImportTarget target = new ServerTemplateImportTarget(path);
                target.init(((TextAnnotation)lastCA).getTextValue());
                this.settings.userSpecifiedTarget = target.load(this.store, this.reader.isSPWReader());
            }
        }
    }

    private void autoClose() {
        if (this.autoClose) {
            log.info("Auto-closing...");
            try {
                if (this.handle == null) {
                    log.warn("No handle for closing");
                } else {
                    this.handle.close();
                }
            }
            catch (Throwable t) {
                log.error("Failed to close handle on autoClose", t);
            }
            try {
                this.process.close();
            }
            catch (ObjectNotExistException t) {
            }
            catch (Throwable t) {
                log.error("Failed to close process on autoClose", t);
            }
        }
    }

    private void cleanup() {
        MDC.put("fileset", this.logFilename);
        try {
            this.cleanupReader();
            this.cleanupStore();
            log.info(ClassicConstants.FINALIZE_SESSION_MARKER, "Finalizing log file.");
            MDC.clear();
            try {
                this.setLogFileSize();
            }
            catch (ServerError se) {
                log.error("failed to set import log file size", se);
            }
            this.cleanupSession();
        }
        finally {
            this.autoClose();
            if (this.resources != null) {
                this.resources.remove(this.resourcesEntry);
            }
        }
    }

    private void setLogFileSize() throws ServerError {
        OriginalFile logFile = (OriginalFile)this.sf.getQueryService().get(OriginalFile.class.getSimpleName(), this.logPath.getId());
        logFile.setSize(rtypes.rlong(this.logPath.size()));
        this.sf.getUpdateService().saveObject(logFile);
    }

    @Override
    public Object step(int step) {
        this.helper.assertStep(step);
        try {
            MDC.put("fileset", this.logFilename);
            log.debug("Step " + step);
            Job j = this.activity.getChild();
            if (j == null) {
                throw this.helper.cancel(new ERR(), null, "null-job", new String[0]);
            }
            if (!(j instanceof MetadataImportJob)) {
                throw this.helper.cancel(new ERR(), null, "unexpected-job-type", "job-type", j.ice_id());
            }
            if (step == 0) {
                Map<String, List<IObject>> map = this.importMetadata((MetadataImportJob)j);
                return map;
            }
            if (step == 1) {
                Object object = this.pixelData(null);
                return object;
            }
            if (step == 2) {
                Object object = this.generateThumbnails(null);
                return object;
            }
            if (step == 3) {
                this.store.launchProcessing();
                Object var3_13 = null;
                return var3_13;
            }
            if (step == 4) {
                Map<String, List<IObject>> map = this.objects;
                return map;
            }
            try {
                throw this.helper.cancel(new ERR(), null, "bad-step", "step", "" + step);
            }
            catch (MissingLibraryException mle) {
                this.notifyObservers(new ErrorHandler.MISSING_LIBRARY(this.fileName, mle, this.usedFiles, this.format));
                throw this.helper.cancel(new ERR(), (Throwable)mle, "import-missing-library", "filename", this.fileName);
            }
            catch (UnsupportedCompressionException uce) {
                this.notifyObservers(new ErrorHandler.UNKNOWN_FORMAT(this.fileName, uce, this));
                throw this.helper.cancel(new ERR(), (Throwable)uce, "import-unknown-format", "filename", this.fileName);
            }
            catch (UnknownFormatException ufe) {
                this.notifyObservers(new ErrorHandler.UNKNOWN_FORMAT(this.fileName, ufe, this));
                throw this.helper.cancel(new ERR(), (Throwable)ufe, "import-unknown-format", "filename", this.fileName);
            }
            catch (IOException io) {
                this.notifyObservers(new ErrorHandler.FILE_EXCEPTION(this.fileName, io, this.usedFiles, this.format));
                throw this.helper.cancel(new ERR(), (Throwable)io, "import-file-exception", "filename", this.fileName);
            }
            catch (FormatException fe) {
                this.notifyObservers(new ErrorHandler.FILE_EXCEPTION(this.fileName, fe, this.usedFiles, this.format));
                throw this.helper.cancel(new ERR(), (Throwable)fe, "import-file-exception", "filename", this.fileName);
            }
            catch (HandleI.Cancel c) {
                throw c;
            }
            catch (Throwable t) {
                this.notifyObservers(new ErrorHandler.INTERNAL_EXCEPTION(this.fileName, new RuntimeException(t), this.usedFiles, this.format));
                throw this.helper.cancel(new ERR(), t, "import-request-failure", new String[0]);
            }
        }
        finally {
            try {
                long size = this.logPath.size();
                this.store.updateFileSize(this.logFile, size);
            }
            catch (Throwable t) {
                throw this.helper.cancel(new ERR(), t, "update-log-file-size", new String[0]);
            }
            MDC.clear();
        }
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 4) {
            ImportResponse rsp = new ImportResponse();
            Map rv = (Map)object;
            rsp.pixels = (List)rv.get(Pixels.class.getSimpleName());
            rsp.objects = new ArrayList<IObject>();
            this.addObjects(rsp.objects, rv, Plate.class.getSimpleName());
            this.addObjects(rsp.objects, rv, Image.class.getSimpleName());
            this.helper.setResponseIfNull(rsp);
        }
    }

    private void addObjects(List<IObject> objects, Map<String, List<IObject>> rv, String simpleName) {
        List<IObject> list = rv.get(simpleName);
        if (list != null) {
            objects.addAll(list);
        }
    }

    @Override
    public Response getResponse() {
        Response rsp = this.helper.getResponse();
        if (rsp != null) {
            this.cleanup();
        }
        return rsp;
    }

    public Map<String, List<IObject>> importMetadata(MetadataImportJob mij) throws Throwable {
        this.notifyObservers(new ImportEvent.LOADING_IMAGE(this.shortName, 0, 0, 0));
        this.notifyObservers(new ImportEvent.BEGIN_POST_PROCESS(0, null, null, null, 0, null));
        this.store.setUserSpecifiedName(this.userSpecifiedName);
        this.store.setUserSpecifiedDescription(this.userSpecifiedDescription);
        if (this.userPixels != null && this.userPixels.length >= 3) {
            this.store.setUserSpecifiedPhysicalPixelSizes(this.userPixels[0], this.userPixels[1], this.userPixels[2]);
        }
        this.store.setUserSpecifiedTarget(this.userSpecifiedTarget);
        this.store.setUserSpecifiedAnnotations(this.annotationList);
        this.store.postProcess();
        this.notifyObservers(new ImportEvent.END_POST_PROCESS(0, null, this.userSpecifiedTarget, null, 0, null));
        this.notifyObservers(new ImportEvent.BEGIN_SAVE_TO_DB(0, null, this.userSpecifiedTarget, null, 0, null));
        this.objects = this.store.saveToDB(this.activity);
        this.pixList = this.objects.get(Pixels.class.getSimpleName());
        this.imageList = this.objects.get(Image.class.getSimpleName());
        this.plateList = this.objects.get(Plate.class.getSimpleName());
        this.notifyObservers(new ImportEvent.END_SAVE_TO_DB(0, null, this.userSpecifiedTarget, null, 0, null));
        return this.objects;
    }

    public Object pixelData(PixelDataJob pdj) throws Throwable {
        if (!this.reader.isMinMaxSet() && !this.noStatsInfo) {
            int seriesCount = this.reader.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                ImportSize size = new ImportSize(this.fileName, this.pixList.get(series), this.reader.getDimensionOrder());
                Pixels pixels = this.pixList.get(series);
                MessageDigest md = this.parseData(this.fileName, series, size);
                if (md == null) continue;
                String s = Hex.encodeHexString((byte[])md.digest());
                pixels.setSha1(this.store.toRType(s));
            }
        }
        int series = 0;
        for (Pixels pixels : this.pixList) {
            this.store.setPixelsFile(pixels.getId().getValue(), this.fileName, this.repoUuid);
            pixels.getImage().setSeries(this.store.toRType(series++));
        }
        for (Image image : this.imageList) {
            image.unloadAnnotationLinks();
            image.unloadDatasetLinks();
            image.unloadFolderLinks();
            image.unloadWellSamples();
        }
        this.store.updatePixels(this.pixList);
        if (!this.reader.isMinMaxSet() && !this.noStatsInfo) {
            this.store.populateMinMax();
        }
        return null;
    }

    public Object generateThumbnails(ThumbnailGenerationJob tgj) throws Throwable {
        ArrayList<Long> plateIds = new ArrayList<Long>();
        Image image = this.pixList.get(0).getImage();
        if (image.sizeOfWellSamples() > 0) {
            Plate plate = image.copyWellSamples().get(0).getWell().getPlate();
            plateIds.add(plate.getId().getValue());
        }
        this.notifyObservers(new ImportEvent.IMPORT_OVERLAYS(0, null, this.userSpecifiedTarget, null, 0, null));
        this.importOverlays(this.pixList, plateIds);
        this.notifyObservers(new ImportEvent.IMPORT_PROCESSING(0, null, this.userSpecifiedTarget, null, 0, null));
        if (this.doThumbnails) {
            this.store.resetDefaultsAndGenerateThumbnails(plateIds, this.pixelIds());
        } else {
            log.warn("Not creating thumbnails at user request!");
        }
        return null;
    }

    public Object index(IndexingJob ij) {
        return null;
    }

    public Object script(ScriptJob sj) {
        return null;
    }

    private void open(OMEROWrapper reader, OMEROMetadataStoreClient store, CheckedPath targetFile) throws FormatException, IOException {
        reader.setMetadataStore(store);
        reader.setMinMaxStore(store);
        store.setReader(reader.getImageReader());
        targetFile.bfSetId(reader);
        if (log.isDebugEnabled()) {
            log.debug("Image Count: " + reader.getImageCount());
        }
    }

    public MessageDigest parseData(String fileName, int series, ImportSize size) throws FormatException, IOException, ServerError {
        MessageDigest md;
        this.reader.setSeries(series);
        int maxPlaneSize = this.sizes.getMaxPlaneWidth() * this.sizes.getMaxPlaneHeight();
        if ((long)this.reader.getSizeX() * (long)this.reader.getSizeY() > (long)maxPlaneSize) {
            return null;
        }
        int bytesPerPixel = this.getBytesPerPixel(this.reader.getPixelType());
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        int planeNo = 1;
        for (int t = 0; t < size.sizeT; ++t) {
            for (int c = 0; c < size.sizeC; ++c) {
                for (int z = 0; z < size.sizeZ; ++z) {
                    this.parseDataByPlane(size, z, c, t, bytesPerPixel, fileName, md);
                    this.notifyObservers(new ImportEvent.IMPORT_STEP(planeNo, series, this.reader.getSeriesCount()));
                    ++planeNo;
                }
            }
        }
        return md;
    }

    private void parseDataByPlane(ImportSize size, int z, int c, int t, int bytesPerPixel, String fileName, MessageDigest md) throws FormatException, IOException {
        int tileHeight = this.reader.getOptimalTileHeight();
        int tileWidth = this.reader.getOptimalTileWidth();
        for (int tileOffsetY = 0; tileOffsetY < (size.sizeY + tileHeight - 1) / tileHeight; ++tileOffsetY) {
            for (int tileOffsetX = 0; tileOffsetX < (size.sizeX + tileWidth - 1) / tileWidth; ++tileOffsetX) {
                int bytesToRead;
                int x = tileOffsetX * tileWidth;
                int y = tileOffsetY * tileHeight;
                int w = tileWidth;
                int h = tileHeight;
                if (x + tileWidth > size.sizeX) {
                    w = size.sizeX - x;
                }
                if (y + tileHeight > size.sizeY) {
                    h = size.sizeY - y;
                }
                if (this.arrayBuf.length != (bytesToRead = w * h * bytesPerPixel)) {
                    this.arrayBuf = new byte[bytesToRead];
                }
                int planeNumber = this.reader.getIndex(z, c, t);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Plane:%d X:%d Y:%d TileWidth:%d TileHeight:%d arrayBuf.length:%d", planeNumber, x, y, w, h, this.arrayBuf.length));
                }
                this.arrayBuf = this.reader.openBytes(planeNumber, this.arrayBuf, x, y, w, h);
                try {
                    md.update(this.arrayBuf);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void importOverlays(List<Pixels> pixelsList, List<Long> plateIds) throws FormatException, IOException {
        IFormatReader baseReader = this.reader.getImageReader().getReader();
        if (baseReader instanceof MIASReader) {
            try {
                MIASReader miasReader = (MIASReader)baseReader;
                ServiceFactoryPrx sf = this.store.getServiceFactory();
                OverlayMetadataStore s = new OverlayMetadataStore();
                s.initialize(sf, pixelsList, plateIds);
                miasReader.parseMasks(s);
                s.complete();
            }
            catch (ServerError e) {
                log.warn("Error while populating MIAS overlays.", e);
            }
        }
    }

    private int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }

    private List<Long> pixelIds() {
        ArrayList<Long> pixelsIds = new ArrayList<Long>(this.pixList.size());
        for (Pixels pixels : this.pixList) {
            pixelsIds.add(pixels.getId().getValue());
        }
        return pixelsIds;
    }

    private void notifyObservers(Object ... args) {
    }
}

