/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Date;
import ome.conditions.InternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMaker {
    private static final Logger log = LoggerFactory.getLogger(FileMaker.class);
    private final Object[] mutex = new Object[0];
    private final String repoDir;
    private String dbUuid;
    private File repoUuidFile;
    private File dotLockFile;
    private RandomAccessFile repoUuidRaf;
    private RandomAccessFile dotLockRaf;
    private FileLock lock;

    public FileMaker(String repoDir) {
        this.repoDir = repoDir;
    }

    public String getDir() {
        return this.repoDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsInit() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dbUuid == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String dbUuid) throws Exception {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.dbUuid != null) {
                throw new InternalException("Already initialized");
            }
            this.dbUuid = dbUuid;
            File mountDir = new File(this.repoDir);
            File omeroDir = new File(mountDir, ".omero");
            File repoCfg = new File(omeroDir, "repository");
            File uuidDir = new File(repoCfg, dbUuid);
            if (!uuidDir.exists()) {
                uuidDir.mkdirs();
                log.info("Creating " + uuidDir);
            }
            this.repoUuidFile = new File(uuidDir, "repo_uuid");
            this.dotLockFile = new File(uuidDir, ".lock");
            this.repoUuidRaf = new RandomAccessFile(this.repoUuidFile, "rw");
            this.dotLockRaf = new RandomAccessFile(this.dotLockFile, "rw");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLine() throws Exception {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.dbUuid == null) {
                throw new InternalException("Not initialized");
            }
            this.lock = this.dotLockRaf.getChannel().lock();
            this.dotLockRaf.seek(0L);
            this.dotLockRaf.writeUTF(new Date().toString());
            String line = null;
            try {
                this.repoUuidRaf.seek(0L);
                line = this.repoUuidRaf.readUTF();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(String line) throws Exception {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.dbUuid == null) {
                throw new InternalException("Not initialized");
            }
            this.repoUuidRaf.seek(0L);
            this.repoUuidRaf.writeUTF(line);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.dbUuid == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (this.lock != null) {
                    this.lock.release();
                }
            }
            catch (IOException e) {
                log.warn("Failed to release lock");
            }
            try {
                if (this.repoUuidRaf != null) {
                    this.repoUuidRaf.close();
                }
            }
            catch (IOException e) {
                log.warn("Failed to close repo_uuid");
            }
            try {
                if (this.dotLockRaf != null) {
                    this.dotLockRaf.close();
                }
            }
            catch (IOException e) {
                log.warn("Failed to close .lock");
            }
            this.dbUuid = null;
            this.repoUuidFile = null;
            if (!this.dotLockFile.delete()) {
                log.warn("Failed to delete lock file: " + this.dotLockFile.getAbsolutePath());
            }
            this.dotLockFile = null;
            this.repoUuidRaf = null;
            this.dotLockRaf = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

