/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.measurements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.api.local.LocalUpdate;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.roi.Ellipse;
import ome.model.roi.Roi;
import ome.services.blitz.measurements.OmeroMeasurementStore;
import ome.services.blitz.measurements.SmartColumns;
import omero.ApiUsageException;
import omero.RType;
import omero.ServerError;
import omero.grid.TablePrx;
import omero.rtypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementStore
implements OmeroMeasurementStore {
    private static final Logger log = LoggerFactory.getLogger(MeasurementStore.class);
    private final Map<String, IObject> lsidMap = new HashMap<String, IObject>();
    private final List<Long> roiIds = new ArrayList<Long>();
    private final LocalUpdate update;
    private final TablePrx table;
    private Map<String, Object> metadata;
    private String[] headers;
    private String[] idTypes;
    private Class[] types;
    private SmartColumns cols;
    private Object[][] rows;
    private boolean initialized = false;

    public MeasurementStore(LocalUpdate update, TablePrx table) throws ServerError {
        this.table = table;
        this.update = update;
    }

    @Override
    public void initialize(String[] headers, String[] idTypes, Class[] types, Map<String, Object> metadata) throws ServerError {
        if (this.initialized) {
            throw new ApiUsageException(null, null, "Already initialized.");
        }
        this.metadata = metadata;
        this.headers = headers;
        this.idTypes = idTypes;
        this.types = types;
        this.cols = new SmartColumns(this.lsidMap, headers, idTypes, types);
        this.table.initialize(this.cols.asArray());
        HashMap<String, RType> dict = new HashMap<String, RType>();
        if (metadata != null) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                dict.put(entry.getKey(), rtypes.rtype(entry.getValue()));
            }
            this.table.setAllMetadata(dict);
        }
        this.initialized = true;
    }

    @Override
    public void addObject(String lsid, IObject obj) {
        if (lsid != null) {
            if (obj == null) {
                this.lsidMap.remove(lsid);
            } else {
                this.lsidMap.put(lsid, obj);
            }
        }
    }

    @Override
    public void addObjects(Map<String, IObject> map) {
        if (map != null) {
            this.lsidMap.putAll(map);
        }
    }

    @Override
    public void addRows(Object[][] rows) throws ServerError {
        if (rows != null) {
            throw new ApiUsageException(null, null, "Call save before adding more data");
        }
        this.rows = rows;
    }

    @Override
    public void addCircle(String roiLsid, double x, double y, double r) throws ServerError {
        Roi roi = new Roi();
        Ellipse ellipse = new Ellipse();
        ellipse.setX(x);
        ellipse.setY(y);
        ellipse.setRadiusX(r);
        ellipse.setRadiusY(r);
        roi.addShape(ellipse);
        this.appendRoi(roiLsid, roi);
    }

    private void appendRoi(String lsid, Roi roi) throws ServerError {
        Image image = null;
        IObject obj = this.lsidMap.get(lsid);
        if (obj instanceof Image) {
            image = (Image)obj;
        }
        if (image == null || image.getId() == null) {
            throw new ApiUsageException(null, null, "No image set; cannot create Roi");
        }
        roi.setImage(image);
        this.lsidMap.put(lsid, roi);
    }

    @Override
    public void save() throws Exception {
        if (!this.initialized) {
            throw new ApiUsageException(null, null, "Not initialized");
        }
        ArrayList<IObject> unsaved = new ArrayList<IObject>();
        for (Map.Entry<String, IObject> entry : this.lsidMap.entrySet()) {
            unsaved.add(entry.getValue());
        }
        if (unsaved.size() > 0) {
            IObject[] objs = unsaved.toArray(new IObject[unsaved.size()]);
            List<Long> ids = this.update.saveAndReturnIds(objs);
            for (int i = 0; i < ids.size(); ++i) {
                ((IObject)unsaved.get(i)).setId(ids.get(i));
                ((IObject)unsaved.get(i)).unload();
                this.roiIds.add(ids.get(i));
            }
        }
        this.cols.fill(this.rows);
        this.table.addData(this.cols.asArray());
        this.rows = null;
    }

    @Override
    public List<Long> getRoiIds() {
        return this.roiIds;
    }

    @Override
    public TablePrx getTable() {
        return this.table;
    }
}

