/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Glacier2.SessionControlPrx;
import Ice.Current;
import Ice.Identity;
import Ice.Object;
import Ice.ObjectPrx;
import Ice.TieBase;
import Ice.UserException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import ome.api.IAdmin;
import ome.api.IShare;
import ome.api.local.LocalAdmin;
import ome.logic.HardWiredInterceptor;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.services.blitz.fire.AopContextInitializer;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.ApiUsageException;
import omero.InternalException;
import omero.SecurityViolation;
import omero.ServerError;
import omero.api.ClientCallbackPrx;
import omero.api.ExporterPrx;
import omero.api.ExporterPrxHelper;
import omero.api.IAdminPrx;
import omero.api.IAdminPrxHelper;
import omero.api.IConfigPrx;
import omero.api.IConfigPrxHelper;
import omero.api.IContainerPrx;
import omero.api.IContainerPrxHelper;
import omero.api.ILdapPrx;
import omero.api.ILdapPrxHelper;
import omero.api.IMetadataPrx;
import omero.api.IMetadataPrxHelper;
import omero.api.IPixelsPrx;
import omero.api.IPixelsPrxHelper;
import omero.api.IProjectionPrx;
import omero.api.IProjectionPrxHelper;
import omero.api.IQueryPrx;
import omero.api.IQueryPrxHelper;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRenderingSettingsPrxHelper;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRepositoryInfoPrxHelper;
import omero.api.IRoiPrx;
import omero.api.IRoiPrxHelper;
import omero.api.IScriptPrx;
import omero.api.IScriptPrxHelper;
import omero.api.ISessionPrx;
import omero.api.ISessionPrxHelper;
import omero.api.ISharePrx;
import omero.api.ISharePrxHelper;
import omero.api.ITimelinePrx;
import omero.api.ITimelinePrxHelper;
import omero.api.ITypesPrx;
import omero.api.ITypesPrxHelper;
import omero.api.IUpdatePrx;
import omero.api.IUpdatePrxHelper;
import omero.api.JobHandlePrx;
import omero.api.JobHandlePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawFileStorePrxHelper;
import omero.api.RawPixelsStorePrx;
import omero.api.RawPixelsStorePrxHelper;
import omero.api.RenderingEnginePrx;
import omero.api.RenderingEnginePrxHelper;
import omero.api.SearchPrx;
import omero.api.SearchPrxHelper;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.api.ServiceInterfacePrx;
import omero.api.ServiceInterfacePrxHelper;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrxHelper;
import omero.api.ThumbnailStorePrx;
import omero.api.ThumbnailStorePrxHelper;
import omero.api._ServiceFactoryOperations;
import omero.cmd.SessionI;
import omero.grid.SharedResourcesPrx;
import omero.grid.SharedResourcesPrxHelper;
import omero.util.IceMapper;
import omero.util.ServantHolder;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public final class ServiceFactoryI
extends SessionI
implements _ServiceFactoryOperations {
    private static final Logger log = LoggerFactory.getLogger(ServiceFactoryI.class);
    final TopicManager topicManager;
    final Registry registry;
    final List<HardWiredInterceptor> cptors;
    final AopContextInitializer initializer;

    public ServiceFactoryI(Current current, ServantHolder holder, SessionControlPrx control, OmeroContext context, SessionManager manager, Executor executor, Principal p, List<HardWiredInterceptor> interceptors, TopicManager topicManager, Registry registry) throws ApiUsageException {
        this(false, current, holder, control, context, manager, executor, p, interceptors, topicManager, registry, null);
    }

    public ServiceFactoryI(boolean reusedSession, Current current, ServantHolder holder, SessionControlPrx control, OmeroContext context, SessionManager manager, Executor executor, Principal p, List<HardWiredInterceptor> interceptors, TopicManager topicManager, Registry registry, String token) throws ApiUsageException {
        super(reusedSession, current, holder, control, context, manager, executor, p, token);
        this.cptors = interceptors;
        this.initializer = new AopContextInitializer(new ServiceFactory(this.context), this.principal, this.reusedSession);
        this.topicManager = topicManager;
        this.registry = registry;
    }

    public ServiceFactoryPrx proxy() {
        return ServiceFactoryPrxHelper.uncheckedCast(this.adapter.createDirectProxy(this.sessionId()));
    }

    @Override
    public List<omero.model.IObject> getSecurityContexts(Current __current) throws ServerError {
        final EventContext ec = this.getEventContext();
        List objs = (List)this.executor.execute(this.principal, new Executor.SimpleWork(this, "getSecurityContext", new java.lang.Object[0]){

            @Transactional(readOnly=true)
            public java.lang.Object doWork(Session session, ServiceFactory sf) {
                IAdmin admin = sf.getAdminService();
                IShare share = sf.getShareService();
                ArrayList<IGlobal> objs = new ArrayList<IGlobal>();
                HashSet<Long> added = new HashSet<Long>();
                for (Long id : ec.getMemberOfGroupsList()) {
                    objs.add(admin.getGroup(id));
                    added.add(id);
                }
                for (Long id : ec.getLeaderOfGroupsList()) {
                    if (added.contains(id)) continue;
                    objs.add(admin.getGroup(id));
                }
                objs.addAll(share.getMemberShares(true));
                objs.addAll(share.getOwnShares(true));
                return objs;
            }
        });
        IceMapper mapper = new IceMapper();
        return (List)mapper.map(objs);
    }

    @Override
    public omero.model.IObject setSecurityContext(omero.model.IObject obj, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper();
        try {
            IObject iobj = (IObject)mapper.reverse(obj);
            IObject old = this.sessionManager.setSecurityContext(this.principal, iobj);
            return (omero.model.IObject)((java.lang.Object)mapper.map(old));
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @Override
    public void setSecurityPassword(String password, Current __current) throws ServerError {
        EventContext ec = this.getEventContext();
        String name = ec.getCurrentUserName();
        boolean ok = this.sessionManager.executePasswordCheck(name, password);
        if (!ok) {
            String msg = "Bad password for " + name;
            log.info("setSecurityPassword: " + msg);
            throw new SecurityViolation(null, null, "Bad password for " + name);
        }
        this.reusedSession.set(false);
    }

    protected ServerError handleException(Throwable t) {
        IceMapper mapper = new IceMapper();
        UserException iue = mapper.handleException(t, this.context);
        if (iue instanceof ServerError) {
            return (ServerError)iue;
        }
        InternalException iu = new InternalException();
        iu.initCause(t);
        IceMapper.fillServerError(iu, t);
        return iu;
    }

    @Override
    public IAdminPrx getAdminService(Current current) throws ServerError {
        return IAdminPrxHelper.uncheckedCast(this.getByName("omero.api.IAdmin", current));
    }

    @Override
    public IConfigPrx getConfigService(Current current) throws ServerError {
        return IConfigPrxHelper.uncheckedCast(this.getByName("omero.api.IConfig", current));
    }

    @Override
    public ILdapPrx getLdapService(Current current) throws ServerError {
        return ILdapPrxHelper.uncheckedCast(this.getByName("omero.api.ILdap", current));
    }

    @Override
    public IPixelsPrx getPixelsService(Current current) throws ServerError {
        return IPixelsPrxHelper.uncheckedCast(this.getByName("omero.api.IPixels", current));
    }

    @Override
    public IContainerPrx getContainerService(Current current) throws ServerError {
        return IContainerPrxHelper.uncheckedCast(this.getByName("omero.api.IContainer", current));
    }

    @Override
    public IProjectionPrx getProjectionService(Current current) throws ServerError {
        return IProjectionPrxHelper.uncheckedCast(this.getByName("omero.api.IProjection", current));
    }

    @Override
    public IQueryPrx getQueryService(Current current) throws ServerError {
        return IQueryPrxHelper.uncheckedCast(this.getByName("omero.api.IQuery", current));
    }

    @Override
    public IRoiPrx getRoiService(Current current) throws ServerError {
        ServiceInterfacePrx prx = this.getByName("omero.api.IRoi", current);
        return IRoiPrxHelper.uncheckedCast(prx);
    }

    @Override
    public IScriptPrx getScriptService(Current current) throws ServerError {
        ServiceInterfacePrx prx = this.getByName("omero.api.IScript", current);
        return IScriptPrxHelper.uncheckedCast(prx);
    }

    @Override
    public ISessionPrx getSessionService(Current current) throws ServerError {
        return ISessionPrxHelper.uncheckedCast(this.getByName("omero.api.ISession", current));
    }

    @Override
    public ISharePrx getShareService(Current current) throws ServerError {
        return ISharePrxHelper.uncheckedCast(this.getByName("omero.api.IShare", current));
    }

    @Override
    public ITimelinePrx getTimelineService(Current current) throws ServerError {
        return ITimelinePrxHelper.uncheckedCast(this.getByName("omero.api.ITimeline", current));
    }

    @Override
    public ITypesPrx getTypesService(Current current) throws ServerError {
        return ITypesPrxHelper.uncheckedCast(this.getByName("omero.api.ITypes", current));
    }

    @Override
    public IUpdatePrx getUpdateService(Current current) throws ServerError {
        ServiceInterfacePrx prx = this.getByName("omero.api.IUpdate", current);
        return IUpdatePrxHelper.uncheckedCast(prx);
    }

    @Override
    public IRenderingSettingsPrx getRenderingSettingsService(Current current) throws ServerError {
        return IRenderingSettingsPrxHelper.uncheckedCast(this.getByName("omero.api.IRenderingSettings", current));
    }

    @Override
    public IRepositoryInfoPrx getRepositoryInfoService(Current current) throws ServerError {
        return IRepositoryInfoPrxHelper.uncheckedCast(this.getByName("omero.api.IRepositoryInfo", current));
    }

    @Override
    public IMetadataPrx getMetadataService(Current current) throws ServerError {
        return IMetadataPrxHelper.uncheckedCast(this.getByName("omero.api.IMetadata", current));
    }

    @Override
    public ExporterPrx createExporter(Current current) throws ServerError {
        return ExporterPrxHelper.uncheckedCast(this.createByName("omero.api.Exporter", current));
    }

    @Override
    public JobHandlePrx createJobHandle(Current current) throws ServerError {
        return JobHandlePrxHelper.uncheckedCast(this.createByName("omero.api.JobHandle", current));
    }

    @Override
    public RenderingEnginePrx createRenderingEngine(Current current) throws ServerError {
        return RenderingEnginePrxHelper.uncheckedCast(this.createByName("omero.api.RenderingEngine", current));
    }

    @Override
    public RawFileStorePrx createRawFileStore(Current current) throws ServerError {
        return RawFileStorePrxHelper.uncheckedCast(this.createByName("omero.api.RawFileStore", current));
    }

    @Override
    public RawPixelsStorePrx createRawPixelsStore(Current current) throws ServerError {
        return RawPixelsStorePrxHelper.uncheckedCast(this.createByName("omero.api.RawPixelsStore", current));
    }

    @Override
    public SearchPrx createSearchService(Current current) throws ServerError {
        return SearchPrxHelper.uncheckedCast(this.createByName("omero.api.Search", current));
    }

    @Override
    public ThumbnailStorePrx createThumbnailStore(Current current) throws ServerError {
        return ThumbnailStorePrxHelper.uncheckedCast(this.createByName("omero.api.ThumbnailStore", current));
    }

    @Override
    public SharedResourcesPrx sharedResources(Current current) throws ServerError {
        return SharedResourcesPrxHelper.uncheckedCast(this.getByName("omero.grid.SharedResources", current));
    }

    public TieBase getTie(Identity id) {
        return (TieBase)((java.lang.Object)this.holder.get(id));
    }

    public java.lang.Object getServant(Identity id) {
        return this.holder.getUntied(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInterfacePrx getByName(String blankname, Current dontUse) throws ServerError {
        Identity immediateId = this.holder.getIdentity(blankname);
        if (this.holder.get(immediateId) != null) {
            return ServiceInterfacePrxHelper.uncheckedCast(this.adapter.createDirectProxy(immediateId));
        }
        String idName = this.clientId + blankname;
        Identity id = this.holder.getIdentity(idName);
        this.holder.acquireLock(idName);
        try {
            ObjectPrx prx;
            Object servant = this.holder.get(id);
            if (servant == null) {
                servant = this.createServantDelegate(blankname);
                prx = this.registerServant(id, servant);
            } else {
                prx = this.adapter.createDirectProxy(id);
            }
            ServiceInterfacePrx serviceInterfacePrx = ServiceInterfacePrxHelper.uncheckedCast(prx);
            return serviceInterfacePrx;
        }
        finally {
            this.holder.releaseLock(idName);
        }
    }

    @Override
    public StatefulServiceInterfacePrx createByName(String name, Current current) throws ServerError {
        Identity id = this.holder.getIdentity(UUID.randomUUID().toString() + name);
        if (null != this.adapter.find(id)) {
            InternalException ie = new InternalException();
            ie.message = name + " already registered for this adapter.";
        }
        Object servant = this.createServantDelegate(name);
        ObjectPrx prx = this.registerServant(id, servant);
        return StatefulServiceInterfacePrxHelper.uncheckedCast(prx);
    }

    @Override
    public void subscribe(String topicName, ObjectPrx prx, Current __current) throws ServerError {
        if (topicName == null || !topicName.startsWith("/public/")) {
            throw new ApiUsageException(null, null, "Currently only \"/public/\" topics allowed.");
        }
        this.topicManager.register(topicName, prx, false);
        log.info("Registered " + prx + " for " + topicName);
    }

    @Override
    public void setCallback(ClientCallbackPrx callback, Current current) throws ServerError {
    }

    @Override
    public void detachOnDestroy(Current current) {
        this.doClose = false;
    }

    @Override
    public void closeOnDestroy(Current current) {
        this.doClose = true;
    }

    public String getStatefulServiceCount() {
        return this.holder.getStatefulServiceCount();
    }

    @Override
    public List<String> activeServices(Current __current) {
        return this.holder.getServantList();
    }

    public EventContext getEventContext() {
        return this.sessionManager.getEventContext(this.principal);
    }

    public EventContext getEventContext(Current current) {
        return (EventContext)this.executor.execute(current.ctx, this.principal, new Executor.SimpleWork(this, "getEventContext", new java.lang.Object[0]){

            @Transactional(readOnly=true)
            public java.lang.Object doWork(Session session, ServiceFactory sf) {
                return ((LocalAdmin)sf.getAdminService()).getEventContextQuiet();
            }
        });
    }

    @Override
    public long keepAllAlive(ServiceInterfacePrx[] proxies, Current __current) throws ServerError {
        try {
            this.getEventContext();
            if (log.isDebugEnabled()) {
                log.debug("Keep all alive: " + this);
            }
            if (proxies == null || proxies.length == 0) {
                return -1L;
            }
            long retVal = 0L;
            for (int i = 0; i < proxies.length; ++i) {
                Identity id;
                ServiceInterfacePrx prx = proxies[i];
                if (prx == null || null != this.holder.get(id = prx.ice_getIdentity())) continue;
                retVal |= (long)(1 << i);
            }
            return retVal;
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    @Override
    public boolean keepAlive(ServiceInterfacePrx proxy, Current __current) throws ServerError {
        try {
            this.getEventContext();
            if (log.isDebugEnabled()) {
                log.debug("Keep alive: " + this);
            }
            if (proxy == null) {
                return false;
            }
            Identity id = proxy.ice_getIdentity();
            return null != this.holder.get(id);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    @Override
    protected void internalServantConfig(java.lang.Object obj) throws ServerError {
        super.internalServantConfig(obj);
        if (obj instanceof ServiceFactoryAware) {
            ((ServiceFactoryAware)obj).setServiceFactory(this);
        }
        if (obj instanceof AbstractAmdServant) {
            AbstractAmdServant amd = (AbstractAmdServant)obj;
            amd.applyHardWiredInterceptors(this.cptors, this.initializer);
            amd.setHolder(this.holder);
        }
    }
}

