/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import ome.api.IUpdate;
import ome.api.RawFileStore;
import ome.model.enums.ChecksumAlgorithm;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import ome.security.basic.OmeroInterceptor;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ProcessorCallbackI;
import ome.services.blitz.impl.ScriptProcessI;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ParamsCache;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.scripts.RepoFile;
import ome.services.scripts.ScriptRepoHelper;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RInt;
import omero.RType;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.ServerError;
import omero.ValidationException;
import omero.api.AMD_IScript_canRunScript;
import omero.api.AMD_IScript_deleteScript;
import omero.api.AMD_IScript_editScript;
import omero.api.AMD_IScript_getParams;
import omero.api.AMD_IScript_getScriptID;
import omero.api.AMD_IScript_getScriptText;
import omero.api.AMD_IScript_getScriptWithDetails;
import omero.api.AMD_IScript_getScripts;
import omero.api.AMD_IScript_getScriptsByMimetype;
import omero.api.AMD_IScript_getUserScripts;
import omero.api.AMD_IScript_runScript;
import omero.api.AMD_IScript_uploadOfficialScript;
import omero.api.AMD_IScript_uploadScript;
import omero.api.AMD_IScript_validateScript;
import omero.api._IScriptOperations;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.JobParams;
import omero.grid.ParamsHelper;
import omero.grid.ProcessPrx;
import omero.grid.ProcessorPrx;
import omero.grid.ScriptProcessPrx;
import omero.grid._InteractiveProcessorOperations;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.IObject;
import omero.model.Job;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.ScriptJobI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class ScriptI
extends AbstractAmdServant
implements _IScriptOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Logger log = LoggerFactory.getLogger(ScriptI.class);
    protected ServiceFactoryI factory;
    protected ParamsCache cache;
    protected final ScriptRepoHelper scripts;
    protected final ACLVoter aclVoter;
    protected final OmeroInterceptor interceptor;
    protected final ChecksumProviderFactory cpf;

    public ScriptI(BlitzExecutor be, ScriptRepoHelper scripts, ACLVoter aclVoter, OmeroInterceptor interceptor, ChecksumProviderFactory cpf, ParamsCache cache) {
        super(null, be);
        this.scripts = scripts;
        this.aclVoter = aclVoter;
        this.interceptor = interceptor;
        this.cpf = cpf;
        this.cache = cache;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.factory = sf;
    }

    protected ParamsHelper.Acquirer acquirer() throws ServerError {
        return (ParamsHelper.Acquirer)this.factory.getServant(this.factory.sharedResources(null).ice_getIdentity());
    }

    @Override
    public void runScript_async(AMD_IScript_runScript __cb, final long scriptID, final Map<String, RType> inputs, final RInt waitSecs, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<ScriptProcessPrx>(){

            @Override
            public ScriptProcessPrx call() throws ServerError {
                ScriptJobI job = new ScriptJobI();
                job.linkOriginalFile(new OriginalFileI(scriptID, false));
                int timeout = 5;
                if (waitSecs != null) {
                    timeout = waitSecs.getValue();
                }
                InteractiveProcessorPrx ipPrx = ScriptI.this.acquirer().acquireProcessor(job, timeout, __current);
                _InteractiveProcessorOperations ip = (_InteractiveProcessorOperations)ScriptI.this.factory.getServant(ipPrx.ice_getIdentity());
                ProcessPrx proc = ip.execute(rtypes.rmap(inputs), __current);
                ScriptProcessI process = new ScriptProcessI(ScriptI.this.factory, __current, ipPrx, ip, proc);
                process.setApplicationContext((ApplicationContext)ScriptI.this.factory.context);
                process.setHolder(ScriptI.this.factory.holder);
                return process.getProxy();
            }
        });
    }

    @Override
    public void canRunScript_async(AMD_IScript_canRunScript __cb, final long scriptID, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Boolean>(){

            @Override
            public Boolean call() throws ServerError {
                if (ScriptI.this.scripts.isInRepo(scriptID)) {
                    return true;
                }
                ProcessorCallbackI callback = new ProcessorCallbackI(ScriptI.this.factory);
                callback.setApplicationContext((ApplicationContext)ScriptI.this.factory.context);
                callback.setHolder(ScriptI.this.factory.holder);
                ProcessorPrx server = callback.activateAndWait(__current);
                return server != null;
            }
        });
    }

    @Override
    public void getScriptID_async(AMD_IScript_getScriptID __cb, final String scriptPath, Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Long>(){

            @Override
            public Long call() {
                Long id = ScriptI.this.scripts.findInDb(scriptPath, true);
                if (id == null) {
                    return -1L;
                }
                return id;
            }
        });
    }

    private void assertCanWriteFiles(Current __current) throws SecurityViolation {
        boolean allowCreation = false;
        try {
            allowCreation = (Boolean)this.factory.executor.execute(__current.ctx, this.factory.principal, new Executor.SimpleWork(this, "uploadScript-prep", new Object[0]){

                @Transactional(readOnly=true)
                public Boolean doWork(Session session, ServiceFactory sf) {
                    ome.model.core.OriginalFile file2 = new ome.model.core.OriginalFile();
                    try {
                        ScriptI.this.interceptor.newTransientDetails(file2);
                    }
                    catch (ome.conditions.SecurityViolation sv) {
                        return false;
                    }
                    return ScriptI.this.aclVoter.allowCreation(file2);
                }
            });
        }
        catch (ome.conditions.SecurityViolation securityViolation) {
            // empty catch block
        }
        if (!allowCreation) {
            throw new SecurityViolation(null, null, "No permission to upload script");
        }
    }

    @Override
    public void uploadScript_async(AMD_IScript_uploadScript __cb, final String path, final String scriptText, final Current __current) throws ServerError {
        this.assertCanWriteFiles(__current);
        this.safeRunnableCall(__current, __cb, false, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                ome.model.core.OriginalFile file2 = ScriptI.this.makeFile(path, scriptText, __current);
                file2 = ScriptI.this.writeContent(file2, scriptText, __current);
                ScriptI.this.validateParams(__current, file2);
                return file2.getId();
            }
        });
    }

    @Override
    public void uploadOfficialScript_async(AMD_IScript_uploadOfficialScript __cb, final String path, final String scriptText, final Current __current) throws ServerError {
        this.assertCanWriteFiles(__current);
        this.safeRunnableCall(__current, __cb, false, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                EventContext ec = ScriptI.this.factory.getEventContext();
                if (!ec.isCurrentUserAdmin()) {
                    throw new SecurityViolation(null, null, "User is not an administrator");
                }
                try {
                    RepoFile f;
                    ome.model.core.OriginalFile file2;
                    Long scriptID = ScriptI.this.scripts.findInDb(path, true);
                    Long fileID = ScriptI.this.scripts.findInDb(path, false);
                    if (scriptID != null) {
                        throw new ApiUsageException(null, null, "Path already exists: " + path + "\nUse editScript to modify existing official scripts.");
                    }
                    if (fileID != null) {
                        log.info("Overwriting existing non-script: " + fileID);
                        ScriptI.this.cache.removeParams(fileID);
                    }
                    if (!ScriptI.this.scripts.isInert(file2 = ScriptI.this.scripts.addOrReplace(f = ScriptI.this.scripts.write(path, scriptText), fileID))) {
                        ScriptI.this.validateParams(__current, file2);
                    }
                    return file2.getId();
                }
                catch (IOException e) {
                    InternalException se = new InternalException(null, null, "Cannot write " + path);
                    IceMapper.fillServerError(se, e);
                    throw se;
                }
            }
        });
    }

    @Override
    public void editScript_async(AMD_IScript_editScript __cb, final OriginalFile fileObject, final String scriptText, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, true, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (fileObject == null) {
                    throw new ApiUsageException(null, null, "file object cannot be null");
                }
                ome.model.core.OriginalFile file2 = null;
                if (fileObject.isLoaded()) {
                    IceMapper mapper = new IceMapper();
                    file2 = (ome.model.core.OriginalFile)mapper.reverse(fileObject);
                } else {
                    file2 = ScriptI.this.getOriginalFileOrNull(fileObject.getId().getValue(), __current);
                }
                if (file2 == null) {
                    throw new ApiUsageException(null, null, "could not find file: " + fileObject.getId().getValue());
                }
                ScriptI.this.scripts.setMimetype(file2);
                file2 = ScriptI.this.updateFile(file2, __current);
                ome.model.core.OriginalFile official = ScriptI.this.scripts.load(file2.getId(), true);
                if (official != null) {
                    String fullname = official.getPath() + official.getName();
                    RepoFile f = ScriptI.this.scripts.write(fullname, scriptText);
                    file2 = ScriptI.this.scripts.update(f, file2.getId(), __current.ctx);
                } else {
                    file2 = ScriptI.this.writeContent(file2, scriptText, __current);
                }
                ScriptI.this.cache.removeParams(file2.getId());
                ScriptI.this.validateParams(__current, file2);
                return null;
            }
        });
    }

    @Override
    public void getScriptWithDetails_async(AMD_IScript_getScriptWithDetails __cb, final long id, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ome.model.core.OriginalFile file2 = ScriptI.this.getOriginalFileOrNull(id, __current);
                if (file2 == null) {
                    return null;
                }
                HashMap<String, RType> scr = new HashMap<String, RType>();
                scr.put(ScriptI.this.loadText(file2, __current), new IceMapper().toRType(file2));
                return scr;
            }
        });
    }

    private String loadText(final ome.model.core.OriginalFile file2, Current current) throws ServerError {
        if (this.scripts.isInRepo(file2.getId())) {
            try {
                return this.scripts.read(file2.getPath() + file2.getName());
            }
            catch (IOException e) {
                ResourceError re = new ResourceError(null, null, "Failed to load " + file2);
                IceMapper.fillServerError(re, e);
                throw re;
            }
        }
        Long size = file2.getSize();
        if (size == null || size > Integer.MAX_VALUE || size < 0L) {
            throw new ValidationException(null, null, "Script size : " + size + " invalid on Blitz.OMERO server.");
        }
        return (String)this.factory.executor.execute(current.ctx, this.factory.principal, new Executor.SimpleWork(this, "getScriptWithDetails", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                try (RawFileStore rawFileStore = sf.createRawFileStore();){
                    String script;
                    rawFileStore.setFileId(file2.getId());
                    String string = script = new String(rawFileStore.read(0L, (int)file2.getSize().longValue()));
                    return string;
                }
            }
        });
    }

    @Override
    public void getScriptText_async(AMD_IScript_getScriptText __cb, final long id, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ome.model.core.OriginalFile file2 = ScriptI.this.getOriginalFileOrNull(id, __current);
                if (file2 == null) {
                    return null;
                }
                return ScriptI.this.loadText(file2, __current);
            }
        });
    }

    @Override
    public void getParams_async(AMD_IScript_getParams __cb, final long id, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ome.model.core.OriginalFile file2 = ScriptI.this.getOriginalFileOrNull(id, __current);
                if (file2 == null) {
                    return null;
                }
                return ScriptI.this.cache.getParams(id, file2.getHash(), __current);
            }
        });
    }

    @Override
    public void getScripts_async(AMD_IScript_getScripts __cb, Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<ome.model.core.OriginalFile> files = ScriptI.this.scripts.loadAll(true);
                IceMapper mapper = new IceMapper();
                return mapper.map(files);
            }
        });
    }

    @Override
    public void getScriptsByMimetype_async(AMD_IScript_getScriptsByMimetype __cb, final String mimetype, Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<ome.model.core.OriginalFile> files = ScriptI.this.scripts.loadAll(true, mimetype);
                IceMapper mapper = new IceMapper();
                return mapper.map(files);
            }
        });
    }

    @Override
    public void getUserScripts_async(AMD_IScript_getUserScripts __cb, final List<IObject> acceptsList, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<Long> officialIds;
                final QueryBuilder qb = new QueryBuilder();
                qb.select("o").from("OriginalFile", "o");
                if (!ScriptI.this.parseAcceptsList(qb, acceptsList)) {
                    long gid = ScriptI.this.factory.sessionManager.getEventContext(ScriptI.this.factory.principal).getCurrentGroupId();
                    qb.and("o.details.group.id = " + gid);
                }
                if ((officialIds = ScriptI.this.scripts.idsInDb()) != null && officialIds.size() > 0) {
                    qb.and("o.id not in (:ids) ");
                    qb.paramList("ids", officialIds);
                }
                List files = (List)ScriptI.this.factory.executor.execute(__current.ctx, ScriptI.this.factory.principal, new Executor.SimpleWork(this, "getUserScripts", new Object[0]){

                    @Transactional(readOnly=true)
                    public Object doWork(Session session, ServiceFactory sf) {
                        return qb.query(session).list();
                    }
                });
                IceMapper mapper = new IceMapper();
                return mapper.map(files);
            }
        });
    }

    @Override
    public void validateScript_async(AMD_IScript_validateScript __cb, final Job j, final List<IObject> acceptsList, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, __cb, false, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final boolean official = acceptsList != null && acceptsList.size() == 0;
                final QueryBuilder qb = new QueryBuilder();
                qb.select("o").from("Job", "j");
                qb.join("j.originalFileLinks", "links", false, false);
                qb.join("links.child", "o", false, false);
                ScriptI.this.parseAcceptsList(qb, acceptsList);
                qb.and("j.id = :id");
                qb.param("id", (Object)j.getId().getValue());
                ome.model.core.OriginalFile file2 = (ome.model.core.OriginalFile)ScriptI.this.factory.executor.execute(__current.ctx, ScriptI.this.factory.principal, new Executor.SimpleWork(this, "validateScript", new Object[]{j.getId().getValue(), acceptsList}){

                    @Transactional(readOnly=true)
                    public Object doWork(Session session, ServiceFactory sf) {
                        List files = qb.query(session).list();
                        if (files.size() != 1) {
                            throw new ome.conditions.ValidationException("Found wrong number of files: " + files);
                        }
                        Long id = ((ome.model.core.OriginalFile)files.get(0)).getId();
                        if (official) {
                            return ScriptI.this.scripts.load(id, session, this.getSqlAction(), true);
                        }
                        return sf.getQueryService().get(ome.model.core.OriginalFile.class, id);
                    }
                });
                return new IceMapper().map(file2);
            }
        });
    }

    @Override
    public void deleteScript_async(AMD_IScript_deleteScript cb, final long id, final Current __current) throws ServerError {
        this.safeRunnableCall(__current, cb, true, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final ome.model.core.OriginalFile file2 = ScriptI.this.getOriginalFileOrNull(id, __current);
                if (file2 == null) {
                    throw new ApiUsageException(null, null, "No script with id " + id + " on server.");
                }
                boolean allowDelete = (Boolean)ScriptI.this.factory.executor.execute(__current.ctx, ScriptI.this.factory.principal, new Executor.SimpleWork(this, "deleteScript-prep", new Object[0]){

                    @Transactional(readOnly=true)
                    public Boolean doWork(Session session, ServiceFactory sf) {
                        return ScriptI.this.aclVoter.allowDelete(file2, file2.getDetails());
                    }
                });
                if (!allowDelete) {
                    throw new SecurityViolation(null, null, "No permission to delete script with id " + id);
                }
                ScriptI.this.deleteOriginalFile(file2, __current);
                ScriptI.this.factory.executor.execute(__current.ctx, ScriptI.this.factory.principal, new Executor.SimpleWork(this, "deleteScript", new Object[0]){

                    @Transactional(readOnly=false)
                    public Object doWork(Session session, ServiceFactory sf) {
                        for (ome.model.IObject foundLink : sf.getQueryService().findAllByQuery("FROM JobOriginalFileLink WHERE child.id = :id", new Parameters().addId(id))) {
                            session.delete((Object)foundLink);
                        }
                        session.delete((Object)file2);
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private boolean parseAcceptsList(QueryBuilder qb, List<IObject> acceptsList) {
        qb.where();
        this.scripts.buildQuery(qb);
        if (acceptsList != null && acceptsList.size() > 0) {
            for (IObject object : acceptsList) {
                if (object instanceof Experimenter) {
                    qb.and("o.details.owner.id = :oid");
                    qb.param("oid", (Object)object.getId().getValue());
                    continue;
                }
                if (object instanceof ExperimenterGroup) {
                    qb.and("o.details.group.id = :gid");
                    qb.param("gid", (Object)object.getId().getValue());
                    continue;
                }
                throw new ome.conditions.ValidationException("Unsupported accept-type: " + object);
            }
            return true;
        }
        return false;
    }

    private ome.model.core.OriginalFile makeFile(String path, String script, Current current) throws ServerError {
        ome.model.core.OriginalFile file2 = new ome.model.core.OriginalFile();
        file2.setName(FilenameUtils.getName(path));
        file2.setPath(FilenameUtils.getFullPath(path));
        file2.setSize(Long.valueOf(script.getBytes().length));
        file2.setHasher(new ChecksumAlgorithm("SHA1-160"));
        file2.setHash(this.cpf.getProvider(ChecksumType.SHA1).putBytes(script.getBytes()).checksumAsString());
        this.scripts.setMimetype(file2);
        return this.updateFile(file2, current);
    }

    private ome.model.core.OriginalFile updateFile(final ome.model.core.OriginalFile file2, Current current) throws ServerError {
        ome.model.core.OriginalFile updatedFile = (ome.model.core.OriginalFile)this.factory.executor.execute(current.ctx, this.factory.principal, new Executor.SimpleWork(this, "updateFile", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                IUpdate update = sf.getUpdateService();
                file2.getDetails().setUpdateEvent(null);
                return update.saveAndReturnObject(file2);
            }
        });
        return updatedFile;
    }

    private ome.model.core.OriginalFile writeContent(final ome.model.core.OriginalFile file2, final String script, Current current) throws ServerError {
        return (ome.model.core.OriginalFile)this.factory.executor.execute(current.ctx, this.factory.principal, new Executor.SimpleWork(this, "writeContent", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                byte[] buf = script.getBytes();
                try (RawFileStore rawFileStore = sf.createRawFileStore();){
                    rawFileStore.setFileId(file2.getId());
                    rawFileStore.truncate(buf.length);
                    rawFileStore.write(buf, 0L, buf.length);
                    ome.model.core.OriginalFile originalFile = rawFileStore.save();
                    return originalFile;
                }
            }
        });
    }

    private void deleteOriginalFile(ome.model.core.OriginalFile file2, Current current) throws ServerError {
        if (file2 == null) {
            return;
        }
        if (this.scripts.delete(file2.getId())) {
            return;
        }
        this.scripts.simpleDelete(current.ctx, this.factory.executor, this.factory.principal, file2.getId());
    }

    private ome.model.core.OriginalFile getOriginalFileOrNull(long id, Current current) {
        try {
            final QueryBuilder qb = new QueryBuilder();
            qb.select("o").from("OriginalFile", "o");
            qb.where();
            this.scripts.buildQuery(qb);
            qb.and("o.id = :id");
            qb.param("id", (Object)id);
            ome.model.core.OriginalFile file2 = (ome.model.core.OriginalFile)this.factory.executor.execute(current.ctx, this.factory.principal, new Executor.SimpleWork(this, "getOriginalFileOrNull", new Object[]{id}){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return qb.query(session).uniqueResult();
                }
            });
            return file2;
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    private void validateParams(Current __current, ome.model.core.OriginalFile file2) throws ServerError, ApiUsageException {
        try {
            JobParams params = this.cache.getParams(file2.getId(), file2.getHash(), __current);
            if (params == null) {
                throw new ApiUsageException(null, null, "Script error: no params found.");
            }
        }
        catch (ResourceError params) {
        }
        catch (ValidationException ve) {
            file2.setMimetype("text/plain");
            file2 = this.updateFile(file2, __current);
            throw ve;
        }
        catch (Exception e) {
            log.warn("Unexpected exception on validateParams", e);
        }
    }
}

