/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.NoEndpointException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UnknownException;
import Ice.UserException;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import IceStorm.AlreadySubscribed;
import IceStorm.BadQoS;
import IceStorm.NoSuchTopic;
import IceStorm.TopicExists;
import IceStorm.TopicManagerPrx;
import IceStorm.TopicManagerPrxHelper;
import IceStorm.TopicPrx;
import java.lang.reflect.Method;
import omero.ApiUsageException;
import omero.InternalException;
import omero.ServerError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public interface TopicManager
extends ApplicationListener {
    public void register(String var1, ObjectPrx var2, boolean var3) throws ServerError;

    public void unregister(String var1, ObjectPrx var2) throws ServerError;

    public static final class Impl
    implements TopicManager {
        private static final Logger log = LoggerFactory.getLogger(Impl.class);
        private final Communicator communicator;

        public Impl(Communicator communicator) {
            this.communicator = communicator;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof TopicMessage) {
                TopicMessage msg = (TopicMessage)event;
                try {
                    TopicManagerPrx topicManager = this.managerOrNull();
                    if (topicManager == null) {
                        log.warn("No topic manager");
                        return;
                    }
                    ObjectPrx obj = this.publisherOrNull(msg.topic);
                    msg.base.__copyFrom(obj);
                    Method m = null;
                    for (Method check : msg.base.getClass().getMethods()) {
                        if (!check.getName().equals(msg.method) || check.getParameterTypes().length != msg.args.length) continue;
                        if (m != null) {
                            String err = String.format("More than one method named \"%s\" with %s arguments", msg.method, msg.args);
                            log.error(err);
                            continue;
                        }
                        m = check;
                    }
                    if (m == null) {
                        log.error(String.format("No method named \"%s\" with %s arguments", msg.method, msg.args));
                    } else {
                        m.invoke((Object)msg.base, msg.args);
                    }
                }
                catch (NoEndpointException nee) {
                    log.debug("Ice.NoEndpointException");
                }
                catch (Exception e) {
                    log.error("Error publishing to topic:" + msg.topic, e);
                }
            }
        }

        @Override
        public void register(String topicName, ObjectPrx prx, boolean strict) throws ServerError {
            String id = prx.ice_id();
            id = id.replaceFirst("::", "");
            id = id.replace("::", ".");
            id = id + "PrxHelper";
            Class<?> pubClass = null;
            try {
                pubClass = Class.forName(id);
            }
            catch (ClassNotFoundException e) {
                throw new ApiUsageException(null, null, "Unknown type for proxy: " + prx.ice_id());
            }
            TopicPrx topic = this.topicOrNull(topicName);
            while (topic != null) {
                try {
                    topic.subscribeAndGetPublisher(null, prx);
                    break;
                }
                catch (UnknownException ue) {
                    log.warn("Unknown exception on subscribeAndGetPublisher");
                }
                catch (AlreadySubscribed e) {
                    if (!strict) break;
                    throw new ApiUsageException(null, null, "Proxy already subscribed: " + prx);
                }
                catch (BadQoS e) {
                    throw new InternalException(null, null, "BadQos in TopicManager.subscribe");
                }
                catch (UserException ue) {
                    log.warn("Invalid subscriber on subscribeAndGetPublisher");
                }
            }
        }

        @Override
        public void unregister(String topicName, ObjectPrx prx) throws ServerError {
            try {
                TopicPrx topic = this.topicOrNull(topicName);
                if (topic != null) {
                    topic.unsubscribe(prx);
                }
            }
            catch (Exception e) {
                log.warn(String.format("Error unregistering: %s from %s", prx, topicName));
            }
        }

        protected TopicManagerPrx managerOrNull() {
            ObjectPrx objectPrx = this.communicator.stringToProxy("IceGrid/Query");
            ObjectPrx[] candidates = null;
            try {
                QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
                candidates = query.findAllObjectsByType("::IceStorm::TopicManager");
            }
            catch (CommunicatorDestroyedException cde) {
                return null;
            }
            catch (NoEndpointException nee) {
                log.debug("Ice.NoEndpointException");
            }
            catch (Exception e) {
                log.warn("Error querying for topic manager", e);
            }
            TopicManagerPrx tm = null;
            if (candidates == null || candidates.length == 0) {
                log.warn("Found no topic manager");
            } else if (candidates.length > 1) {
                log.warn("Found wrong number of topic managers: " + candidates.length);
            } else {
                try {
                    tm = TopicManagerPrxHelper.checkedCast((ObjectPrx)candidates[0]);
                }
                catch (Exception e) {
                    log.warn("Could not cast to TopicManager", e);
                }
            }
            return tm;
        }

        protected TopicPrx topicOrNull(String name) {
            TopicManagerPrx topicManager = this.managerOrNull();
            TopicPrx topic = null;
            if (topicManager != null) {
                try {
                    topic = topicManager.create(name);
                }
                catch (TopicExists ex2) {
                    try {
                        topic = topicManager.retrieve(name);
                    }
                    catch (NoSuchTopic e) {
                        throw new RuntimeException("Race condition retriving topic: " + name);
                    }
                }
            }
            return topic;
        }

        protected ObjectPrx publisherOrNull(String name) {
            TopicPrx topic = this.topicOrNull(name);
            ObjectPrx pub = null;
            if (topic != null) {
                pub = topic.getPublisher().ice_oneway();
            }
            return pub;
        }
    }

    public static final class TopicMessage
    extends ApplicationEvent {
        private final String topic;
        private final ObjectPrxHelperBase base;
        private final String method;
        private final Object[] args;

        public TopicMessage(Object source, String topic, ObjectPrxHelperBase base, String method, Object ... args) {
            super(source);
            this.topic = topic;
            this.base = base;
            this.method = method;
            this.args = args;
        }
    }
}

