/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionPrx;
import Glacier2.SessionPrxHelper;
import Glacier2.StringSetPrx;
import Glacier2._SessionManagerDisp;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.Util;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.logic.HardWiredInterceptor;
import ome.model.meta.Session;
import ome.security.SecuritySystem;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.fire.Ring;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.ConvertToBlitzExceptionMessage;
import ome.services.blitz.util.FindServiceFactoryMessage;
import ome.services.blitz.util.UnregisterServantMessage;
import ome.services.messages.DestroySessionMessage;
import ome.services.sessions.SessionManager;
import ome.services.sessions.events.ChangeSecurityContextEvent;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.util.messages.InternalMessage;
import ome.util.messages.MessageException;
import omero.ConcurrencyException;
import omero.WrappedCreateSessionException;
import omero.api.ClientCallbackPrxHelper;
import omero.api._ServiceFactoryTie;
import omero.cmd.SessionI;
import omero.util.ServantHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public final class SessionManagerI
extends _SessionManagerDisp
implements ApplicationContextAware,
ApplicationListener<InternalMessage> {
    private static final List<HardWiredInterceptor> CPTORS = HardWiredInterceptor.parse(new String[]{"ome.security.basic.BasicSecurityWiring"});
    private static final Logger log = LoggerFactory.getLogger(SessionManagerI.class);
    protected OmeroContext context;
    protected final ObjectAdapter adapter;
    protected final SecuritySystem securitySystem;
    protected final SessionManager sessionManager;
    protected final Executor executor;
    protected final Ring ring;
    protected final Registry registry;
    protected final TopicManager topicManager;
    protected final AtomicBoolean loaded = new AtomicBoolean(false);
    protected final int servantsPerSession;
    protected final Cache<String, ServantHolder> sessionToHolder = CacheBuilder.newBuilder().build();

    public SessionManagerI(Ring ring, ObjectAdapter adapter, SecuritySystem secSys, SessionManager sessionManager, Executor executor, TopicManager topicManager, Registry reg, int servantsPerSession) {
        this.ring = ring;
        this.registry = reg;
        this.adapter = adapter;
        this.executor = executor;
        this.securitySystem = secSys;
        this.topicManager = topicManager;
        this.sessionManager = sessionManager;
        this.servantsPerSession = servantsPerSession;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (OmeroContext)applicationContext;
        HardWiredInterceptor.configure(CPTORS, this.context);
        this.loaded.set(true);
    }

    @Override
    public SessionPrx create(String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        if (!this.loaded.get()) {
            WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
            wrapped.backOff = 1000L;
            wrapped.concurrency = true;
            wrapped.reason = "Server not fully initialized";
            wrapped.type = "ApiUsageException";
            throw wrapped;
        }
        try {
            String event;
            SessionPrx sf;
            ServiceFactoryI.clientId(current);
            boolean local = false;
            try {
                Session o = this.sessionManager.find(userId);
                local = o != null;
                log.info("Found session locally: " + userId);
            }
            catch (Exception e) {
                log.debug("Exception while waiting on SessionManager.find " + e);
            }
            if (!local && (sf = this.ring.getProxyOrNull(userId, control, current)) != null) {
                return sf;
            }
            Roles roles = this.securitySystem.getSecurityRoles();
            String group = this.getGroup(current);
            if (group == null) {
                group = roles.getUserGroupName();
            }
            if ((event = this.getEvent(current)) == null) {
                event = "User";
            }
            String agent = this.getAgent(current);
            String ip = this.getIP(current);
            Principal p = new Principal(userId, group, event);
            final Session s = this.sessionManager.createWithAgent(p, agent, ip);
            Principal sp = new Principal(s.getUuid(), group, event);
            boolean needsNewSession = this.sessionToHolder.getIfPresent(s.getUuid()) == null;
            ServantHolder holder = this.sessionToHolder.get(s.getUuid(), new Callable<ServantHolder>(){

                @Override
                public ServantHolder call() {
                    return new ServantHolder(s.getUuid(), SessionManagerI.this.servantsPerSession);
                }
            });
            ServiceFactoryI session = new ServiceFactoryI(local, current, holder, control, this.context, this.sessionManager, this.executor, sp, CPTORS, this.topicManager, this.registry, this.ring.uuid);
            Identity id = session.sessionId();
            holder.addClientId(session.clientId);
            if (control != null) {
                StringSetPrx cat = control.categories();
                cat.add(new String[]{id.category});
                cat.add(new String[]{id.name});
            }
            _ServiceFactoryTie tie = new _ServiceFactoryTie(session);
            ObjectPrx _prx = current.adapter.add(tie, id);
            if (needsNewSession) {
                log.info(String.format("Created session %s for user %s (agent=%s)", session, userId, agent));
            } else if (log.isInfoEnabled()) {
                log.info(String.format("Rejoining session %s (agent=%s)", session, agent));
            }
            return SessionPrxHelper.uncheckedCast(_prx);
        }
        catch (Exception t) {
            if (t instanceof CannotCreateSessionException) {
                throw (CannotCreateSessionException)t;
            }
            if (t instanceof ome.conditions.ConcurrencyException || t instanceof ConcurrencyException) {
                long backOff = t instanceof ConcurrencyException ? ((ConcurrencyException)t).backOff : ((ome.conditions.ConcurrencyException)t).backOff;
                WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
                wrapped.backOff = backOff;
                wrapped.type = t.getClass().getName();
                wrapped.concurrency = true;
                wrapped.reason = "ConcurrencyException: " + t.getMessage() + "\nPlease retry in " + backOff + "ms. Cause: " + t.getMessage();
                throw wrapped;
            }
            ConvertToBlitzExceptionMessage convert = new ConvertToBlitzExceptionMessage(this, t);
            try {
                this.context.publishMessage(convert);
            }
            catch (Throwable t2) {
                log.error("Error while converting exception:", t2);
            }
            if (convert.to instanceof CannotCreateSessionException) {
                throw (CannotCreateSessionException)convert.to;
            }
            if (!(t instanceof omero.ApiUsageException || t instanceof ApiUsageException || t instanceof SecurityViolation)) {
                log.error("Error while creating ServiceFactoryI", t);
            }
            WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
            wrapped.backOff = -1L;
            wrapped.concurrency = false;
            wrapped.reason = t.getMessage();
            wrapped.type = t.getClass().getName();
            wrapped.setStackTrace(t.getStackTrace());
            throw wrapped;
        }
    }

    public void onApplicationEvent(InternalMessage event) {
        try {
            if (event instanceof UnregisterServantMessage) {
                UnregisterServantMessage msg = (UnregisterServantMessage)event;
                Current curr = msg.getCurrent();
                ServantHolder holder = msg.getHolder();
                SessionI.unregisterServant(curr.id, this.adapter, holder);
            } else if (event instanceof FindServiceFactoryMessage) {
                FindServiceFactoryMessage msg = (FindServiceFactoryMessage)event;
                Identity id = msg.getIdentity();
                if (id == null) {
                    Current curr = msg.getCurrent();
                    id = this.getServiceFactoryIdentity(curr);
                }
                ServiceFactoryI sf = this.getServiceFactory(id);
                msg.setServiceFactory(id, sf);
            } else if (event instanceof DestroySessionMessage) {
                DestroySessionMessage msg = (DestroySessionMessage)event;
                this.reapSession(msg.getSessionId());
            } else if (event instanceof ChangeSecurityContextEvent) {
                ChangeSecurityContextEvent csce = (ChangeSecurityContextEvent)event;
                this.checkStatefulServices(csce);
            }
        }
        catch (Throwable t) {
            throw new MessageException("SessionManagerI.onApplicationEvent", t);
        }
    }

    void checkStatefulServices(ChangeSecurityContextEvent csce) {
        String uuid = csce.getUuid();
        ServantHolder holder = this.sessionToHolder.getIfPresent(uuid);
        if (holder == null) {
            return;
        }
        String servants = holder.getStatefulServiceCount();
        if (servants.length() > 0) {
            String msg = uuid + " has active stateful services:\n" + servants;
            log.debug(msg);
            csce.cancel(msg);
        }
    }

    public void requestHeartBeats() {
        log.info("Performing requestHeartbeats");
        this.context.publishEvent(new TopicManager.TopicMessage(this, "/public/HeartBeat", new ClientCallbackPrxHelper(), "requestHeartbeat", new Object[0]));
    }

    public void reapSession(String sessionId) {
        ServantHolder holder = this.sessionToHolder.getIfPresent(sessionId);
        if (holder == null) {
            return;
        }
        this.sessionToHolder.invalidate(sessionId);
        Set<String> clientIds = holder.getClientIds();
        if (clientIds != null) {
            if (clientIds.size() > 0) {
                log.info("Reaping " + clientIds.size() + " clients for " + sessionId);
            }
            for (String clientId : clientIds) {
                try {
                    ServiceFactoryI sf = this.getServiceFactory(clientId, sessionId);
                    if (sf == null) continue;
                    sf.doDestroy();
                    Identity id = sf.sessionId();
                    log.info("Removing " + sf);
                    this.adapter.remove(id);
                }
                catch (ObjectAdapterDeactivatedException oade) {
                    log.warn("Cannot reap session " + sessionId + " from client " + clientId + " since adapter is deactivated. Skipping rest");
                    return;
                }
                catch (Exception e) {
                    log.error("Error reaping session " + sessionId + " from client " + clientId, e);
                }
            }
            List<String> servantIds = holder.getServantList();
            if (servantIds.size() > 0) {
                log.warn(String.format("Reaping all remaining servants for %s: Count=%s", sessionId, servantIds.size()));
                SessionI.cleanServants(true, null, holder, this.adapter);
            }
        }
    }

    protected ServiceFactoryI getServiceFactory(String clientId, String sessionId) {
        Identity iid = ServiceFactoryI.sessionId(clientId, sessionId);
        return this.getServiceFactory(iid);
    }

    protected ServiceFactoryI getServiceFactory(Identity iid) {
        Ice.Object obj = this.adapter.find(iid);
        if (obj == null) {
            log.debug(Util.identityToString(iid) + " already removed.");
            return null;
        }
        if (obj instanceof _ServiceFactoryTie) {
            _ServiceFactoryTie tie = (_ServiceFactoryTie)obj;
            ServiceFactoryI sf = (ServiceFactoryI)tie.ice_delegate();
            return sf;
        }
        log.warn("Not a ServiceFactory: " + obj);
        return null;
    }

    protected Identity getServiceFactoryIdentity(Current curr) {
        Identity id;
        try {
            String clientId = ServiceFactoryI.clientId(curr);
            id = ServiceFactoryI.sessionId(clientId, curr.id.category);
        }
        catch (omero.ApiUsageException e) {
            throw new RuntimeException("Cannot create session id for servant:" + String.format("\nInfo:\n\tId:%s\n\tOp:%s\n\tCtx:%s", Util.identityToString(curr.id), curr.operation, curr.ctx), e);
        }
        return id;
    }

    protected String getGroup(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return current.ctx.get("omero.group");
    }

    protected String getAgent(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return current.ctx.get("omero.agent");
    }

    protected String getIP(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return current.ctx.get("omero.ip");
    }

    protected String getEvent(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return current.ctx.get("omero.event");
    }
}

