/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.model.meta.Node;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.redirect.NullRedirector;
import ome.services.blitz.redirect.Redirector;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import omero.grid.ClusterNodePrx;
import omero.grid.ClusterNodePrxHelper;
import omero.grid._ClusterNodeDisp;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class Ring
extends _ClusterNodeDisp
implements Redirector.Context {
    private static final Logger log = LoggerFactory.getLogger(Ring.class);
    public final String uuid;
    public final Principal principal;
    private final Executor executor;
    private final Redirector redirector;
    private Communicator communicator;
    private Registry registry;
    private ObjectAdapter adapter;
    private String directProxy;

    public Ring(String uuid, Executor executor) {
        this(uuid, executor, new NullRedirector());
    }

    public Ring(String uuid, Executor executor, Redirector redirector) {
        this.uuid = uuid;
        this.executor = executor;
        this.redirector = redirector;
        this.principal = new Principal(uuid, "system", "Internal");
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public Principal principal() {
        return this.principal;
    }

    @Override
    public String getDirectProxy() {
        return this.directProxy;
    }

    @Override
    public Communicator getCommunicator() {
        return this.communicator;
    }

    public void init(ObjectAdapter adapter, String directProxy) {
        this.adapter = adapter;
        this.communicator = adapter.getCommunicator();
        this.directProxy = directProxy;
        Set<String> nodeUuids = this.checkCluster();
        if (nodeUuids == null) {
            log.warn("No clusters found. Aborting ring initialization");
            return;
        }
        try {
            Identity clusterNode = this.communicator.stringToIdentity("ClusterNode/" + this.uuid);
            this.adapter.add(this, clusterNode);
            this.addManager(this.uuid, directProxy);
            this.registry.addObject(this.adapter.createDirectProxy(clusterNode));
            nodeUuids.add(this.uuid);
            this.redirector.chooseNextRedirect(this, nodeUuids);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register self as node: ", e);
        }
    }

    public Set<String> checkCluster() {
        log.info("Checking cluster");
        ClusterNodePrx[] nodes = this.registry.lookupClusterNodes();
        if (nodes == null) {
            log.error("Could not lookup nodes. Skipping initialization...");
            return null;
        }
        HashSet<String> nodeUuids = new HashSet<String>();
        for (int i = 0; i < nodes.length; ++i) {
            ClusterNodePrx prx = nodes[i];
            if (prx == null) {
                log.warn("Null proxy found");
                continue;
            }
            try {
                nodeUuids.add(nodes[i].getNodeUuid());
                continue;
            }
            catch (Exception e) {
                log.warn("Error getting uuid from node " + nodes[i] + " -- removing.");
                this.registry.removeObjectSafely(prx.ice_getIdentity());
            }
        }
        log.info("Got " + nodeUuids.size() + " cluster uuids : " + nodeUuids);
        this.assertNodes(nodeUuids);
        return nodeUuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            Identity id = this.communicator.stringToIdentity("ClusterNode/" + this.uuid);
            this.registry.removeObjectSafely(id);
            this.redirector.handleRingShutdown(this, this.uuid);
            int count = this.closeSessionsForManager(this.uuid);
            log.info("Removed " + count + " entries for " + this.uuid);
            log.info("Disconnected from OMERO.cluster");
        }
        catch (Exception e) {
            log.error("Error stopping ring " + this, e);
        }
        finally {
            Object[] nodes = null;
            try {
                nodes = this.registry.lookupClusterNodes();
                if (nodes != null) {
                    for (Object clusterNodePrx : nodes) {
                        try {
                            clusterNodePrx = ClusterNodePrxHelper.uncheckedCast(clusterNodePrx.ice_oneway());
                            clusterNodePrx.down(this.uuid);
                        }
                        catch (Exception e) {
                            String msg = "Error signaling down to " + clusterNodePrx;
                            log.warn(msg, e);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Error signaling down to: " + Arrays.deepToString(nodes), e);
            }
        }
    }

    @Override
    public String getNodeUuid(Current __current) {
        return this.uuid;
    }

    @Override
    public void down(String downUuid, Current __current) {
        this.redirector.handleRingShutdown(this, downUuid);
    }

    public boolean checkPassword(final String userId) {
        return (Boolean)this.executor.executeSql(new Executor.SimpleSqlWork(this, "checkPassword", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return sql.activeSession(userId);
            }
        });
    }

    public SessionPrx getProxyOrNull(String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        return this.redirector.getProxyOrNull(this, userId, control, current);
    }

    public Set<String> knownManagers() {
        return this.getManagerList(true);
    }

    public void assertNodes(Set<String> nodeUuids) {
        Set<String> managers = this.knownManagers();
        for (String manager : managers) {
            if (nodeUuids.contains(manager) || this.uuid.equals(manager) || "000000000000000000000000000000000000".equals(manager)) continue;
            this.purgeNode(manager);
        }
    }

    protected void purgeNode(String manager) {
        log.info("Purging node: " + manager);
        try {
            Identity id = this.communicator.stringToIdentity("ClusterNode/" + manager);
            this.registry.removeObjectSafely(id);
            int count = this.closeSessionsForManager(manager);
            log.info("Removed " + count + " entries with value " + manager);
            this.setManagerDown(manager);
            log.info("Removed manager: " + manager);
            this.redirector.handleRingShutdown(this, manager);
            log.info("handleRingShutdown: " + manager);
        }
        catch (Exception e) {
            log.error("Failed to purge node " + manager, e);
        }
    }

    @Override
    public Set<String> getManagerList(final boolean onlyActive) {
        return (Set)this.executor.execute(this.principal, new Executor.SimpleWork(this, "getManagerList", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List<Node> nodes = sf.getQueryService().findAll(Node.class, null);
                HashSet<String> nodeIds = new HashSet<String>();
                for (Node node : nodes) {
                    if (onlyActive && node.getDown() != null) continue;
                    nodeIds.add(node.getUuid());
                }
                return nodeIds;
            }
        });
    }

    private int closeSessionsForManager(final String managerUuid) {
        return (Integer)this.executor.execute(this.principal, new Executor.SimpleWork(this, "executeUpdate - set closed = now()", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().closeNodeSessions(managerUuid);
            }
        });
    }

    private void setManagerDown(final String managerUuid) {
        this.executor.execute(this.principal, new Executor.SimpleWork(this, "setManagerDown", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().closeNode(managerUuid);
            }
        });
    }

    private Node addManager(String managerUuid, String proxyString) {
        final Node node = new Node();
        node.setConn(proxyString);
        node.setUuid(managerUuid);
        node.setUp(new Timestamp(System.currentTimeMillis()));
        return (Node)this.executor.execute(this.principal, new Executor.SimpleWork(this, "addManager", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getUpdateService().saveAndReturnObject(node);
            }
        });
    }
}

