/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ome.annotations.RolesAllowed;
import ome.api.Search;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.internal.Details;
import ome.parameters.Parameters;
import ome.services.AbstractStatefulBean;
import ome.services.search.AnnotatedWith;
import ome.services.search.Complement;
import ome.services.search.FullText;
import ome.services.search.HqlQuery;
import ome.services.search.Intersection;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.services.search.SimilarTerms;
import ome.services.search.SomeMustNone;
import ome.services.search.TagsAndGroups;
import ome.services.search.Union;
import ome.services.util.Executor;
import org.apache.lucene.analysis.Analyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SearchBean
extends AbstractStatefulBean
implements Search {
    private static final long serialVersionUID = 59809384038000069L;
    private static final Logger log = LoggerFactory.getLogger(SearchBean.class);
    private final ActionList actions = new ActionList();
    private final SearchValues values = new SearchValues();
    private final List<List<IObject>> results = new ArrayList<List<IObject>>();
    private transient Executor executor;
    private transient Class<? extends Analyzer> analyzer;
    private transient Integer maxClauseCount;

    public SearchBean(Executor executor, Class<? extends Analyzer> analyzer) {
        this.executor = executor;
        this.analyzer = analyzer;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return Search.class;
    }

    public SearchBean() {
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setAnalyzer(Class<? extends Analyzer> analyzer) {
        this.analyzer = analyzer;
    }

    public void setMaxClauseCount(Integer maxClauseCount) {
        this.maxClauseCount = maxClauseCount;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void passivate() {
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void activate() {
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byAnnotatedWith(Annotation ... examples) {
        AnnotatedWith byAnnotatedWith;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byAnnotatedWith = new AnnotatedWith(this.values, examples, false, false);
        }
        this.actions.add(byAnnotatedWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byFullText(String query) {
        FullText byFullText;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byFullText = new FullText(this.values, query, this.analyzer);
        }
        this.actions.add(byFullText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byLuceneQueryBuilder(String fields, String from, String to, String dateType, String query) {
        FullText byFullText;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byFullText = new FullText(this.values, fields, from, to, dateType, query, this.analyzer);
        }
        this.actions.add(byFullText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byHqlQuery(String query, Parameters p) {
        HqlQuery byHqlQuery;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byHqlQuery = new HqlQuery(this.values, query, p);
        }
        this.actions.add(byHqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void bySomeMustNone(String[] some, String[] must, String[] none) {
        SomeMustNone bySomeMustNone;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            bySomeMustNone = new SomeMustNone(this.values, some, must, none, this.analyzer);
        }
        this.actions.add(bySomeMustNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void bySimilarTerms(String ... terms) {
        SimilarTerms bySimilarTerms;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            bySimilarTerms = new SimilarTerms(this.values, terms);
        }
        this.actions.add(bySimilarTerms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byGroupForTags(String group) {
        TagsAndGroups byTags;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byTags = new TagsAndGroups(this.values, group, false);
        }
        this.actions.add(byTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void byTagForGroups(String tag) {
        TagsAndGroups byTags;
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            byTags = new TagsAndGroups(this.values, tag, true);
        }
        this.actions.add(byTags);
    }

    @Transactional
    @RolesAllowed(value={"user"})
    public void byUUID(String[] uuids) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void or() {
        this.actions.union();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void and() {
        this.actions.intersection();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void not() {
        this.actions.complement();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean hasNext() {
        while (this.results.size() > 0) {
            List<IObject> first = this.results.get(0);
            if (first == null || first.size() < 1) {
                this.results.remove(0);
                continue;
            }
            return true;
        }
        if (this.actions.size() == 0) {
            return false;
        }
        SearchAction action = this.actions.popFirst();
        List list = (List)this.executor.execute(null, action);
        this.results.add(list);
        return this.hasNext();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public IObject next() throws ApiUsageException {
        if (!this.hasNext()) {
            throw new ApiUsageException("No element. Please use hasNext().");
        }
        return this.pop(this.results.get(0));
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public Map<String, Annotation> currentMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public List<Map<String, Annotation>> currentMetadataList() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public <T extends IObject> List<T> results() {
        if (!this.hasNext()) {
            throw new ApiUsageException("No elements. Please use hasNext().");
        }
        ArrayList<IObject> rv = new ArrayList<IObject>();
        while (this.hasNext() && rv.size() < this.values.batchSize) {
            List<IObject> current = this.results.get(0);
            if (current.size() > 0) {
                rv.add(this.pop(current));
                continue;
            }
            if (this.values.mergedBatches) continue;
            break;
        }
        return rv;
    }

    protected IObject pop(List<IObject> current) {
        IObject obj = current.remove(0);
        if (this.values.returnUnloaded) {
            obj.unload();
        }
        return obj;
    }

    @Transactional
    @RolesAllowed(value={"user"})
    public void lastresultsAsWorkingGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove via ome.api.Search");
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public int activeQueries() {
        return this.actions.size();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void clearQueries() {
        this.actions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void resetDefaults() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.copy(new SearchValues());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void addOrderByAsc(String path) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.orderBy.add("A" + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void addOrderByDesc(String path) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.orderBy.add("D" + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void unordered() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.orderBy.clear();
        }
    }

    @Transactional
    @RolesAllowed(value={"user"})
    public <T extends IObject> void fetchAlso(Map<T, String> fetches) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void fetchAnnotations(Class ... classes) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.fetchAnnotations = new ArrayList<Class>();
            for (Class k : classes) {
                this.values.fetchAnnotations.add(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public int getBatchSize() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.batchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean isCaseSensitive() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.caseSensitive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean isMergedBatches() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.mergedBatches;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyAnnotatedBetween(Timestamp start, Timestamp stop) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.annotatedStart = SearchValues.copyTimestamp(start);
            this.values.annotatedStop = SearchValues.copyTimestamp(stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyAnnotatedBy(Details d) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.annotatedBy = SearchValues.copyDetails(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void notAnnotatedBy(Details d) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.notAnnotatedBy = SearchValues.copyDetails(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyAnnotatedWith(Class ... classes) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            if (classes == null) {
                this.values.onlyAnnotatedWith = null;
            } else {
                List<Class> list = Arrays.asList(classes);
                this.values.onlyAnnotatedWith = SearchValues.copyList(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyCreatedBetween(Timestamp start, Timestamp stop) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.createdStart = SearchValues.copyTimestamp(start);
            this.values.createdStop = SearchValues.copyTimestamp(stop);
            if (start != null && stop != null && stop.getTime() < start.getTime()) {
                log.warn("FullText search created with creation stop before start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyOwnedBy(Details d) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.ownedBy = SearchValues.copyDetails(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyIds(Long ... ids) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.onlyIds = ids == null ? null : Arrays.asList(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void notOwnedBy(Details d) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.notOwnedBy = SearchValues.copyDetails(d);
        }
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void allTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public <T extends IObject> void onlyType(Class<T> klass) {
        this.onlyTypes(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public <T extends IObject> void onlyTypes(Class<T> ... classes) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.onlyTypes = new ArrayList<Class>();
            for (Class<T> k : classes) {
                this.values.onlyTypes.add(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.leadingWildcard = allowLeadingWildcard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setBatchSize(int size) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.batchSize = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @RolesAllowed(value={"user"})
    public void setIdOnly() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.idOnly = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setMergedBatches(boolean merge) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.mergedBatches = merge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void fetchAlso(String ... fetches) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.fetches = Arrays.asList(fetches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean isAllowLeadingWildcard() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.leadingWildcard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean isReturnUnloaded() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.returnUnloaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public boolean isUseProjections() {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            return this.values.useProjections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void onlyModifiedBetween(Timestamp start, Timestamp stop) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.modifiedStart = SearchValues.copyTimestamp(start);
            this.values.modifiedStop = SearchValues.copyTimestamp(stop);
            if (start != null && stop != null && stop.getTime() < start.getTime()) {
                log.warn("FullText search created with modification stop before start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setCaseSentivice(boolean caseSensitive) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.caseSensitive = caseSensitive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setReturnUnloaded(boolean returnUnloaded) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.returnUnloaded = returnUnloaded;
        }
    }

    @Override
    @Transactional
    @RolesAllowed(value={"user"})
    public void setUseProjections(boolean useProjections) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(SearchAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null");
        }
        ActionList actionList = this.actions;
        synchronized (actionList) {
            this.actions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(List<IObject> result) {
        List<List<IObject>> list = this.results;
        synchronized (list) {
            this.results.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameters(Parameters params) {
        SearchValues searchValues = this.values;
        synchronized (searchValues) {
            this.values.copy(params);
        }
    }

    private static class ActionList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private State state = State.normal;
        private final List<SearchAction> actions = new ArrayList<SearchAction>();

        private ActionList() {
        }

        synchronized void union() {
            this.state = State.union;
        }

        synchronized void intersection() {
            this.state = State.intersection;
        }

        synchronized void complement() {
            this.state = State.complement;
        }

        synchronized void add(SearchAction b) {
            State previousState = this.state;
            this.state = State.normal;
            switch (previousState) {
                case normal: {
                    this.actions.add(b);
                    break;
                }
                case union: {
                    SearchAction a = this.popLast();
                    this.actions.add(new Union(b.copyOfValues(), a, b));
                    break;
                }
                case intersection: {
                    SearchAction a = this.popLast();
                    this.actions.add(new Intersection(b.copyOfValues(), a, b));
                    break;
                }
                case complement: {
                    SearchAction a = this.popLast();
                    this.actions.add(new Complement(b.copyOfValues(), a, b));
                    break;
                }
                default: {
                    throw new InternalException("Unknown state:" + (Object)((Object)this.state));
                }
            }
        }

        synchronized int size() {
            return this.actions.size();
        }

        synchronized void clear() {
            this.actions.clear();
        }

        synchronized SearchAction popFirst() {
            this.assertNonZero();
            return this.actions.remove(0);
        }

        synchronized SearchAction popLast() {
            this.assertNonZero();
            return this.actions.remove(this.actions.size() - 1);
        }

        synchronized void assertNonZero() {
            if (this.actions.size() == 0) {
                throw new ApiUsageException("There must be at least 1 active query for this operation.");
            }
        }

        static enum State {
            normal,
            union,
            intersection,
            complement;

        }
    }
}

